/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.lang.ref.SoftReference;
import java.net.Socket;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.jsse.BCExtendedSSLSession;
import org.bouncycastle.jsse.BCSNIHostName;
import org.bouncycastle.jsse.BCX509ExtendedKeyManager;
import org.bouncycastle.jsse.BCX509Key;
import org.bouncycastle.jsse.java.security.BCAlgorithmConstraints;
import org.bouncycastle.jsse.provider.JsseUtils;
import org.bouncycastle.jsse.provider.KeyStoreUtil;
import org.bouncycastle.jsse.provider.PropertyUtils;
import org.bouncycastle.jsse.provider.ProvAlgorithmChecker;
import org.bouncycastle.jsse.provider.ProvX509Key;
import org.bouncycastle.jsse.provider.ProvX509TrustManager;
import org.bouncycastle.jsse.provider.TransportData;
import org.bouncycastle.tls.NamedGroup;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.TlsUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProvX509KeyManager
extends BCX509ExtendedKeyManager {
    private static final Logger LOG = Logger.getLogger(ProvX509KeyManager.class.getName());
    private static final boolean provKeyManagerCheckEKU = PropertyUtils.getBooleanSystemProperty("org.bouncycastle.jsse.keyManager.checkEKU", true);
    private final AtomicLong versions = new AtomicLong();
    private final boolean isInFipsMode;
    private final JcaJceHelper helper;
    private final List<KeyStore.Builder> builders;
    private final Map<String, SoftReference<KeyStore.PrivateKeyEntry>> cachedEntries = Collections.synchronizedMap(new LinkedHashMap<String, SoftReference<KeyStore.PrivateKeyEntry>>(16, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, SoftReference<KeyStore.PrivateKeyEntry>> eldest) {
            return this.size() > 16;
        }
    });
    private static final Map<String, PublicKeyFilter> FILTERS_CLIENT = ProvX509KeyManager.createFiltersClient();
    private static final Map<String, PublicKeyFilter> FILTERS_SERVER = ProvX509KeyManager.createFiltersServer();

    private static void addECFilter13(Map<String, PublicKeyFilter> filters, int namedGroup13) {
        ASN1ObjectIdentifier standardOID;
        if (!NamedGroup.canBeNegotiated(namedGroup13, ProtocolVersion.TLSv13)) {
            throw new IllegalStateException("Invalid named group for TLS 1.3 EC filter");
        }
        String curveName = NamedGroup.getCurveName(namedGroup13);
        if (null != curveName && null != (standardOID = ECNamedCurveTable.getOID(curveName))) {
            String keyType = JsseUtils.getKeyType13("EC", namedGroup13);
            ECPublicKeyFilter13 filter = new ECPublicKeyFilter13(standardOID);
            ProvX509KeyManager.addFilterToMap(filters, keyType, filter);
            return;
        }
        LOG.warning("Failed to register public key filter for EC with " + NamedGroup.getText(namedGroup13));
    }

    private static void addFilter(Map<String, PublicKeyFilter> filters, String keyType) {
        String algorithm = keyType;
        ProvX509KeyManager.addFilter(filters, 0, algorithm, null, keyType);
    }

    private static void addFilter(Map<String, PublicKeyFilter> filters, Class<? extends PublicKey> clazz, String ... keyTypes) {
        ProvX509KeyManager.addFilter(filters, 0, null, clazz, keyTypes);
    }

    private static void addFilter(Map<String, PublicKeyFilter> filters, int keyUsageBit, String algorithm, Class<? extends PublicKey> clazz, String ... keyTypes) {
        DefaultPublicKeyFilter filter = new DefaultPublicKeyFilter(algorithm, clazz, keyUsageBit);
        for (String keyType : keyTypes) {
            ProvX509KeyManager.addFilterToMap(filters, keyType, filter);
        }
    }

    private static void addFilterLegacyServer(Map<String, PublicKeyFilter> filters, String algorithm, int ... keyExchangeAlgorithms) {
        ProvX509KeyManager.addFilterLegacyServer(filters, 0, algorithm, keyExchangeAlgorithms);
    }

    private static void addFilterLegacyServer(Map<String, PublicKeyFilter> filters, int keyUsageBit, String algorithm, int ... keyExchangeAlgorithms) {
        ProvX509KeyManager.addFilterLegacyServer(filters, keyUsageBit, algorithm, null, keyExchangeAlgorithms);
    }

    private static void addFilterLegacyServer(Map<String, PublicKeyFilter> filters, Class<? extends PublicKey> clazz, int ... keyExchangeAlgorithms) {
        ProvX509KeyManager.addFilterLegacyServer(filters, 0, null, clazz, keyExchangeAlgorithms);
    }

    private static void addFilterLegacyServer(Map<String, PublicKeyFilter> filters, int keyUsageBit, String algorithm, Class<? extends PublicKey> clazz, int ... keyExchangeAlgorithms) {
        ProvX509KeyManager.addFilter(filters, keyUsageBit, algorithm, clazz, ProvX509KeyManager.getKeyTypesLegacyServer(keyExchangeAlgorithms));
    }

    private static void addFilterToMap(Map<String, PublicKeyFilter> filters, String keyType, PublicKeyFilter filter) {
        if (null != filters.put(keyType, filter)) {
            throw new IllegalStateException("Duplicate keys in filters");
        }
    }

    private static Map<String, PublicKeyFilter> createFiltersClient() {
        HashMap<String, PublicKeyFilter> filters = new HashMap<String, PublicKeyFilter>();
        ProvX509KeyManager.addFilter(filters, "Ed25519");
        ProvX509KeyManager.addFilter(filters, "Ed448");
        ProvX509KeyManager.addECFilter13(filters, 31);
        ProvX509KeyManager.addECFilter13(filters, 32);
        ProvX509KeyManager.addECFilter13(filters, 33);
        ProvX509KeyManager.addECFilter13(filters, 23);
        ProvX509KeyManager.addECFilter13(filters, 24);
        ProvX509KeyManager.addECFilter13(filters, 25);
        ProvX509KeyManager.addFilter(filters, "RSA");
        ProvX509KeyManager.addFilter(filters, "RSASSA-PSS");
        ProvX509KeyManager.addFilter(filters, DSAPublicKey.class, "DSA");
        ProvX509KeyManager.addFilter(filters, ECPublicKey.class, "EC");
        return Collections.unmodifiableMap(filters);
    }

    private static Map<String, PublicKeyFilter> createFiltersServer() {
        HashMap<String, PublicKeyFilter> filters = new HashMap<String, PublicKeyFilter>();
        ProvX509KeyManager.addFilter(filters, "Ed25519");
        ProvX509KeyManager.addFilter(filters, "Ed448");
        ProvX509KeyManager.addECFilter13(filters, 31);
        ProvX509KeyManager.addECFilter13(filters, 32);
        ProvX509KeyManager.addECFilter13(filters, 33);
        ProvX509KeyManager.addECFilter13(filters, 23);
        ProvX509KeyManager.addECFilter13(filters, 24);
        ProvX509KeyManager.addECFilter13(filters, 25);
        ProvX509KeyManager.addFilter(filters, "RSA");
        ProvX509KeyManager.addFilter(filters, "RSASSA-PSS");
        ProvX509KeyManager.addFilterLegacyServer(filters, DSAPublicKey.class, 3, 22);
        ProvX509KeyManager.addFilterLegacyServer(filters, ECPublicKey.class, 17);
        ProvX509KeyManager.addFilterLegacyServer(filters, "RSA", 5, 19, 23);
        ProvX509KeyManager.addFilterLegacyServer(filters, 2, "RSA", 1);
        return Collections.unmodifiableMap(filters);
    }

    private static String[] getKeyTypesLegacyServer(int ... keyExchangeAlgorithms) {
        int count = keyExchangeAlgorithms.length;
        String[] keyTypes = new String[count];
        for (int i = 0; i < count; ++i) {
            keyTypes[i] = JsseUtils.getKeyTypeLegacyServer(keyExchangeAlgorithms[i]);
        }
        return keyTypes;
    }

    ProvX509KeyManager(boolean isInFipsMode, JcaJceHelper helper, List<KeyStore.Builder> builders) {
        this.isInFipsMode = isInFipsMode;
        this.helper = helper;
        this.builders = builders;
    }

    @Override
    public String chooseClientAlias(String[] keyTypes, Principal[] issuers, Socket socket) {
        return this.chooseAlias(ProvX509KeyManager.getKeyTypes(keyTypes), issuers, TransportData.from(socket), false);
    }

    @Override
    public BCX509Key chooseClientKeyBC(String[] keyTypes, Principal[] issuers, Socket socket) {
        return this.chooseKeyBC(ProvX509KeyManager.getKeyTypes(keyTypes), issuers, TransportData.from(socket), false);
    }

    @Override
    public String chooseEngineClientAlias(String[] keyTypes, Principal[] issuers, SSLEngine engine) {
        return this.chooseAlias(ProvX509KeyManager.getKeyTypes(keyTypes), issuers, TransportData.from(engine), false);
    }

    @Override
    public BCX509Key chooseEngineClientKeyBC(String[] keyTypes, Principal[] issuers, SSLEngine engine) {
        return this.chooseKeyBC(ProvX509KeyManager.getKeyTypes(keyTypes), issuers, TransportData.from(engine), false);
    }

    @Override
    public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
        return this.chooseAlias(ProvX509KeyManager.getKeyTypes(keyType), issuers, TransportData.from(engine), true);
    }

    @Override
    public BCX509Key chooseEngineServerKeyBC(String[] keyTypes, Principal[] issuers, SSLEngine engine) {
        return this.chooseKeyBC(ProvX509KeyManager.getKeyTypes(keyTypes), issuers, TransportData.from(engine), true);
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        return this.chooseAlias(ProvX509KeyManager.getKeyTypes(keyType), issuers, TransportData.from(socket), true);
    }

    @Override
    public BCX509Key chooseServerKeyBC(String[] keyTypes, Principal[] issuers, Socket socket) {
        return this.chooseKeyBC(ProvX509KeyManager.getKeyTypes(keyTypes), issuers, TransportData.from(socket), true);
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        KeyStore.PrivateKeyEntry entry = this.getPrivateKeyEntry(alias);
        return null == entry ? null : (X509Certificate[])entry.getCertificateChain();
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        return this.getAliases(ProvX509KeyManager.getKeyTypes(keyType), issuers, null, false);
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        KeyStore.PrivateKeyEntry entry = this.getPrivateKeyEntry(alias);
        return null == entry ? null : entry.getPrivateKey();
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return this.getAliases(ProvX509KeyManager.getKeyTypes(keyType), issuers, null, true);
    }

    @Override
    protected BCX509Key getKeyBC(String keyType, String alias) {
        KeyStore.PrivateKeyEntry entry = this.getPrivateKeyEntry(alias);
        if (null == entry) {
            return null;
        }
        PrivateKey privateKey = entry.getPrivateKey();
        if (null == privateKey) {
            return null;
        }
        Object[] certificateChain = JsseUtils.getX509CertificateChain(entry.getCertificateChain());
        if (TlsUtils.isNullOrEmpty(certificateChain)) {
            return null;
        }
        return new ProvX509Key(keyType, privateKey, (X509Certificate[])certificateChain);
    }

    private String chooseAlias(List<String> keyTypes, Principal[] issuers, TransportData transportData, boolean forServer) {
        Match bestMatch = this.getBestMatch(keyTypes, issuers, transportData, forServer);
        if (bestMatch.compareTo(Match.NOTHING) < 0) {
            String keyType = keyTypes.get(bestMatch.keyTypeIndex);
            String alias = ProvX509KeyManager.getAlias(bestMatch, this.getNextVersionSuffix());
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Found matching key of type: " + keyType + ", returning alias: " + alias);
            }
            return alias;
        }
        LOG.fine("No matching key found");
        return null;
    }

    private BCX509Key chooseKeyBC(List<String> keyTypes, Principal[] issuers, TransportData transportData, boolean forServer) {
        Match bestMatch = this.getBestMatch(keyTypes, issuers, transportData, forServer);
        if (bestMatch.compareTo(Match.NOTHING) < 0) {
            try {
                String keyType = keyTypes.get(bestMatch.keyTypeIndex);
                BCX509Key keyBC = this.createKeyBC(keyType, bestMatch.builderIndex, bestMatch.localAlias, bestMatch.cachedKeyStore, bestMatch.cachedCertificateChain);
                if (null != keyBC) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Found matching key of type: " + keyType + ", from alias: " + bestMatch.builderIndex + "." + bestMatch.localAlias);
                    }
                    return keyBC;
                }
            }
            catch (Exception e) {
                LOG.log(Level.FINER, "Failed to load private key", e);
            }
        }
        LOG.fine("No matching key found");
        return null;
    }

    private BCX509Key createKeyBC(String keyType, int builderIndex, String localAlias, KeyStore keyStore, X509Certificate[] certificateChain) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        KeyStore.Builder builder = this.builders.get(builderIndex);
        KeyStore.ProtectionParameter protectionParameter = builder.getProtectionParameter(localAlias);
        Key key = KeyStoreUtil.getKey(keyStore, localAlias, protectionParameter);
        if (key instanceof PrivateKey) {
            return new ProvX509Key(keyType, (PrivateKey)key, certificateChain);
        }
        return null;
    }

    private String[] getAliases(List<String> keyTypes, Principal[] issuers, TransportData transportData, boolean forServer) {
        if (!this.builders.isEmpty() && !keyTypes.isEmpty()) {
            int keyTypeLimit = keyTypes.size();
            Set<Principal> uniqueIssuers = ProvX509KeyManager.getUniquePrincipals(issuers);
            BCAlgorithmConstraints algorithmConstraints = TransportData.getAlgorithmConstraints(transportData, true);
            Date atDate = new Date();
            String requestedHostName = ProvX509KeyManager.getRequestedHostName(transportData, forServer);
            List<Match> matches = null;
            int count = this.builders.size();
            for (int builderIndex = 0; builderIndex < count; ++builderIndex) {
                try {
                    KeyStore.Builder builder = this.builders.get(builderIndex);
                    KeyStore keyStore = builder.getKeyStore();
                    if (null == keyStore) continue;
                    Enumeration<String> en = keyStore.aliases();
                    while (en.hasMoreElements()) {
                        String localAlias = en.nextElement();
                        Match match = this.getPotentialMatch(builderIndex, builder, keyStore, localAlias, keyTypes, keyTypeLimit, uniqueIssuers, algorithmConstraints, forServer, atDate, requestedHostName);
                        if (match.compareTo(Match.NOTHING) >= 0) continue;
                        matches = ProvX509KeyManager.addToMatches(matches, match);
                    }
                    continue;
                }
                catch (KeyStoreException e) {
                    LOG.log(Level.WARNING, "Failed to fully process KeyStore.Builder at index " + builderIndex, e);
                }
            }
            if (null != matches && !matches.isEmpty()) {
                Collections.sort(matches);
                return ProvX509KeyManager.getAliases(matches, this.getNextVersionSuffix());
            }
        }
        return null;
    }

    private Match getBestMatch(List<String> keyTypes, Principal[] issuers, TransportData transportData, boolean forServer) {
        Match bestMatchSoFar = Match.NOTHING;
        if (!this.builders.isEmpty() && !keyTypes.isEmpty()) {
            int keyTypeLimit = keyTypes.size();
            Set<Principal> uniqueIssuers = ProvX509KeyManager.getUniquePrincipals(issuers);
            BCAlgorithmConstraints algorithmConstraints = TransportData.getAlgorithmConstraints(transportData, true);
            Date atDate = new Date();
            String requestedHostName = ProvX509KeyManager.getRequestedHostName(transportData, forServer);
            int count = this.builders.size();
            for (int builderIndex = 0; builderIndex < count; ++builderIndex) {
                try {
                    KeyStore.Builder builder = this.builders.get(builderIndex);
                    KeyStore keyStore = builder.getKeyStore();
                    if (null == keyStore) continue;
                    Enumeration<String> en = keyStore.aliases();
                    while (en.hasMoreElements()) {
                        String localAlias = en.nextElement();
                        Match match = this.getPotentialMatch(builderIndex, builder, keyStore, localAlias, keyTypes, keyTypeLimit, uniqueIssuers, algorithmConstraints, forServer, atDate, requestedHostName);
                        if (match.compareTo(bestMatchSoFar) >= 0) continue;
                        bestMatchSoFar = match;
                        if (bestMatchSoFar.isIdeal()) {
                            return bestMatchSoFar;
                        }
                        if (!bestMatchSoFar.isValid()) continue;
                        keyTypeLimit = Math.min(keyTypeLimit, bestMatchSoFar.keyTypeIndex + 1);
                    }
                    continue;
                }
                catch (KeyStoreException e) {
                    LOG.log(Level.WARNING, "Failed to fully process KeyStore.Builder at index " + builderIndex, e);
                }
            }
        }
        return bestMatchSoFar;
    }

    private String getNextVersionSuffix() {
        return "." + this.versions.incrementAndGet();
    }

    private Match getPotentialMatch(int builderIndex, KeyStore.Builder builder, KeyStore keyStore, String localAlias, List<String> keyTypes, int keyTypeLimit, Set<Principal> uniqueIssuers, BCAlgorithmConstraints algorithmConstraints, boolean forServer, Date atDate, String requestedHostName) throws KeyStoreException {
        MatchQuality quality;
        X509Certificate[] chain;
        int keyTypeIndex;
        if (keyStore.isKeyEntry(localAlias) && (keyTypeIndex = ProvX509KeyManager.getPotentialKeyType(keyTypes, keyTypeLimit, uniqueIssuers, algorithmConstraints, forServer, chain = JsseUtils.getX509CertificateChain(keyStore.getCertificateChain(localAlias)))) >= 0 && MatchQuality.NONE != (quality = ProvX509KeyManager.getKeyTypeQuality(this.isInFipsMode, this.helper, keyTypes, algorithmConstraints, forServer, atDate, requestedHostName, chain, keyTypeIndex))) {
            return new Match(quality, keyTypeIndex, builderIndex, localAlias, keyStore, chain);
        }
        return Match.NOTHING;
    }

    private KeyStore.PrivateKeyEntry getPrivateKeyEntry(String alias) {
        KeyStore.PrivateKeyEntry cachedEntry;
        if (null == alias) {
            return null;
        }
        SoftReference<KeyStore.PrivateKeyEntry> entryRef = this.cachedEntries.get(alias);
        if (null != entryRef && null != (cachedEntry = entryRef.get())) {
            return cachedEntry;
        }
        KeyStore.PrivateKeyEntry result = this.loadPrivateKeyEntry(alias);
        if (null != result) {
            this.cachedEntries.put(alias, new SoftReference<KeyStore.PrivateKeyEntry>(result));
        }
        return result;
    }

    private KeyStore.PrivateKeyEntry loadPrivateKeyEntry(String alias) {
        try {
            int builderIndexStart = 0;
            int builderIndexEnd = alias.indexOf(46, builderIndexStart);
            if (builderIndexEnd > builderIndexStart) {
                int builderIndex;
                int localAliasStart = builderIndexEnd + 1;
                int localAliasEnd = alias.lastIndexOf(46);
                if (localAliasEnd > localAliasStart && 0 <= (builderIndex = Integer.parseInt(alias.substring(builderIndexStart, builderIndexEnd))) && builderIndex < this.builders.size()) {
                    KeyStore.ProtectionParameter protectionParameter;
                    KeyStore.Entry entry;
                    KeyStore.Builder builder = this.builders.get(builderIndex);
                    String localAlias = alias.substring(localAliasStart, localAliasEnd);
                    KeyStore keyStore = builder.getKeyStore();
                    if (null != keyStore && (entry = keyStore.getEntry(localAlias, protectionParameter = builder.getProtectionParameter(localAlias))) instanceof KeyStore.PrivateKeyEntry) {
                        return (KeyStore.PrivateKeyEntry)entry;
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.log(Level.FINER, "Failed to load PrivateKeyEntry: " + alias, e);
        }
        return null;
    }

    static MatchQuality getKeyTypeQuality(boolean isInFipsMode, JcaJceHelper helper, List<String> keyTypes, BCAlgorithmConstraints algorithmConstraints, boolean forServer, Date atDate, String requestedHostName, X509Certificate[] chain, int keyTypeIndex) {
        String keyType = keyTypes.get(keyTypeIndex);
        LOG.finer("EE cert potentially usable for key type: " + keyType);
        if (!ProvX509KeyManager.isSuitableChain(isInFipsMode, helper, chain, algorithmConstraints, forServer)) {
            LOG.finer("Unsuitable chain for key type: " + keyType);
            return MatchQuality.NONE;
        }
        return ProvX509KeyManager.getCertificateQuality(chain[0], atDate, requestedHostName);
    }

    static List<String> getKeyTypes(String ... keyTypes) {
        if (null != keyTypes && keyTypes.length > 0) {
            ArrayList<String> result = new ArrayList<String>(keyTypes.length);
            for (String keyType : keyTypes) {
                if (null == keyType) {
                    throw new IllegalArgumentException("Key types cannot be null");
                }
                if (result.contains(keyType)) continue;
                result.add(keyType);
            }
            return Collections.unmodifiableList(result);
        }
        return Collections.emptyList();
    }

    static int getPotentialKeyType(List<String> keyTypes, int keyTypeLimit, Set<Principal> uniqueIssuers, BCAlgorithmConstraints algorithmConstraints, boolean forServer, X509Certificate[] chain) {
        if (!ProvX509KeyManager.isSuitableChainForIssuers(chain, uniqueIssuers)) {
            return -1;
        }
        return ProvX509KeyManager.getSuitableKeyTypeForEECert(chain[0], keyTypes, keyTypeLimit, algorithmConstraints, forServer);
    }

    static String getRequestedHostName(TransportData transportData, boolean forServer) {
        BCSNIHostName sniHostName;
        BCExtendedSSLSession sslSession;
        if (null != transportData && forServer && null != (sslSession = transportData.getHandshakeSession()) && null != (sniHostName = JsseUtils.getSNIHostName(sslSession.getRequestedServerNames()))) {
            return sniHostName.getAsciiName();
        }
        return null;
    }

    static Set<Principal> getUniquePrincipals(Principal[] principals) {
        if (null == principals) {
            return null;
        }
        if (principals.length > 0) {
            HashSet<Principal> result = new HashSet<Principal>();
            for (int i = 0; i < principals.length; ++i) {
                Principal principal = principals[i];
                if (null == principal) continue;
                result.add(principal);
            }
            if (!result.isEmpty()) {
                return Collections.unmodifiableSet(result);
            }
        }
        return Collections.emptySet();
    }

    static boolean isSuitableKeyType(boolean forServer, String keyType, X509Certificate eeCert, TransportData transportData) {
        Map<String, PublicKeyFilter> filters = forServer ? FILTERS_SERVER : FILTERS_CLIENT;
        PublicKeyFilter filter = filters.get(keyType);
        if (null == filter) {
            return false;
        }
        PublicKey publicKey = eeCert.getPublicKey();
        boolean[] keyUsage = eeCert.getKeyUsage();
        BCAlgorithmConstraints algorithmConstraints = TransportData.getAlgorithmConstraints(transportData, true);
        return filter.accepts(publicKey, keyUsage, algorithmConstraints);
    }

    private static List<Match> addToMatches(List<Match> matches, Match match) {
        if (null == matches) {
            matches = new ArrayList<Match>();
        }
        matches.add(match);
        return matches;
    }

    private static String getAlias(Match match, String versionSuffix) {
        return match.builderIndex + "." + match.localAlias + versionSuffix;
    }

    private static String[] getAliases(List<Match> matches, String versionSuffix) {
        int count = matches.size();
        int pos = 0;
        String[] result = new String[count];
        for (Match match : matches) {
            result[pos++] = ProvX509KeyManager.getAlias(match, versionSuffix);
        }
        return result;
    }

    private static MatchQuality getCertificateQuality(X509Certificate certificate, Date atDate, String requestedHostName) {
        boolean[] keyUsage;
        try {
            certificate.checkValidity(atDate);
        }
        catch (CertificateException e) {
            return MatchQuality.EXPIRED;
        }
        if (null != requestedHostName) {
            try {
                ProvX509TrustManager.checkEndpointID(requestedHostName, certificate, "HTTPS");
            }
            catch (CertificateException e) {
                return MatchQuality.MISMATCH_SNI;
            }
        }
        if ("RSA".equalsIgnoreCase(JsseUtils.getPublicKeyAlgorithm(certificate.getPublicKey())) && ProvAlgorithmChecker.supportsKeyUsage(keyUsage = certificate.getKeyUsage(), 0) && ProvAlgorithmChecker.supportsKeyUsage(keyUsage, 2)) {
            return MatchQuality.RSA_MULTI_USE;
        }
        return MatchQuality.OK;
    }

    private static KeyPurposeId getRequiredExtendedKeyUsage(boolean forServer) {
        return !provKeyManagerCheckEKU ? null : (forServer ? KeyPurposeId.id_kp_serverAuth : KeyPurposeId.id_kp_clientAuth);
    }

    private static int getSuitableKeyTypeForEECert(X509Certificate eeCert, List<String> keyTypes, int keyTypeLimit, BCAlgorithmConstraints algorithmConstraints, boolean forServer) {
        Map<String, PublicKeyFilter> filters = forServer ? FILTERS_SERVER : FILTERS_CLIENT;
        PublicKey publicKey = eeCert.getPublicKey();
        boolean[] keyUsage = eeCert.getKeyUsage();
        for (int keyTypeIndex = 0; keyTypeIndex < keyTypeLimit; ++keyTypeIndex) {
            String keyType = keyTypes.get(keyTypeIndex);
            PublicKeyFilter filter = filters.get(keyType);
            if (null == filter || !filter.accepts(publicKey, keyUsage, algorithmConstraints)) continue;
            return keyTypeIndex;
        }
        return -1;
    }

    private static boolean isSuitableChain(boolean isInFipsMode, JcaJceHelper helper, X509Certificate[] chain, BCAlgorithmConstraints algorithmConstraints, boolean forServer) {
        try {
            Set<X509Certificate> trustedCerts = Collections.emptySet();
            KeyPurposeId ekuOID = ProvX509KeyManager.getRequiredExtendedKeyUsage(forServer);
            int kuBit = -1;
            ProvAlgorithmChecker.checkChain(isInFipsMode, helper, algorithmConstraints, trustedCerts, chain, ekuOID, kuBit);
            return true;
        }
        catch (CertPathValidatorException e) {
            LOG.log(Level.FINEST, "Certificate chain check failed", e);
            return false;
        }
    }

    private static boolean isSuitableChainForIssuers(X509Certificate[] chain, Set<Principal> uniqueIssuers) {
        if (TlsUtils.isNullOrEmpty(chain)) {
            return false;
        }
        if (null == uniqueIssuers || uniqueIssuers.isEmpty()) {
            return true;
        }
        int pos = chain.length;
        while (--pos >= 0) {
            if (!uniqueIssuers.contains(chain[pos].getIssuerX500Principal())) continue;
            return true;
        }
        X509Certificate eeCert = chain[0];
        return eeCert.getBasicConstraints() >= 0 && uniqueIssuers.contains(eeCert.getSubjectX500Principal());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DefaultPublicKeyFilter
    implements PublicKeyFilter {
        final String algorithm;
        final Class<? extends PublicKey> clazz;
        final int keyUsageBit;

        DefaultPublicKeyFilter(String algorithm, Class<? extends PublicKey> clazz, int keyUsageBit) {
            this.algorithm = algorithm;
            this.clazz = clazz;
            this.keyUsageBit = keyUsageBit;
        }

        @Override
        public boolean accepts(PublicKey publicKey, boolean[] keyUsage, BCAlgorithmConstraints algorithmConstraints) {
            return this.appliesTo(publicKey) && ProvAlgorithmChecker.permitsKeyUsage(publicKey, keyUsage, this.keyUsageBit, algorithmConstraints);
        }

        private boolean appliesTo(PublicKey publicKey) {
            return null != this.algorithm && this.algorithm.equalsIgnoreCase(JsseUtils.getPublicKeyAlgorithm(publicKey)) || null != this.clazz && this.clazz.isInstance(publicKey);
        }
    }

    private static final class ECPublicKeyFilter13
    implements PublicKeyFilter {
        final ASN1ObjectIdentifier standardOID;

        ECPublicKeyFilter13(ASN1ObjectIdentifier standardOID) {
            this.standardOID = standardOID;
        }

        public boolean accepts(PublicKey publicKey, boolean[] keyUsage, BCAlgorithmConstraints algorithmConstraints) {
            return this.appliesTo(publicKey) && ProvAlgorithmChecker.permitsKeyUsage(publicKey, keyUsage, 0, algorithmConstraints);
        }

        private boolean appliesTo(PublicKey publicKey) {
            ASN1ObjectIdentifier oid;
            return ("EC".equalsIgnoreCase(JsseUtils.getPublicKeyAlgorithm(publicKey)) || ECPublicKey.class.isInstance(publicKey)) && this.standardOID.equals(oid = JsseUtils.getNamedCurveOID(publicKey));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Match
    implements Comparable<Match> {
        static final MatchQuality INVALID = MatchQuality.MISMATCH_SNI;
        static final Match NOTHING = new Match(MatchQuality.NONE, Integer.MAX_VALUE, -1, null, null, null);
        final MatchQuality quality;
        final int keyTypeIndex;
        final int builderIndex;
        final String localAlias;
        final KeyStore cachedKeyStore;
        final X509Certificate[] cachedCertificateChain;

        Match(MatchQuality quality, int keyTypeIndex, int builderIndex, String localAlias, KeyStore cachedKeyStore, X509Certificate[] cachedCertificateChain) {
            this.quality = quality;
            this.keyTypeIndex = keyTypeIndex;
            this.builderIndex = builderIndex;
            this.localAlias = localAlias;
            this.cachedKeyStore = cachedKeyStore;
            this.cachedCertificateChain = cachedCertificateChain;
        }

        @Override
        public int compareTo(Match that) {
            boolean thatValid;
            boolean thisValid = this.isValid();
            if (thisValid != (thatValid = that.isValid())) {
                return thisValid ? -1 : 1;
            }
            if (this.keyTypeIndex != that.keyTypeIndex) {
                return this.keyTypeIndex < that.keyTypeIndex ? -1 : 1;
            }
            return this.quality.compareTo(that.quality);
        }

        boolean isIdeal() {
            return MatchQuality.OK == this.quality && 0 == this.keyTypeIndex;
        }

        boolean isValid() {
            return this.quality.compareTo(INVALID) < 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum MatchQuality {
        OK,
        RSA_MULTI_USE,
        MISMATCH_SNI,
        EXPIRED,
        NONE;

    }

    static interface PublicKeyFilter {
        public boolean accepts(PublicKey var1, boolean[] var2, BCAlgorithmConstraints var3);
    }
}

