/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.util.concurrent.atomic.AtomicLong;
import org.bouncycastle.jsse.BCSSLConnection;
import org.bouncycastle.jsse.provider.JsseUtils;
import org.bouncycastle.jsse.provider.ProvSSLSession;
import org.bouncycastle.jsse.provider.ProvTlsPeer;
import org.bouncycastle.tls.TlsContext;

class ProvSSLConnection
implements BCSSLConnection {
    private static final AtomicLong CONNECTION_IDS = new AtomicLong(0L);
    protected final ProvTlsPeer tlsPeer;

    static long allocateConnectionID() {
        return CONNECTION_IDS.incrementAndGet();
    }

    ProvSSLConnection(ProvTlsPeer tlsPeer) {
        this.tlsPeer = tlsPeer;
    }

    public byte[] exportKeyingMaterial(String asciiLabel, byte[] context_value, int length) {
        return this.getTlsContext().exportKeyingMaterial(asciiLabel, context_value, length);
    }

    public String getApplicationProtocol() {
        return JsseUtils.getApplicationProtocol(this.getTlsContext().getSecurityParametersConnection());
    }

    public byte[] getChannelBinding(String channelBinding) {
        if (channelBinding.equals("tls-exporter")) {
            return this.getTlsContext().exportChannelBinding(3);
        }
        if (channelBinding.equals("tls-server-end-point")) {
            return this.getTlsContext().exportChannelBinding(0);
        }
        if (channelBinding.equals("tls-unique")) {
            return this.getTlsContext().exportChannelBinding(1);
        }
        throw new UnsupportedOperationException();
    }

    public String getID() {
        return this.tlsPeer.getID();
    }

    public ProvSSLSession getSession() {
        return this.tlsPeer.getSession();
    }

    protected TlsContext getTlsContext() {
        return this.tlsPeer.getTlsContext();
    }
}

