/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.net.BindException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.NoRouteToHostException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.nio.channels.UnresolvedAddressException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.net.SocketFactory;
import org.apache.commons.net.util.SubnetUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.net.ConnectTimeoutException;
import org.apache.hadoop.net.SocketIOWithTimeout;
import org.apache.hadoop.net.SocketInputStream;
import org.apache.hadoop.net.SocketInputWrapper;
import org.apache.hadoop.net.SocketOutputStream;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.apache.hadoop.thirdparty.com.google.common.cache.Cache;
import org.apache.hadoop.thirdparty.com.google.common.cache.CacheBuilder;
import org.apache.hadoop.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Unstable
public class NetUtils {
    private static final Logger LOG = LoggerFactory.getLogger(NetUtils.class);
    private static Map<String, String> hostToResolved = new HashMap<String, String>();
    private static final String FOR_MORE_DETAILS_SEE = " For more details see:  ";
    public static final String UNKNOWN_HOST = "(unknown)";
    public static final String HADOOP_WIKI = "http://wiki.apache.org/hadoop/";
    private static final long URI_CACHE_SIZE_DEFAULT = 1000L;
    private static final long URI_CACHE_EXPIRE_TIME_DEFAULT = 12L;
    private static final Cache<String, URI> URI_CACHE = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(12L, TimeUnit.HOURS).build();
    private static final ConcurrentHashMap<String, String> canonicalizedHostCache = new ConcurrentHashMap();
    private static final Pattern ipPortPattern = Pattern.compile("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}(:\\d+)?");

    public static SocketFactory getSocketFactory(Configuration conf, Class<?> clazz) {
        SocketFactory factory = null;
        String propValue = conf.get("hadoop.rpc.socket.factory.class." + clazz.getSimpleName());
        if (propValue != null && propValue.length() > 0) {
            factory = NetUtils.getSocketFactoryFromProperty(conf, propValue);
        }
        if (factory == null) {
            factory = NetUtils.getDefaultSocketFactory(conf);
        }
        return factory;
    }

    public static SocketFactory getDefaultSocketFactory(Configuration conf) {
        String propValue = conf.get("hadoop.rpc.socket.factory.class.default", "org.apache.hadoop.net.StandardSocketFactory");
        if (propValue == null || propValue.length() == 0) {
            return SocketFactory.getDefault();
        }
        return NetUtils.getSocketFactoryFromProperty(conf, propValue);
    }

    public static SocketFactory getSocketFactoryFromProperty(Configuration conf, String propValue) {
        try {
            Class<?> theClass = conf.getClassByName(propValue);
            return (SocketFactory)ReflectionUtils.newInstance(theClass, conf);
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException("Socket Factory class not found: " + cnfe);
        }
    }

    public static InetSocketAddress createSocketAddr(String target) {
        return NetUtils.createSocketAddr(target, -1);
    }

    public static InetSocketAddress createSocketAddr(String target, int defaultPort) {
        return NetUtils.createSocketAddr(target, defaultPort, null);
    }

    public static InetSocketAddress createSocketAddr(String target, int defaultPort, String configName) {
        return NetUtils.createSocketAddr(target, defaultPort, configName, false);
    }

    public static InetSocketAddress createSocketAddr(String target, int defaultPort, String configName, boolean useCacheIfPresent) {
        String helpText = "";
        if (configName != null) {
            helpText = " (configuration property '" + configName + "')";
        }
        if (target == null) {
            throw new IllegalArgumentException("Target address cannot be null." + helpText);
        }
        target = target.trim();
        boolean hasScheme = target.contains("://");
        URI uri = NetUtils.createURI(target, hasScheme, helpText, useCacheIfPresent);
        String host = uri.getHost();
        int port = uri.getPort();
        if (port == -1) {
            port = defaultPort;
        }
        String path = uri.getPath();
        if (host == null || port < 0 || !hasScheme && path != null && !path.isEmpty()) {
            throw new IllegalArgumentException("Does not contain a valid host:port authority: " + target + helpText);
        }
        return NetUtils.createSocketAddrForHost(host, port);
    }

    private static URI createURI(String target, boolean hasScheme, String helpText, boolean useCacheIfPresent) {
        URI uri;
        if (useCacheIfPresent && (uri = URI_CACHE.getIfPresent(target)) != null) {
            return uri;
        }
        try {
            uri = hasScheme ? URI.create(target) : URI.create("dummyscheme://" + target);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Does not contain a valid host:port authority: " + target + helpText);
        }
        if (useCacheIfPresent) {
            URI_CACHE.put(target, uri);
        }
        return uri;
    }

    public static InetSocketAddress createSocketAddrForHost(String host, int port) {
        InetSocketAddress addr;
        String staticHost = NetUtils.getStaticResolution(host);
        String resolveHost = staticHost != null ? staticHost : host;
        try {
            InetAddress iaddr = SecurityUtil.getByName(resolveHost);
            if (staticHost != null) {
                iaddr = InetAddress.getByAddress(host, iaddr.getAddress());
            }
            addr = new InetSocketAddress(iaddr, port);
        }
        catch (UnknownHostException e) {
            addr = InetSocketAddress.createUnresolved(host, port);
        }
        return addr;
    }

    public static URI getCanonicalUri(URI uri, int defaultPort) {
        String host = uri.getHost();
        if (host == null) {
            return uri;
        }
        String fqHost = NetUtils.canonicalizeHost(host);
        int port = uri.getPort();
        if (host.equals(fqHost) && port != -1) {
            return uri;
        }
        try {
            uri = new URI(uri.getScheme(), uri.getUserInfo(), fqHost, port == -1 ? defaultPort : port, uri.getPath(), uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        return uri;
    }

    private static String canonicalizeHost(String host) {
        String fqHost = canonicalizedHostCache.get(host);
        if (fqHost == null) {
            try {
                fqHost = SecurityUtil.getByName(host).getHostName();
                canonicalizedHostCache.putIfAbsent(host, fqHost);
                fqHost = canonicalizedHostCache.get(host);
            }
            catch (UnknownHostException e) {
                fqHost = host;
            }
        }
        return fqHost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addStaticResolution(String host, String resolvedName) {
        Map<String, String> map = hostToResolved;
        synchronized (map) {
            hostToResolved.put(host, resolvedName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStaticResolution(String host) {
        Map<String, String> map = hostToResolved;
        synchronized (map) {
            return hostToResolved.get(host);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String[]> getAllStaticResolutions() {
        Map<String, String> map = hostToResolved;
        synchronized (map) {
            Set<Map.Entry<String, String>> entries = hostToResolved.entrySet();
            if (entries.size() == 0) {
                return null;
            }
            ArrayList<String[]> l = new ArrayList<String[]>(entries.size());
            for (Map.Entry<String, String> e : entries) {
                l.add(new String[]{e.getKey(), e.getValue()});
            }
            return l;
        }
    }

    public static InetSocketAddress getConnectAddress(Server server) {
        return NetUtils.getConnectAddress(server.getListenerAddress());
    }

    public static InetSocketAddress getConnectAddress(InetSocketAddress addr) {
        if (!addr.isUnresolved() && addr.getAddress().isAnyLocalAddress()) {
            try {
                addr = new InetSocketAddress(InetAddress.getLocalHost(), addr.getPort());
            }
            catch (UnknownHostException uhe) {
                addr = NetUtils.createSocketAddrForHost("127.0.0.1", addr.getPort());
            }
        }
        return addr;
    }

    public static SocketInputWrapper getInputStream(Socket socket) throws IOException {
        return NetUtils.getInputStream(socket, socket.getSoTimeout());
    }

    public static SocketInputWrapper getInputStream(Socket socket, long timeout) throws IOException {
        InputStream stm = socket.getChannel() == null ? socket.getInputStream() : new SocketInputStream(socket);
        SocketInputWrapper w = new SocketInputWrapper(socket, stm);
        w.setTimeout(timeout);
        return w;
    }

    public static OutputStream getOutputStream(Socket socket) throws IOException {
        return NetUtils.getOutputStream(socket, 0L);
    }

    public static OutputStream getOutputStream(Socket socket, long timeout) throws IOException {
        return socket.getChannel() == null ? socket.getOutputStream() : new SocketOutputStream(socket, timeout);
    }

    public static void connect(Socket socket, SocketAddress address, int timeout) throws IOException {
        NetUtils.connect(socket, address, null, timeout);
    }

    public static void connect(Socket socket, SocketAddress endpoint, SocketAddress localAddr, int timeout) throws IOException {
        if (socket == null || endpoint == null || timeout < 0) {
            throw new IllegalArgumentException("Illegal argument for connect()");
        }
        SocketChannel ch = socket.getChannel();
        if (localAddr != null) {
            Class<?> localClass = localAddr.getClass();
            Class<?> remoteClass = endpoint.getClass();
            Preconditions.checkArgument(localClass.equals(remoteClass), "Local address %s must be of same family as remote address %s.", (Object)localAddr, (Object)endpoint);
            socket.bind(localAddr);
        }
        try {
            if (ch == null) {
                socket.connect(endpoint, timeout);
            } else {
                SocketIOWithTimeout.connect(ch, endpoint, timeout);
            }
        }
        catch (SocketTimeoutException ste) {
            throw new ConnectTimeoutException(ste.getMessage());
        }
        catch (UnresolvedAddressException uae) {
            throw new UnknownHostException(endpoint.toString());
        }
        if (socket.getLocalPort() == socket.getPort() && socket.getLocalAddress().equals(socket.getInetAddress())) {
            LOG.info("Detected a loopback TCP socket, disconnecting it");
            socket.close();
            throw new ConnectException("Localhost targeted connection resulted in a loopback. No daemon is listening on the target port.");
        }
    }

    public static String normalizeHostName(String name) {
        try {
            return InetAddress.getByName(name).getHostAddress();
        }
        catch (UnknownHostException e) {
            return name;
        }
    }

    public static List<String> normalizeHostNames(Collection<String> names) {
        ArrayList<String> hostNames = new ArrayList<String>(names.size());
        for (String name : names) {
            hostNames.add(NetUtils.normalizeHostName(name));
        }
        return hostNames;
    }

    public static void verifyHostnames(String[] names) throws UnknownHostException {
        for (String name : names) {
            if (name == null) {
                throw new UnknownHostException("null hostname found");
            }
            URI uri = null;
            try {
                uri = new URI(name);
                if (uri.getHost() == null) {
                    uri = new URI("http://" + name);
                }
            }
            catch (URISyntaxException e) {
                uri = null;
            }
            if (uri != null && uri.getHost() != null) continue;
            throw new UnknownHostException(name + " is not a valid Inet address");
        }
    }

    public static String getHostNameOfIP(String ipPort) {
        if (null == ipPort || !ipPortPattern.matcher(ipPort).matches()) {
            return null;
        }
        try {
            int colonIdx = ipPort.indexOf(58);
            String ip = -1 == colonIdx ? ipPort : ipPort.substring(0, ipPort.indexOf(58));
            return InetAddress.getByName(ip).getHostName();
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    public static String normalizeIP2HostName(String ipPort) {
        if (null == ipPort || !ipPortPattern.matcher(ipPort).matches()) {
            return ipPort;
        }
        InetSocketAddress address = NetUtils.createSocketAddr(ipPort);
        return NetUtils.getHostPortString(address);
    }

    public static String getLocalHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException uhe) {
            return "" + uhe;
        }
    }

    public static String getHostname() {
        try {
            return "" + InetAddress.getLocalHost();
        }
        catch (UnknownHostException uhe) {
            return "" + uhe;
        }
    }

    public static String getHostPortString(InetSocketAddress addr) {
        return addr.getHostName() + ":" + addr.getPort();
    }

    public static InetAddress getLocalInetAddress(String host) throws SocketException {
        if (host == null) {
            return null;
        }
        InetAddress addr = null;
        try {
            addr = SecurityUtil.getByName(host);
            if (NetworkInterface.getByInetAddress(addr) == null) {
                addr = null;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return addr;
    }

    public static boolean isLocalAddress(InetAddress addr) {
        boolean local;
        boolean bl = local = addr.isAnyLocalAddress() || addr.isLoopbackAddress();
        if (!local) {
            try {
                local = NetworkInterface.getByInetAddress(addr) != null;
            }
            catch (SocketException e) {
                local = false;
            }
        }
        return local;
    }

    public static IOException wrapException(String destHost, int destPort, String localHost, int localPort, IOException exception) {
        try {
            if (exception instanceof BindException) {
                return NetUtils.wrapWithMessage(exception, "Problem binding to [" + localHost + ":" + localPort + "] " + exception + ";" + NetUtils.see("BindException"));
            }
            if (exception instanceof ConnectException) {
                if (destHost != null && (destHost.equals("0.0.0.0") || destHost.equals("0:0:0:0:0:0:0:0") || destHost.equals("::")) || destPort == 0) {
                    return NetUtils.wrapWithMessage(exception, "Your endpoint configuration is wrong;" + NetUtils.see("UnsetHostnameOrPort"));
                }
                return NetUtils.wrapWithMessage(exception, "Call From " + localHost + " to " + destHost + ":" + destPort + " failed on connection exception: " + exception + ";" + NetUtils.see("ConnectionRefused"));
            }
            if (exception instanceof UnknownHostException) {
                return NetUtils.wrapWithMessage(exception, "Invalid host name: " + NetUtils.getHostDetailsAsString(destHost, destPort, localHost) + exception + ";" + NetUtils.see("UnknownHost"));
            }
            if (exception instanceof SocketTimeoutException) {
                return NetUtils.wrapWithMessage(exception, "Call From " + localHost + " to " + destHost + ":" + destPort + " failed on socket timeout exception: " + exception + ";" + NetUtils.see("SocketTimeout"));
            }
            if (exception instanceof NoRouteToHostException) {
                return NetUtils.wrapWithMessage(exception, "No Route to Host from  " + localHost + " to " + destHost + ":" + destPort + " failed on socket timeout exception: " + exception + ";" + NetUtils.see("NoRouteToHost"));
            }
            if (exception instanceof EOFException) {
                return NetUtils.wrapWithMessage(exception, "End of File Exception between " + NetUtils.getHostDetailsAsString(destHost, destPort, localHost) + ": " + exception + ";" + NetUtils.see("EOFException"));
            }
            if (exception instanceof SocketException) {
                return NetUtils.wrapWithMessage(exception, "Call From " + localHost + " to " + destHost + ":" + destPort + " failed on socket exception: " + exception + ";" + NetUtils.see("SocketException"));
            }
            if (exception instanceof AccessControlException) {
                return NetUtils.wrapWithMessage(exception, "Call From " + localHost + " to " + destHost + ":" + destPort + " failed: " + exception.getMessage());
            }
            return NetUtils.wrapWithMessage(exception, "DestHost:destPort " + destHost + ":" + destPort + " , LocalHost:localPort " + localHost + ":" + localPort + ". Failed on local exception: " + exception);
        }
        catch (IOException ex) {
            return (IOException)new IOException("Failed on local exception: " + exception + "; Host Details : " + NetUtils.getHostDetailsAsString(destHost, destPort, localHost)).initCause(exception);
        }
    }

    private static String see(String entry) {
        return " For more details see:  http://wiki.apache.org/hadoop/" + entry;
    }

    private static <T extends IOException> T wrapWithMessage(T exception, String msg) throws T {
        Class<?> clazz = exception.getClass();
        try {
            Constructor<?> ctor = clazz.getConstructor(String.class);
            Throwable t2 = (Throwable)ctor.newInstance(msg);
            return (T)((IOException)t2.initCause(exception));
        }
        catch (NoSuchMethodException e) {
            return exception;
        }
        catch (Throwable e) {
            throw exception;
        }
    }

    private static String getHostDetailsAsString(String destHost, int destPort, String localHost) {
        StringBuilder hostDetails = new StringBuilder(27);
        hostDetails.append("local host is: ").append(NetUtils.quoteHost(localHost)).append("; ").append("destination host is: ").append(NetUtils.quoteHost(destHost)).append(":").append(destPort).append("; ");
        return hostDetails.toString();
    }

    private static String quoteHost(String hostname) {
        return hostname != null ? "\"" + hostname + "\"" : UNKNOWN_HOST;
    }

    public static boolean isValidSubnet(String subnet) {
        try {
            new SubnetUtils(subnet);
            return true;
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    private static void addMatchingAddrs(NetworkInterface nif, SubnetUtils.SubnetInfo subnetInfo, List<InetAddress> addrs) {
        Enumeration<InetAddress> ifAddrs = nif.getInetAddresses();
        while (ifAddrs.hasMoreElements()) {
            InetAddress ifAddr = ifAddrs.nextElement();
            if (!subnetInfo.isInRange(ifAddr.getHostAddress())) continue;
            addrs.add(ifAddr);
        }
    }

    public static List<InetAddress> getIPs(String subnet, boolean returnSubinterfaces) {
        Enumeration<NetworkInterface> nifs;
        ArrayList<InetAddress> addrs = new ArrayList<InetAddress>();
        SubnetUtils.SubnetInfo subnetInfo = new SubnetUtils(subnet).getInfo();
        try {
            nifs = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            LOG.error("Unable to get host interfaces", e);
            return addrs;
        }
        while (nifs.hasMoreElements()) {
            NetworkInterface nif = nifs.nextElement();
            NetUtils.addMatchingAddrs(nif, subnetInfo, addrs);
            if (!returnSubinterfaces) continue;
            Enumeration<NetworkInterface> subNifs = nif.getSubInterfaces();
            while (subNifs.hasMoreElements()) {
                NetUtils.addMatchingAddrs(subNifs.nextElement(), subnetInfo, addrs);
            }
        }
        return addrs;
    }

    public static int getFreeSocketPort() {
        int port = 0;
        try {
            ServerSocket s2 = new ServerSocket(0);
            port = s2.getLocalPort();
            s2.close();
            return port;
        }
        catch (IOException iOException) {
            return port;
        }
    }

    public static Set<Integer> getFreeSocketPorts(int numOfPorts) {
        Preconditions.checkArgument(numOfPorts > 0 && numOfPorts <= 25, "Valid range for num of ports is between 0 and 26");
        HashSet<Integer> freePorts = new HashSet<Integer>(numOfPorts);
        for (int i = 0; i < numOfPorts * 5; ++i) {
            int port = NetUtils.getFreeSocketPort();
            if (port == 0) continue;
            freePorts.add(port);
            if (freePorts.size() != numOfPorts) continue;
            return freePorts;
        }
        throw new IllegalStateException(numOfPorts + " free ports could not be acquired.");
    }

    public static InetAddress bindToLocalAddress(InetAddress localAddr, boolean bindWildCardAddress) {
        if (!bindWildCardAddress) {
            return localAddr;
        }
        return null;
    }
}

