/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.results;

import java.util.Collection;
import org.openjdk.jmh.results.AggregationPolicy;
import org.openjdk.jmh.results.Aggregator;
import org.openjdk.jmh.results.AggregatorUtils;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.ResultRole;
import org.openjdk.jmh.util.ListStatistics;
import org.openjdk.jmh.util.Statistics;

public class ScalarDerivativeResult
extends Result<ScalarDerivativeResult> {
    private static final long serialVersionUID = 3407232747805728586L;

    public ScalarDerivativeResult(String label, double n, String unit, AggregationPolicy policy) {
        this(label, ScalarDerivativeResult.of(n), unit, policy);
    }

    ScalarDerivativeResult(String label, Statistics s2, String unit, AggregationPolicy policy) {
        super(ResultRole.SECONDARY_DERIVATIVE, label, s2, unit, policy);
    }

    @Override
    protected Aggregator<ScalarDerivativeResult> getThreadAggregator() {
        return new ScalarResultAggregator();
    }

    @Override
    protected Aggregator<ScalarDerivativeResult> getIterationAggregator() {
        return new ScalarResultAggregator();
    }

    @Override
    protected ScalarDerivativeResult getZeroResult() {
        return new ScalarDerivativeResult(this.label, 0.0, this.unit, this.policy);
    }

    @Override
    public String extendedInfo() {
        return "";
    }

    static class ScalarResultAggregator
    implements Aggregator<ScalarDerivativeResult> {
        ScalarResultAggregator() {
        }

        @Override
        public ScalarDerivativeResult aggregate(Collection<ScalarDerivativeResult> results) {
            ListStatistics stats = new ListStatistics();
            for (ScalarDerivativeResult r : results) {
                stats.addValue(r.getScore());
            }
            return new ScalarDerivativeResult(AggregatorUtils.aggregateLabels(results), stats, AggregatorUtils.aggregateUnits(results), AggregatorUtils.aggregatePolicies(results));
        }
    }
}

