/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import java.io.OutputStream;
import java.security.Signature;
import java.security.SignatureException;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.crypto.TlsStreamVerifier;
import org.bouncycastle.tls.crypto.impl.jcajce.OutputStreamFactory;

class JcaTlsStreamVerifier
implements TlsStreamVerifier {
    private final Signature verifier;
    private final OutputStream output;
    private final byte[] signature;

    JcaTlsStreamVerifier(Signature verifier, byte[] signature) {
        this.verifier = verifier;
        this.output = OutputStreamFactory.createStream(verifier);
        this.signature = signature;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.output;
    }

    public boolean isVerified() throws IOException {
        try {
            return this.verifier.verify(this.signature);
        }
        catch (SignatureException e) {
            throw new TlsFatalAlert(80, (Throwable)e);
        }
    }
}

