/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import org.bouncycastle.util.Integers;

class GcmSpecUtil {
    static final Class gcmSpecClass = GcmSpecUtil.lookup("javax.crypto.spec.GCMParameterSpec");

    GcmSpecUtil() {
    }

    static boolean gcmSpecExists() {
        return gcmSpecClass != null;
    }

    static AlgorithmParameterSpec createGcmSpec(byte[] nonce, int macLen) throws InvalidParameterSpecException {
        Object rv = AccessController.doPrivileged(new PrivilegedAction<Object>(macLen, nonce){
            final /* synthetic */ int val$macLen;
            final /* synthetic */ byte[] val$nonce;
            {
                this.val$macLen = n;
                this.val$nonce = byArray;
            }

            @Override
            public Object run() {
                try {
                    Constructor constructor = gcmSpecClass.getConstructor(Integer.TYPE, byte[].class);
                    return constructor.newInstance(Integers.valueOf(this.val$macLen * 8), this.val$nonce);
                }
                catch (NoSuchMethodException e) {
                    return new InvalidParameterSpecException("no constructor found!");
                }
                catch (Exception e) {
                    return new InvalidParameterSpecException("construction failed: " + e.getMessage());
                }
            }
        });
        if (rv instanceof AlgorithmParameterSpec) {
            return (AlgorithmParameterSpec)rv;
        }
        throw (InvalidParameterSpecException)rv;
    }

    static Class lookup(final String className) {
        return AccessController.doPrivileged(new PrivilegedAction<Class>(){

            @Override
            public Class run() {
                try {
                    ClassLoader loader = GcmSpecUtil.class.getClassLoader();
                    return loader.loadClass(className);
                }
                catch (Exception e) {
                    return null;
                }
            }
        });
    }
}

