/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import org.bouncycastle.tls.TlsSRPUtils;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.util.Arrays;

public class ServerSRPParams {
    protected BigInteger N;
    protected BigInteger g;
    protected BigInteger B;
    protected byte[] s;

    public ServerSRPParams(BigInteger N2, BigInteger g2, byte[] s2, BigInteger B) {
        this.N = N2;
        this.g = g2;
        this.s = Arrays.clone(s2);
        this.B = B;
    }

    public BigInteger getB() {
        return this.B;
    }

    public BigInteger getG() {
        return this.g;
    }

    public BigInteger getN() {
        return this.N;
    }

    public byte[] getS() {
        return this.s;
    }

    public void encode(OutputStream output) throws IOException {
        TlsSRPUtils.writeSRPParameter(this.N, output);
        TlsSRPUtils.writeSRPParameter(this.g, output);
        TlsUtils.writeOpaque8(this.s, output);
        TlsSRPUtils.writeSRPParameter(this.B, output);
    }

    public static ServerSRPParams parse(InputStream input) throws IOException {
        BigInteger N2 = TlsSRPUtils.readSRPParameter(input);
        BigInteger g2 = TlsSRPUtils.readSRPParameter(input);
        byte[] s2 = TlsUtils.readOpaque8(input, 1);
        BigInteger B = TlsSRPUtils.readSRPParameter(input);
        return new ServerSRPParams(N2, g2, s2, B);
    }
}

