/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;

public final class ProtocolName {
    public static final ProtocolName HTTP_1_1 = ProtocolName.asUtf8Encoding("http/1.1");
    public static final ProtocolName SPDY_1 = ProtocolName.asUtf8Encoding("spdy/1");
    public static final ProtocolName SPDY_2 = ProtocolName.asUtf8Encoding("spdy/2");
    public static final ProtocolName SPDY_3 = ProtocolName.asUtf8Encoding("spdy/3");
    public static final ProtocolName STUN_TURN = ProtocolName.asUtf8Encoding("stun.turn");
    public static final ProtocolName STUN_NAT_DISCOVERY = ProtocolName.asUtf8Encoding("stun.nat-discovery");
    public static final ProtocolName HTTP_2_TLS = ProtocolName.asUtf8Encoding("h2");
    public static final ProtocolName HTTP_2_TCP = ProtocolName.asUtf8Encoding("h2c");
    public static final ProtocolName WEBRTC = ProtocolName.asUtf8Encoding("webrtc");
    public static final ProtocolName WEBRTC_CONFIDENTIAL = ProtocolName.asUtf8Encoding("c-webrtc");
    public static final ProtocolName FTP = ProtocolName.asUtf8Encoding("ftp");
    public static final ProtocolName IMAP = ProtocolName.asUtf8Encoding("imap");
    public static final ProtocolName POP3 = ProtocolName.asUtf8Encoding("pop3");
    public static final ProtocolName MANAGESIEVE = ProtocolName.asUtf8Encoding("managesieve");
    public static final ProtocolName COAP = ProtocolName.asUtf8Encoding("coap");
    public static final ProtocolName XMPP_CLIENT = ProtocolName.asUtf8Encoding("xmpp-client");
    public static final ProtocolName XMPP_SERVER = ProtocolName.asUtf8Encoding("xmpp-server");
    public static final ProtocolName ACME_TLS_1 = ProtocolName.asUtf8Encoding("acme-tls/1");
    public static final ProtocolName OASIS_MQTT = ProtocolName.asUtf8Encoding("mqtt");
    public static final ProtocolName DNS_OVER_TLS = ProtocolName.asUtf8Encoding("dot");
    public static final ProtocolName NTSKE_1 = ProtocolName.asUtf8Encoding("ntske/1");
    public static final ProtocolName SNU_RPC = ProtocolName.asUtf8Encoding("sunrpc");
    public static final ProtocolName HTTP_3 = ProtocolName.asUtf8Encoding("h3");
    public static final ProtocolName SMB_2 = ProtocolName.asUtf8Encoding("smb");
    public static final ProtocolName IRC = ProtocolName.asUtf8Encoding("irc");
    public static final ProtocolName NNTP_READING = ProtocolName.asUtf8Encoding("nntp");
    public static final ProtocolName NNTP_TRANSIT = ProtocolName.asUtf8Encoding("nnsp");
    public static final ProtocolName DNS_OVER_QUIC = ProtocolName.asUtf8Encoding("doq");
    private final byte[] bytes;

    public static ProtocolName asRawBytes(byte[] bytes) {
        return new ProtocolName(Arrays.clone(bytes));
    }

    public static ProtocolName asUtf8Encoding(String name) {
        return new ProtocolName(Strings.toUTF8ByteArray(name));
    }

    private ProtocolName(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("'bytes' cannot be null");
        }
        if (bytes.length < 1 || bytes.length > 255) {
            throw new IllegalArgumentException("'bytes' must have length from 1 to 255");
        }
        this.bytes = bytes;
    }

    public byte[] getBytes() {
        return Arrays.clone(this.bytes);
    }

    public String getUtf8Decoding() {
        return Strings.fromUTF8ByteArray(this.bytes);
    }

    public void encode(OutputStream output) throws IOException {
        TlsUtils.writeOpaque8(this.bytes, output);
    }

    public static ProtocolName parse(InputStream input) throws IOException {
        return new ProtocolName(TlsUtils.readOpaque8(input, 1));
    }

    public boolean equals(Object obj) {
        return obj instanceof ProtocolName && Arrays.areEqual(this.bytes, ((ProtocolName)obj).bytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }
}

