/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import org.apache.zookeeper.jmx.MBeanRegistry;
import org.apache.zookeeper.server.quorum.Election;
import org.apache.zookeeper.server.quorum.LeaderElectionBean;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.Vote;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class LeaderElection
implements Election {
    private static final Logger LOG = LoggerFactory.getLogger(LeaderElection.class);
    protected static final Random epochGen = new Random();
    protected QuorumPeer self;

    public LeaderElection(QuorumPeer self) {
        this.self = self;
    }

    protected ElectionResult countVotes(HashMap<InetSocketAddress, Vote> votes, HashSet<Long> heardFrom) {
        ElectionResult result = new ElectionResult();
        result.vote = new Vote(Long.MIN_VALUE, Long.MIN_VALUE);
        result.winner = new Vote(Long.MIN_VALUE, Long.MIN_VALUE);
        HashMap<InetSocketAddress, Vote> validVotes = new HashMap<InetSocketAddress, Vote>();
        HashMap<Long, Long> maxZxids = new HashMap<Long, Long>();
        for (Map.Entry<InetSocketAddress, Vote> entry : votes.entrySet()) {
            Vote vote = entry.getValue();
            if (!heardFrom.contains(vote.getId())) continue;
            validVotes.put(entry.getKey(), vote);
            Long val = (Long)maxZxids.get(vote.getId());
            if (val != null && val >= vote.getZxid()) continue;
            maxZxids.put(vote.getId(), vote.getZxid());
        }
        for (Map.Entry<InetSocketAddress, Vote> entry : validVotes.entrySet()) {
            Vote vote = entry.getValue();
            Long zxid = (Long)maxZxids.get(vote.getId());
            if (vote.getZxid() >= zxid) continue;
            entry.setValue(new Vote(vote.getId(), zxid, vote.getElectionEpoch(), vote.getPeerEpoch(), vote.getState()));
        }
        result.numValidVotes = validVotes.size();
        HashMap<Vote, Integer> countTable = new HashMap<Vote, Integer>();
        for (Vote vote : validVotes.values()) {
            Integer count = (Integer)countTable.get(vote);
            if (count == null) {
                count = 0;
            }
            countTable.put(vote, count + 1);
            if (vote.getId() == result.vote.getId()) {
                ++result.count;
                continue;
            }
            if (vote.getZxid() <= result.vote.getZxid() && (vote.getZxid() != result.vote.getZxid() || vote.getId() <= result.vote.getId())) continue;
            result.vote = vote;
            result.count = 1;
        }
        result.winningCount = 0;
        LOG.info("Election tally: ");
        for (Map.Entry entry : countTable.entrySet()) {
            if ((Integer)entry.getValue() > result.winningCount) {
                result.winningCount = (Integer)entry.getValue();
                result.winner = (Vote)entry.getKey();
            }
            LOG.info(((Vote)entry.getKey()).getId() + "\t-> " + entry.getValue());
        }
        return result;
    }

    @Override
    public void shutdown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public Vote lookForLeader() throws InterruptedException {
        try {
            this.self.jmxLeaderElectionBean = new LeaderElectionBean();
            MBeanRegistry.getInstance().register(this.self.jmxLeaderElectionBean, this.self.jmxLocalPeerBean);
        }
        catch (Exception e) {
            LeaderElection.LOG.warn("Failed to register with JMX", e);
            this.self.jmxLeaderElectionBean = null;
        }
        try {
            this.self.setCurrentVote(new Vote(this.self.getId(), this.self.getLastLoggedZxid()));
            requestBytes = new byte[4];
            requestBuffer = ByteBuffer.wrap(requestBytes);
            responseBytes = new byte[28];
            responseBuffer = ByteBuffer.wrap(responseBytes);
            s = null;
            try {
                s = new DatagramSocket();
                s.setSoTimeout(200);
            }
            catch (SocketException e1) {
                LeaderElection.LOG.error("Socket exception when creating socket for leader election", e1);
                System.exit(4);
            }
            requestPacket = new DatagramPacket(requestBytes, requestBytes.length);
            responsePacket = new DatagramPacket(responseBytes, responseBytes.length);
            xid = LeaderElection.epochGen.nextInt();
            while (this.self.isRunning()) {
                block30: {
                    block29: {
                        votes = new HashMap<InetSocketAddress, Vote>(this.self.getVotingView().size());
                        requestBuffer.clear();
                        requestBuffer.putInt(xid);
                        requestPacket.setLength(4);
                        heardFrom = new HashSet<Long>();
                        for (QuorumPeer.QuorumServer server : this.self.getVotingView().values()) {
                            LeaderElection.LOG.info("Server address: " + server.addr);
                            try {
                                requestPacket.setSocketAddress(server.addr);
                            }
                            catch (IllegalArgumentException e) {
                                throw new IllegalArgumentException("Unable to set socket address on packet, msg:" + e.getMessage() + " with addr:" + server.addr, e);
                            }
                            try {
                                s.send(requestPacket);
                                responsePacket.setLength(responseBytes.length);
                                s.receive(responsePacket);
                                if (responsePacket.getLength() != responseBytes.length) {
                                    LeaderElection.LOG.error("Got a short response: " + responsePacket.getLength());
                                    continue;
                                }
                                responseBuffer.clear();
                                recvedXid = responseBuffer.getInt();
                                if (recvedXid != xid) {
                                    LeaderElection.LOG.error("Got bad xid: expected " + xid + " got " + recvedXid);
                                    continue;
                                }
                                peerId = responseBuffer.getLong();
                                heardFrom.add(peerId);
                                vote = new Vote(responseBuffer.getLong(), responseBuffer.getLong());
                                addr = (InetSocketAddress)responsePacket.getSocketAddress();
                                votes.put(addr, vote);
                            }
                            catch (IOException e) {
                                LeaderElection.LOG.warn("Ignoring exception while looking for leader", e);
                            }
                        }
                        result = this.countVotes(votes, heardFrom);
                        if (result.numValidVotes != 0) break block29;
                        this.self.setCurrentVote(new Vote(this.self.getId(), this.self.getLastLoggedZxid()));
                        break block30;
                    }
                    if (result.winner.getId() < 0L) break block30;
                    this.self.setCurrentVote(result.vote);
                    if (result.winningCount <= this.self.getVotingView().size() / 2) break block30;
                    this.self.setCurrentVote(result.winner);
                    s.close();
                    current = this.self.getCurrentVote();
                    LeaderElection.LOG.info("Found leader: my type is: " + this.self.getLearnerType());
                    if (this.self.getLearnerType() != QuorumPeer.LearnerType.OBSERVER) ** GOTO lbl85
                    if (current.getId() == this.self.getId()) {
                        LeaderElection.LOG.error("OBSERVER elected as leader!");
                        Thread.sleep(100L);
                    } else {
                        this.self.setPeerState(QuorumPeer.ServerState.OBSERVING);
                        Thread.sleep(100L);
                        var13_19 = current;
                        return var13_19;
lbl85:
                        // 1 sources

                        this.self.setPeerState(current.getId() == this.self.getId() ? QuorumPeer.ServerState.LEADING : QuorumPeer.ServerState.FOLLOWING);
                        if (this.self.getPeerState() == QuorumPeer.ServerState.FOLLOWING) {
                            Thread.sleep(100L);
                        }
                        var13_20 = current;
                        return var13_20;
                    }
                }
                Thread.sleep(1000L);
            }
            var9_11 = null;
            return var9_11;
        }
        finally {
            try {
                if (this.self.jmxLeaderElectionBean != null) {
                    MBeanRegistry.getInstance().unregister(this.self.jmxLeaderElectionBean);
                }
            }
            catch (Exception e) {
                LeaderElection.LOG.warn("Failed to unregister with JMX", e);
            }
            this.self.jmxLeaderElectionBean = null;
        }
    }

    protected static class ElectionResult {
        public Vote vote;
        public int count;
        public Vote winner;
        public int winningCount;
        public int numValidVotes;

        protected ElectionResult() {
        }
    }
}

