/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.admin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.admin.AdminServer;
import org.apache.zookeeper.server.admin.CommandResponse;
import org.apache.zookeeper.server.admin.Commands;
import org.apache.zookeeper.server.admin.JsonOutputter;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyAdminServer
implements AdminServer {
    static final Logger LOG = LoggerFactory.getLogger(JettyAdminServer.class);
    public static final int DEFAULT_PORT = 8080;
    public static final int DEFAULT_IDLE_TIMEOUT = 30000;
    public static final String DEFAULT_COMMAND_URL = "/commands";
    private static final String DEFAULT_ADDRESS = "0.0.0.0";
    private final Server server;
    private final String address;
    private final int port;
    private final int idleTimeout;
    private final String commandUrl;
    private ZooKeeperServer zkServer;

    public JettyAdminServer() throws AdminServer.AdminServerException {
        this(System.getProperty("zookeeper.admin.serverAddress", DEFAULT_ADDRESS), Integer.getInteger("zookeeper.admin.serverPort", 8080), Integer.getInteger("zookeeper.admin.idleTimeout", 30000), System.getProperty("zookeeper.admin.commandURL", DEFAULT_COMMAND_URL));
    }

    public JettyAdminServer(String address, int port, int timeout, String commandUrl) {
        this.port = port;
        this.idleTimeout = timeout;
        this.commandUrl = commandUrl;
        this.address = address;
        this.server = new Server();
        ServerConnector connector = new ServerConnector(this.server);
        connector.setHost(address);
        connector.setPort(port);
        connector.setIdleTimeout(this.idleTimeout);
        this.server.addConnector(connector);
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/*");
        this.server.setHandler(context);
        context.addServlet(new ServletHolder(new CommandServlet()), commandUrl + "/*");
    }

    @Override
    public void start() throws AdminServer.AdminServerException {
        try {
            this.server.start();
        }
        catch (Exception e) {
            throw new AdminServer.AdminServerException(String.format("Problem starting AdminServer on address %s, port %d and command URL %s", this.address, this.port, this.commandUrl), e);
        }
        LOG.info(String.format("Started AdminServer on address %s, port %d and command URL %s", this.address, this.port, this.commandUrl));
    }

    @Override
    public void shutdown() throws AdminServer.AdminServerException {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            throw new AdminServer.AdminServerException(String.format("Problem stopping AdminServer on address %s, port %d and command URL %s", this.address, this.port, this.commandUrl), e);
        }
    }

    @Override
    public void setZooKeeperServer(ZooKeeperServer zkServer) {
        this.zkServer = zkServer;
    }

    private List<String> commandLinks() {
        ArrayList<String> links = new ArrayList<String>();
        ArrayList<String> commands = new ArrayList<String>(Commands.getPrimaryNames());
        Collections.sort(commands);
        for (String command : commands) {
            String url = this.commandUrl + "/" + command;
            links.add(String.format("<a href=\"%s\">%s</a>", url, command));
        }
        return links;
    }

    private class CommandServlet
    extends HttpServlet {
        private static final long serialVersionUID = 1L;

        private CommandServlet() {
        }

        @Override
        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            String cmd = request.getPathInfo();
            if (cmd == null || cmd.equals("/")) {
                for (String link : JettyAdminServer.this.commandLinks()) {
                    response.getWriter().println(link);
                    response.getWriter().println("<br/>");
                }
                return;
            }
            cmd = cmd.substring(1);
            Map<String, String[]> parameterMap = request.getParameterMap();
            HashMap<String, String> kwargs = new HashMap<String, String>();
            for (Map.Entry<String, String[]> entry : parameterMap.entrySet()) {
                kwargs.put(entry.getKey(), entry.getValue()[0]);
            }
            CommandResponse cmdResponse = Commands.runCommand(cmd, JettyAdminServer.this.zkServer, kwargs);
            JsonOutputter outputter = new JsonOutputter();
            response.setStatus(200);
            response.setContentType(outputter.getContentType());
            outputter.output(cmdResponse, response.getWriter());
        }
    }
}

