/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.DefaultEventExecutor;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.common.ClientX509Util;
import org.apache.zookeeper.common.NettyUtils;
import org.apache.zookeeper.common.X509Exception;
import org.apache.zookeeper.server.NettyServerCnxn;
import org.apache.zookeeper.server.ServerCnxn;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.auth.ProviderRegistry;
import org.apache.zookeeper.server.auth.X509AuthenticationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyServerCnxnFactory
extends ServerCnxnFactory {
    private static final Logger LOG = LoggerFactory.getLogger(NettyServerCnxnFactory.class);
    private final ServerBootstrap bootstrap;
    private Channel parentChannel;
    private final ChannelGroup allChannels = new DefaultChannelGroup("zkServerCnxns", (EventExecutor)new DefaultEventExecutor());
    private final Map<InetAddress, Set<NettyServerCnxn>> ipMap = new HashMap<InetAddress, Set<NettyServerCnxn>>();
    private InetSocketAddress localAddress;
    private int maxClientCnxns = 60;
    private final ClientX509Util x509Util;
    private static final AttributeKey<NettyServerCnxn> CONNECTION_ATTRIBUTE = AttributeKey.valueOf((String)"NettyServerCnxn");
    private static final AtomicReference<ByteBufAllocator> TEST_ALLOCATOR = new AtomicReference<Object>(null);
    CnxnChannelHandler channelHandler = new CnxnChannelHandler();
    private boolean killed;

    private ServerBootstrap configureBootstrapAllocator(ServerBootstrap bootstrap) {
        ByteBufAllocator testAllocator = TEST_ALLOCATOR.get();
        if (testAllocator != null) {
            return ((ServerBootstrap)bootstrap.option(ChannelOption.ALLOCATOR, (Object)testAllocator)).childOption(ChannelOption.ALLOCATOR, (Object)testAllocator);
        }
        return bootstrap;
    }

    NettyServerCnxnFactory() {
        this.x509Util = new ClientX509Util();
        EventLoopGroup bossGroup = NettyUtils.newNioOrEpollEventLoopGroup(NettyUtils.getClientReachableLocalInetAddressCount());
        EventLoopGroup workerGroup = NettyUtils.newNioOrEpollEventLoopGroup();
        ServerBootstrap bootstrap = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(bossGroup, workerGroup).channel(NettyUtils.nioOrEpollServerSocketChannel())).option(ChannelOption.SO_REUSEADDR, (Object)true)).childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.SO_LINGER, (Object)-1).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                if (NettyServerCnxnFactory.this.secure) {
                    NettyServerCnxnFactory.this.initSSL(pipeline);
                }
                pipeline.addLast("servercnxnfactory", (ChannelHandler)NettyServerCnxnFactory.this.channelHandler);
            }
        });
        this.bootstrap = this.configureBootstrapAllocator(bootstrap);
        this.bootstrap.validate();
    }

    private synchronized void initSSL(ChannelPipeline p) throws X509Exception, KeyManagementException, NoSuchAlgorithmException {
        SSLContext sslContext;
        String authProviderProp = System.getProperty(this.x509Util.getSslAuthProviderProperty());
        if (authProviderProp == null) {
            sslContext = this.x509Util.getDefaultSSLContext();
        } else {
            sslContext = SSLContext.getInstance("TLSv1");
            X509AuthenticationProvider authProvider = (X509AuthenticationProvider)ProviderRegistry.getProvider(System.getProperty(this.x509Util.getSslAuthProviderProperty(), "x509"));
            if (authProvider == null) {
                LOG.error("Auth provider not found: {}", (Object)authProviderProp);
                throw new X509Exception.SSLContextException("Could not create SSLContext with specified auth provider: " + authProviderProp);
            }
            sslContext.init(new X509KeyManager[]{authProvider.getKeyManager()}, new X509TrustManager[]{authProvider.getTrustManager()}, null);
        }
        SSLEngine sslEngine = sslContext.createSSLEngine();
        sslEngine.setUseClientMode(false);
        sslEngine.setNeedClientAuth(true);
        p.addLast("ssl", (ChannelHandler)new SslHandler(sslEngine));
        LOG.info("SSL handler added for channel: {}", (Object)p.channel());
    }

    @Override
    public void closeAll() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("closeAll()");
        }
        int length = this.cnxns.size();
        for (ServerCnxn cnxn : this.cnxns) {
            try {
                cnxn.close();
            }
            catch (Exception e) {
                LOG.warn("Ignoring exception closing cnxn sessionid 0x" + Long.toHexString(cnxn.getSessionId()), e);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("allChannels size:" + this.allChannels.size() + " cnxns size:" + length);
        }
    }

    @Override
    public boolean closeSession(long sessionId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("closeSession sessionid:0x" + sessionId);
        }
        for (ServerCnxn cnxn : this.cnxns) {
            if (cnxn.getSessionId() != sessionId) continue;
            try {
                cnxn.close();
            }
            catch (Exception e) {
                LOG.warn("exception during session close", e);
            }
            return true;
        }
        return false;
    }

    @Override
    public void configure(InetSocketAddress addr, int maxClientCnxns, boolean secure) throws IOException {
        this.configureSaslLogin();
        this.localAddress = addr;
        this.maxClientCnxns = maxClientCnxns;
        this.secure = secure;
    }

    @Override
    public int getMaxClientCnxnsPerHost() {
        return this.maxClientCnxns;
    }

    @Override
    public void setMaxClientCnxnsPerHost(int max) {
        this.maxClientCnxns = max;
    }

    @Override
    public int getLocalPort() {
        return this.localAddress.getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void join() throws InterruptedException {
        NettyServerCnxnFactory nettyServerCnxnFactory = this;
        synchronized (nettyServerCnxnFactory) {
            while (!this.killed) {
                this.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        NettyServerCnxnFactory nettyServerCnxnFactory = this;
        synchronized (nettyServerCnxnFactory) {
            if (this.killed) {
                LOG.info("already shutdown {}", (Object)this.localAddress);
                return;
            }
        }
        LOG.info("shutdown called {}", (Object)this.localAddress);
        this.x509Util.close();
        if (this.login != null) {
            this.login.shutdown();
        }
        EventLoopGroup bossGroup = this.bootstrap.config().group();
        EventLoopGroup workerGroup = this.bootstrap.config().childGroup();
        if (this.parentChannel != null) {
            ChannelFuture parentCloseFuture = this.parentChannel.close();
            if (bossGroup != null) {
                parentCloseFuture.addListener(future -> bossGroup.shutdownGracefully());
            }
            this.closeAll();
            ChannelGroupFuture allChannelsCloseFuture = this.allChannels.close();
            if (workerGroup != null) {
                allChannelsCloseFuture.addListener(future -> workerGroup.shutdownGracefully());
            }
        } else {
            if (bossGroup != null) {
                bossGroup.shutdownGracefully();
            }
            if (workerGroup != null) {
                workerGroup.shutdownGracefully();
            }
        }
        if (this.zkServer != null) {
            this.zkServer.shutdown();
        }
        NettyServerCnxnFactory nettyServerCnxnFactory2 = this;
        synchronized (nettyServerCnxnFactory2) {
            this.killed = true;
            this.notifyAll();
        }
    }

    @Override
    public void start() {
        LOG.info("binding to port {}", (Object)this.localAddress);
        this.parentChannel = this.bootstrap.bind((SocketAddress)this.localAddress).syncUninterruptibly().channel();
        this.localAddress = (InetSocketAddress)this.parentChannel.localAddress();
        LOG.info("bound to port " + this.getLocalPort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reconfigure(InetSocketAddress addr) {
        try (Channel oldChannel = this.parentChannel;){
            LOG.info("binding to port {}", (Object)addr);
            this.parentChannel = this.bootstrap.bind((SocketAddress)addr).syncUninterruptibly().channel();
            this.localAddress = (InetSocketAddress)this.parentChannel.localAddress();
            LOG.info("bound to port " + this.getLocalPort());
        }
    }

    @Override
    public void startup(ZooKeeperServer zks, boolean startServer) throws IOException, InterruptedException {
        this.start();
        this.setZooKeeperServer(zks);
        if (startServer) {
            zks.startdata();
            zks.startup();
        }
    }

    @Override
    public Iterable<ServerCnxn> getConnections() {
        return this.cnxns;
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return this.localAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCnxn(NettyServerCnxn cnxn) {
        this.cnxns.add(cnxn);
        Map<InetAddress, Set<NettyServerCnxn>> map = this.ipMap;
        synchronized (map) {
            InetAddress addr = ((InetSocketAddress)cnxn.getChannel().remoteAddress()).getAddress();
            Set<NettyServerCnxn> s2 = this.ipMap.get(addr);
            if (s2 == null) {
                s2 = new HashSet<NettyServerCnxn>();
                this.ipMap.put(addr, s2);
            }
            s2.add(cnxn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeCnxnFromIpMap(NettyServerCnxn cnxn, InetAddress remoteAddress) {
        Map<InetAddress, Set<NettyServerCnxn>> map = this.ipMap;
        synchronized (map) {
            Set<NettyServerCnxn> s2 = this.ipMap.get(remoteAddress);
            if (s2 != null) {
                s2.remove(cnxn);
                if (s2.isEmpty()) {
                    this.ipMap.remove(remoteAddress);
                }
                return;
            }
        }
        LOG.error("Unexpected null set for remote address {} when removing cnxn {}", (Object)remoteAddress, (Object)cnxn);
    }

    @Override
    public void resetAllConnectionStats() {
        for (ServerCnxn c : this.cnxns) {
            c.resetStats();
        }
    }

    @Override
    public Iterable<Map<String, Object>> getAllConnectionInfo(boolean brief) {
        HashSet<Map<String, Object>> info = new HashSet<Map<String, Object>>();
        for (ServerCnxn c : this.cnxns) {
            info.add(c.getConnectionInfo(brief));
        }
        return info;
    }

    static void setTestAllocator(ByteBufAllocator allocator) {
        TEST_ALLOCATOR.set(allocator);
    }

    static void clearTestAllocator() {
        TEST_ALLOCATOR.set(null);
    }

    @ChannelHandler.Sharable
    class CnxnChannelHandler
    extends ChannelDuplexHandler {
        private final GenericFutureListener<Future<Void>> onWriteCompletedTracer = f -> LOG.trace("write {}", (Object)(f.isSuccess() ? "complete" : "failed"));

        CnxnChannelHandler() {
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Channel active {}", (Object)ctx.channel());
            }
            NettyServerCnxn cnxn = new NettyServerCnxn(ctx.channel(), NettyServerCnxnFactory.this.zkServer, NettyServerCnxnFactory.this);
            ctx.channel().attr(CONNECTION_ATTRIBUTE).set((Object)cnxn);
            if (NettyServerCnxnFactory.this.secure) {
                SslHandler sslHandler = (SslHandler)ctx.pipeline().get(SslHandler.class);
                Future handshakeFuture = sslHandler.handshakeFuture();
                handshakeFuture.addListener((GenericFutureListener)new CertificateVerifier(sslHandler, cnxn));
            } else {
                NettyServerCnxnFactory.this.allChannels.add((Object)ctx.channel());
                NettyServerCnxnFactory.this.addCnxn(cnxn);
            }
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Channel inactive {}", (Object)ctx.channel());
            }
            NettyServerCnxnFactory.this.allChannels.remove((Object)ctx.channel());
            NettyServerCnxn cnxn = (NettyServerCnxn)ctx.channel().attr(CONNECTION_ATTRIBUTE).getAndSet(null);
            if (cnxn != null) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Channel inactive caused close {}", (Object)cnxn);
                }
                cnxn.close();
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            LOG.warn("Exception caught", cause);
            NettyServerCnxn cnxn = (NettyServerCnxn)ctx.channel().attr(CONNECTION_ATTRIBUTE).getAndSet(null);
            if (cnxn != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Closing {}", (Object)cnxn);
                }
                cnxn.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            try {
                if (evt == NettyServerCnxn.AutoReadEvent.ENABLE) {
                    LOG.debug("Received AutoReadEvent.ENABLE");
                    NettyServerCnxn cnxn = (NettyServerCnxn)ctx.channel().attr(CONNECTION_ATTRIBUTE).get();
                    if (cnxn != null) {
                        cnxn.processQueuedBuffer();
                    }
                    ctx.channel().config().setAutoRead(true);
                } else if (evt == NettyServerCnxn.AutoReadEvent.DISABLE) {
                    LOG.debug("Received AutoReadEvent.DISABLE");
                    ctx.channel().config().setAutoRead(false);
                }
            }
            finally {
                ReferenceCountUtil.release((Object)evt);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            try {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("message received called {}", msg);
                }
                try {
                    NettyServerCnxn cnxn;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("New message {} from {}", msg, (Object)ctx.channel());
                    }
                    if ((cnxn = (NettyServerCnxn)ctx.channel().attr(CONNECTION_ATTRIBUTE).get()) == null) {
                        LOG.error("channelRead() on a closed or closing NettyServerCnxn");
                    } else {
                        cnxn.processMessage((ByteBuf)msg);
                    }
                }
                catch (Exception ex) {
                    LOG.error("Unexpected exception in receive", ex);
                    throw ex;
                }
            }
            finally {
                ReferenceCountUtil.release((Object)msg);
            }
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            if (LOG.isTraceEnabled()) {
                promise.addListener(this.onWriteCompletedTracer);
            }
            super.write(ctx, msg, promise);
        }

        private final class CertificateVerifier
        implements GenericFutureListener<Future<Channel>> {
            private final SslHandler sslHandler;
            private final NettyServerCnxn cnxn;

            CertificateVerifier(SslHandler sslHandler, NettyServerCnxn cnxn) {
                this.sslHandler = sslHandler;
                this.cnxn = cnxn;
            }

            public void operationComplete(Future<Channel> future) throws SSLPeerUnverifiedException {
                if (future.isSuccess()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Successful handshake with session 0x{}", (Object)Long.toHexString(this.cnxn.getSessionId()));
                    }
                    SSLEngine eng = this.sslHandler.engine();
                    SSLSession session = eng.getSession();
                    this.cnxn.setClientCertificateChain(session.getPeerCertificates());
                    String authProviderProp = System.getProperty(NettyServerCnxnFactory.this.x509Util.getSslAuthProviderProperty(), "x509");
                    X509AuthenticationProvider authProvider = (X509AuthenticationProvider)ProviderRegistry.getProvider(authProviderProp);
                    if (authProvider == null) {
                        LOG.error("Auth provider not found: {}", (Object)authProviderProp);
                        this.cnxn.close();
                        return;
                    }
                    if (KeeperException.Code.OK != authProvider.handleAuthentication(this.cnxn, null)) {
                        LOG.error("Authentication failed for session 0x{}", (Object)Long.toHexString(this.cnxn.getSessionId()));
                        this.cnxn.close();
                        return;
                    }
                    Channel futureChannel = (Channel)future.getNow();
                    NettyServerCnxnFactory.this.allChannels.add((Object)Objects.requireNonNull(futureChannel));
                    NettyServerCnxnFactory.this.addCnxn(this.cnxn);
                } else {
                    LOG.error("Unsuccessful handshake with session 0x{}", (Object)Long.toHexString(this.cnxn.getSessionId()));
                    this.cnxn.close();
                }
            }
        }
    }
}

