/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.utils;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.InvalidConfigurationValueException;
import org.apache.hadoop.fs.azurebfs.utils.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SASGenerator {
    protected static final Logger LOG = LoggerFactory.getLogger(SASGenerator.class);
    public static final Duration FIVE_MINUTES = Duration.ofMinutes(5L);
    public static final Duration ONE_DAY = Duration.ofDays(1L);
    public static final DateTimeFormatter ISO_8601_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.ROOT).withZone(ZoneId.of("UTC"));
    private Mac hmacSha256;
    private byte[] key;

    private SASGenerator() {
    }

    protected SASGenerator(byte[] key) {
        this.key = key;
        this.initializeMac();
    }

    private void initializeMac() {
        try {
            this.hmacSha256 = Mac.getInstance("HmacSHA256");
            this.hmacSha256.init(new SecretKeySpec(this.key, "HmacSHA256"));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected String getCanonicalAccountName(String accountName) throws InvalidConfigurationValueException {
        int dotIndex = accountName.indexOf(".");
        if (dotIndex == 0) {
            throw new InvalidConfigurationValueException("Account Name is not fully qualified");
        }
        if (dotIndex > 0) {
            return accountName.substring(0, dotIndex);
        }
        return accountName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String computeHmac256(String stringToSign) {
        byte[] hmac;
        byte[] utf8Bytes;
        try {
            utf8Bytes = stringToSign.getBytes(StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
        SASGenerator sASGenerator = this;
        synchronized (sASGenerator) {
            hmac = this.hmacSha256.doFinal(utf8Bytes);
        }
        return Base64.encode((byte[])hmac);
    }

    public static enum AuthenticationVersion {
        Nov18("2018-11-09"),
        Dec19("2019-12-12"),
        Feb20("2020-02-10");

        private final String ver;

        private AuthenticationVersion(String version) {
            this.ver = version;
        }

        public String toString() {
            return this.ver;
        }
    }
}

