/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.io.IOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import org.apache.hadoop.fs.azurebfs.contracts.services.AzureServiceErrorCode;
import org.apache.hadoop.fs.azurebfs.services.RetryReason;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class TestRetryReason {
    @Test
    public void test4xxStatusRetryReason() {
        ((AbstractStringAssert)Assertions.assertThat((String)RetryReason.getAbbreviation(null, (Integer)403, null)).describedAs("Abbreviation for 4xx should be equal to 4xx", new Object[0])).isEqualTo((Object)"403");
    }

    @Test
    public void testConnectionResetRetryReason() {
        SocketException connReset = new SocketException("Connection reset".toUpperCase());
        Assertions.assertThat((String)RetryReason.getAbbreviation((Exception)connReset, null, null)).isEqualTo((Object)"CR");
    }

    @Test
    public void testConnectionTimeoutRetryReason() {
        SocketTimeoutException connectionTimeoutException = new SocketTimeoutException("connect timed out");
        Assertions.assertThat((String)RetryReason.getAbbreviation((Exception)connectionTimeoutException, null, null)).isEqualTo((Object)"CT");
    }

    @Test
    public void testReadTimeoutRetryReason() {
        SocketTimeoutException connectionTimeoutException = new SocketTimeoutException("Read timed out");
        Assertions.assertThat((String)RetryReason.getAbbreviation((Exception)connectionTimeoutException, null, null)).isEqualTo((Object)"RT");
    }

    @Test
    public void testEgressLimitRetryReason() {
        Assertions.assertThat((String)RetryReason.getAbbreviation(null, (Integer)503, (String)AzureServiceErrorCode.EGRESS_OVER_ACCOUNT_LIMIT.getErrorMessage())).isEqualTo((Object)"EGR");
    }

    @Test
    public void testIngressLimitRetryReason() {
        Assertions.assertThat((String)RetryReason.getAbbreviation(null, (Integer)503, (String)AzureServiceErrorCode.INGRESS_OVER_ACCOUNT_LIMIT.getErrorMessage())).isEqualTo((Object)"ING");
    }

    @Test
    public void testOperationLimitRetryReason() {
        Assertions.assertThat((String)RetryReason.getAbbreviation(null, (Integer)503, (String)AzureServiceErrorCode.TPS_OVER_ACCOUNT_LIMIT.getErrorMessage())).isEqualTo((Object)"OPR");
    }

    @Test
    public void test503UnknownRetryReason() {
        Assertions.assertThat((String)RetryReason.getAbbreviation(null, (Integer)503, null)).isEqualTo((Object)"503");
    }

    @Test
    public void test500RetryReason() {
        Assertions.assertThat((String)RetryReason.getAbbreviation(null, (Integer)500, null)).isEqualTo((Object)"500");
    }

    @Test
    public void testUnknownHostRetryReason() {
        Assertions.assertThat((String)RetryReason.getAbbreviation((Exception)new UnknownHostException(), null, null)).isEqualTo((Object)"UH");
    }

    @Test
    public void testUnknownIOExceptionRetryReason() {
        Assertions.assertThat((String)RetryReason.getAbbreviation((Exception)new IOException(), null, null)).isEqualTo((Object)"IOE");
    }

    @Test
    public void testUnknownSocketException() {
        Assertions.assertThat((String)RetryReason.getAbbreviation((Exception)new SocketException(), null, null)).isEqualTo((Object)"SE");
    }
}

