/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.io.IOException;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ClosedIOException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.constants.HttpOperationType;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AbfsDriverException;
import org.apache.hadoop.fs.azurebfs.services.AbfsHttpClientConnectionFactory;
import org.apache.hadoop.fs.azurebfs.services.AbfsManagedApacheHttpConnection;
import org.apache.hadoop.fs.azurebfs.services.KeepAliveCache;
import org.apache.hadoop.security.ssl.DelegatingSSLSocketFactory;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.util.functional.Tuples;
import org.apache.http.HttpHost;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.ManagedHttpClientConnection;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.conn.DefaultHttpClientConnectionOperator;
import org.apache.http.protocol.HttpContext;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class ITestApacheClientConnectionPool
extends AbstractAbfsIntegrationTest {
    @Test
    public void testKacIsClosed() throws Throwable {
        Configuration configuration = new Configuration(this.getRawConfiguration());
        configuration.set("fs.azure.networking.library", HttpOperationType.APACHE_HTTP_CLIENT.name());
        try (AzureBlobFileSystem fs = (AzureBlobFileSystem)FileSystem.newInstance((Configuration)configuration);){
            KeepAliveCache kac = fs.getAbfsStore().getClient().getKeepAliveCache();
            kac.close();
            AbfsDriverException ex = (AbfsDriverException)LambdaTestUtils.intercept(AbfsDriverException.class, (String)"KeepAliveCache is closed", () -> fs.create(new Path("/test")));
            LambdaTestUtils.verifyCause(ClosedIOException.class, (Throwable)ex);
        }
    }

    @Test
    public void testNonConnectedConnectionLogging() throws Exception {
        Map.Entry<HttpRoute, AbfsManagedApacheHttpConnection> testConnPair = this.getTestConnection();
        AbfsManagedApacheHttpConnection conn = testConnPair.getValue();
        String log = conn.toString();
        ((AbstractIntegerAssert)Assertions.assertThat((int)log.split(":").length).describedAs("Log to have three fields: https://host:port:hashCode", new Object[0])).isEqualTo(4);
    }

    @Test
    public void testConnectedConnectionLogging() throws Exception {
        Map.Entry<HttpRoute, AbfsManagedApacheHttpConnection> testConnPair = this.getTestConnection();
        AbfsManagedApacheHttpConnection conn = testConnPair.getValue();
        HttpRoute httpRoute = testConnPair.getKey();
        Registry socketFactoryRegistry = RegistryBuilder.create().register("https", (Object)new SSLConnectionSocketFactory((SSLSocketFactory)DelegatingSSLSocketFactory.getDefaultFactory(), SSLConnectionSocketFactory.getDefaultHostnameVerifier())).build();
        new DefaultHttpClientConnectionOperator((Lookup)socketFactoryRegistry, null, null).connect((ManagedHttpClientConnection)conn, httpRoute.getTargetHost(), httpRoute.getLocalSocketAddress(), this.getConfiguration().getHttpConnectionTimeout(), SocketConfig.DEFAULT, (HttpContext)new HttpClientContext());
        String log = conn.toString();
        ((AbstractIntegerAssert)Assertions.assertThat((int)log.split(":").length).describedAs("Log to have three fields: https://host:port:hashCode", new Object[0])).isEqualTo(4);
    }

    private Map.Entry<HttpRoute, AbfsManagedApacheHttpConnection> getTestConnection() throws IOException {
        HttpHost host = new HttpHost(this.getFileSystem().getUri().getHost(), this.getFileSystem().getUri().getPort(), "https");
        HttpRoute httpRoute = new HttpRoute(host);
        AbfsManagedApacheHttpConnection conn = (AbfsManagedApacheHttpConnection)new AbfsHttpClientConnectionFactory().create(httpRoute, null);
        return Tuples.pair((Object)httpRoute, (Object)conn);
    }
}

