/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FutureDataInputStreamBuilder;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.AbfsStatistic;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsScaleTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystemStore;
import org.apache.hadoop.fs.azurebfs.services.AbfsInputStream;
import org.apache.hadoop.fs.azurebfs.services.AbfsInputStreamTestUtils;
import org.apache.hadoop.fs.azurebfs.utils.TracingContext;
import org.apache.hadoop.util.functional.FutureIO;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class ITestAbfsInputStreamReadFooter
extends AbstractAbfsScaleTest {
    private static final int TEN = 10;
    private static final int TWENTY = 20;
    private static ExecutorService executorService;
    private static final int SIZE_256_KB = 262144;
    private static final Integer[] FILE_SIZES;
    private static final Integer[] READ_BUFFER_SIZE;
    private static final Integer[] FOOTER_READ_BUFFER_SIZE;
    private final AbfsInputStreamTestUtils abfsInputStreamTestUtils = new AbfsInputStreamTestUtils(this);

    @BeforeClass
    public static void init() {
        executorService = Executors.newFixedThreadPool(2 * Runtime.getRuntime().availableProcessors());
    }

    @AfterClass
    public static void close() {
        executorService.shutdown();
    }

    @Test
    public void testOnlyOneServerCallIsMadeWhenTheConfIsTrue() throws Exception {
        this.validateNumBackendCalls(true);
    }

    @Test
    public void testMultipleServerCallsAreMadeWhenTheConfIsFalse() throws Exception {
        this.validateNumBackendCalls(false);
    }

    private void validateNumBackendCalls(boolean optimizeFooterRead) throws Exception {
        int fileIdx = 0;
        ArrayList<Future<Void>> futureList = new ArrayList<Future<Void>>();
        Integer[] integerArray = FILE_SIZES;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int fileSize = integerArray[i];
            int fileId = fileIdx++;
            Future<Void> future = executorService.submit(() -> {
                Void void_;
                block8: {
                    AzureBlobFileSystem spiedFs = this.createSpiedFs(this.getRawConfiguration());
                    try {
                        Path testPath = this.createPathAndFileWithContent(spiedFs, fileId, fileSize);
                        this.validateNumBackendCalls(spiedFs, optimizeFooterRead, fileSize, testPath);
                        void_ = null;
                        if (spiedFs == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (spiedFs != null) {
                                try {
                                    spiedFs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception ex) {
                            throw new RuntimeException(ex);
                        }
                    }
                    spiedFs.close();
                }
                return void_;
            });
            futureList.add(future);
        }
        FutureIO.awaitAllFutures(futureList);
    }

    private void validateNumBackendCalls(AzureBlobFileSystem spiedFs, boolean optimizeFooterRead, int fileSize, Path testFilePath) throws Exception {
        Integer[] integerArray = READ_BUFFER_SIZE;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int readBufferSize = integerArray[i];
            Integer[] integerArray2 = FOOTER_READ_BUFFER_SIZE;
            int n2 = integerArray2.length;
            for (int j = 0; j < n2; ++j) {
                int footerReadBufferSize = integerArray2[j];
                this.changeFooterConfigs(spiedFs, optimizeFooterRead, fileSize, readBufferSize);
                int length = 16384;
                FutureDataInputStreamBuilder builder = this.getParameterizedBuilder(testFilePath, spiedFs, footerReadBufferSize);
                try (FSDataInputStream iStream = (FSDataInputStream)builder.build().get();){
                    this.verifyConfigValueInStream(iStream, footerReadBufferSize);
                    byte[] buffer = new byte[length];
                    Map<String, Long> metricMap = this.getInstrumentationMap(spiedFs);
                    long requestsMadeBeforeTest = metricMap.get(AbfsStatistic.CONNECTIONS_MADE.getStatName());
                    iStream.seek((long)(fileSize - 8));
                    iStream.read(buffer, 0, length);
                    iStream.seek((long)(fileSize - 10240));
                    iStream.read(buffer, 0, length);
                    iStream.seek((long)(fileSize - 20480));
                    iStream.read(buffer, 0, length);
                    metricMap = this.getInstrumentationMap(spiedFs);
                    long requestsMadeAfterTest = metricMap.get(AbfsStatistic.CONNECTIONS_MADE.getStatName());
                    if (optimizeFooterRead) {
                        ITestAbfsInputStreamReadFooter.assertEquals((long)1L, (long)(requestsMadeAfterTest - requestsMadeBeforeTest));
                        continue;
                    }
                    ITestAbfsInputStreamReadFooter.assertEquals((long)3L, (long)(requestsMadeAfterTest - requestsMadeBeforeTest));
                    continue;
                }
            }
        }
    }

    @Test
    public void testSeekToBeginAndReadWithConfTrue() throws Exception {
        this.validateSeekAndReadWithConf(true, SeekTo.BEGIN);
    }

    @Test
    public void testSeekToBeginAndReadWithConfFalse() throws Exception {
        this.validateSeekAndReadWithConf(false, SeekTo.BEGIN);
    }

    @Test
    public void testSeekToBeforeFooterAndReadWithConfTrue() throws Exception {
        this.validateSeekAndReadWithConf(true, SeekTo.BEFORE_FOOTER_START);
    }

    @Test
    public void testSeekToBeforeFooterAndReadWithConfFalse() throws Exception {
        this.validateSeekAndReadWithConf(false, SeekTo.BEFORE_FOOTER_START);
    }

    @Test
    public void testSeekToFooterAndReadWithConfTrue() throws Exception {
        this.validateSeekAndReadWithConf(true, SeekTo.AT_FOOTER_START);
    }

    @Test
    public void testSeekToFooterAndReadWithConfFalse() throws Exception {
        this.validateSeekAndReadWithConf(false, SeekTo.AT_FOOTER_START);
    }

    @Test
    public void testSeekToAfterFooterAndReadWithConfTrue() throws Exception {
        this.validateSeekAndReadWithConf(true, SeekTo.AFTER_FOOTER_START);
    }

    @Test
    public void testSeekToToAfterFooterAndReadWithConfFalse() throws Exception {
        this.validateSeekAndReadWithConf(false, SeekTo.AFTER_FOOTER_START);
    }

    @Test
    public void testSeekToEndAndReadWithConfTrue() throws Exception {
        this.validateSeekAndReadWithConf(true, SeekTo.END);
    }

    @Test
    public void testSeekToEndAndReadWithConfFalse() throws Exception {
        this.validateSeekAndReadWithConf(false, SeekTo.END);
    }

    private void validateSeekAndReadWithConf(boolean optimizeFooterRead, SeekTo seekTo) throws Exception {
        int fileIdx = 0;
        ArrayList<Future<Void>> futureList = new ArrayList<Future<Void>>();
        Integer[] integerArray = FILE_SIZES;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int fileSize = integerArray[i];
            int fileId = fileIdx++;
            futureList.add(executorService.submit(() -> {
                Integer[] integerArray;
                block9: {
                    AzureBlobFileSystem spiedFs = this.createSpiedFs(this.getRawConfiguration());
                    try {
                        String fileName = this.methodName.getMethodName() + fileId;
                        byte[] fileContent = this.abfsInputStreamTestUtils.getRandomBytesArray(fileSize);
                        Path testFilePath = this.abfsInputStreamTestUtils.createFileWithContent((FileSystem)spiedFs, fileName, fileContent);
                        integerArray = READ_BUFFER_SIZE;
                        int n = integerArray.length;
                        for (int i = 0; i < n; ++i) {
                            int readBufferSize = integerArray[i];
                            this.validateSeekAndReadWithConf(spiedFs, optimizeFooterRead, seekTo, readBufferSize, fileSize, testFilePath, fileContent);
                        }
                        integerArray = null;
                        if (spiedFs == null) break block9;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (spiedFs != null) {
                                try {
                                    spiedFs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception ex) {
                            throw new RuntimeException(ex);
                        }
                    }
                    spiedFs.close();
                }
                return integerArray;
            }));
        }
        FutureIO.awaitAllFutures(futureList);
    }

    private void validateSeekAndReadWithConf(AzureBlobFileSystem spiedFs, boolean optimizeFooterRead, SeekTo seekTo, int readBufferSize, int fileSize, Path testFilePath, byte[] fileContent) throws Exception {
        Integer[] integerArray = FOOTER_READ_BUFFER_SIZE;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int footerReadBufferSize = integerArray[i];
            this.changeFooterConfigs(spiedFs, optimizeFooterRead, fileSize, readBufferSize);
            this.seekReadAndTest(spiedFs, testFilePath, this.seekPos(seekTo, fileSize), 100, fileContent, footerReadBufferSize);
        }
    }

    private int seekPos(SeekTo seekTo, int fileSize) {
        if (seekTo == SeekTo.BEGIN) {
            return 0;
        }
        if (seekTo == SeekTo.BEFORE_FOOTER_START) {
            return fileSize - 16384 - 1;
        }
        if (seekTo == SeekTo.AT_FOOTER_START) {
            return fileSize - 16384;
        }
        if (seekTo == SeekTo.END) {
            return fileSize - 1;
        }
        return fileSize - 16384 + 1;
    }

    private void seekReadAndTest(AzureBlobFileSystem fs, Path testFilePath, int seekPos, int length, byte[] fileContent, int footerReadBufferSize) throws Exception {
        AbfsConfiguration conf = this.getAbfsStore(fs).getAbfsConfiguration();
        long actualContentLength = fileContent.length;
        FutureDataInputStreamBuilder builder = this.getParameterizedBuilder(testFilePath, fs, footerReadBufferSize);
        try (FSDataInputStream iStream = (FSDataInputStream)builder.build().get();){
            long expectedFCursor;
            long expectedBCursor;
            long expectedLimit;
            AbfsInputStream abfsInputStream = (AbfsInputStream)iStream.getWrappedStream();
            this.verifyConfigValueInStream(iStream, footerReadBufferSize);
            long readBufferSize = abfsInputStream.getBufferSize();
            this.abfsInputStreamTestUtils.seek(iStream, seekPos);
            byte[] buffer = new byte[length];
            long bytesRead = iStream.read(buffer, 0, length);
            long footerStart = Math.max(0L, actualContentLength - 16384L);
            boolean optimizationOn = conf.optimizeFooterRead() && (long)seekPos >= footerStart;
            long actualLength = length;
            if ((long)(seekPos + length) > actualContentLength) {
                long delta = (long)(seekPos + length) - actualContentLength;
                actualLength = (long)length - delta;
            }
            if (optimizationOn) {
                if (actualContentLength <= (long)footerReadBufferSize) {
                    expectedLimit = actualContentLength;
                    expectedBCursor = (long)seekPos + actualLength;
                } else {
                    expectedLimit = footerReadBufferSize;
                    long lastBlockStart = Math.max(0L, actualContentLength - (long)footerReadBufferSize);
                    expectedBCursor = (long)seekPos - lastBlockStart + actualLength;
                }
                expectedFCursor = actualContentLength;
            } else {
                if ((long)seekPos + readBufferSize < actualContentLength) {
                    expectedLimit = readBufferSize;
                    expectedFCursor = readBufferSize;
                } else {
                    expectedLimit = actualContentLength - (long)seekPos;
                    expectedFCursor = Math.min((long)seekPos + readBufferSize, actualContentLength);
                }
                expectedBCursor = actualLength;
            }
            ITestAbfsInputStreamReadFooter.assertEquals((long)expectedFCursor, (long)abfsInputStream.getFCursor());
            ITestAbfsInputStreamReadFooter.assertEquals((long)expectedFCursor, (long)abfsInputStream.getFCursorAfterLastRead());
            ITestAbfsInputStreamReadFooter.assertEquals((long)expectedLimit, (long)abfsInputStream.getLimit());
            ITestAbfsInputStreamReadFooter.assertEquals((long)expectedBCursor, (long)abfsInputStream.getBCursor());
            ITestAbfsInputStreamReadFooter.assertEquals((long)actualLength, (long)bytesRead);
            this.abfsInputStreamTestUtils.assertContentReadCorrectly(fileContent, seekPos, (int)actualLength, buffer, testFilePath);
            int from = seekPos;
            if (optimizationOn) {
                from = (int)Math.max(0L, actualContentLength - (long)footerReadBufferSize);
            }
            this.abfsInputStreamTestUtils.assertContentReadCorrectly(fileContent, from, (int)abfsInputStream.getLimit(), abfsInputStream.getBuffer(), testFilePath);
        }
    }

    @Test
    public void testPartialReadWithNoData() throws Exception {
        int fileIdx = 0;
        ArrayList<Future<Void>> futureList = new ArrayList<Future<Void>>();
        Integer[] integerArray = FILE_SIZES;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int fileSize = integerArray[i];
            int fileId = fileIdx++;
            String fileName = this.methodName.getMethodName() + fileId;
            futureList.add(executorService.submit(() -> {
                Void void_;
                block8: {
                    AzureBlobFileSystem spiedFs = this.createSpiedFs(this.getRawConfiguration());
                    try {
                        byte[] fileContent = this.abfsInputStreamTestUtils.getRandomBytesArray(fileSize);
                        Path testFilePath = this.abfsInputStreamTestUtils.createFileWithContent((FileSystem)spiedFs, fileName, fileContent);
                        this.validatePartialReadWithNoData(spiedFs, fileSize, fileContent, testFilePath);
                        void_ = null;
                        if (spiedFs == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (spiedFs != null) {
                                try {
                                    spiedFs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception ex) {
                            throw new RuntimeException(ex);
                        }
                    }
                    spiedFs.close();
                }
                return void_;
            }));
            FutureIO.awaitAllFutures(futureList);
        }
    }

    private void validatePartialReadWithNoData(AzureBlobFileSystem spiedFs, int fileSize, byte[] fileContent, Path testFilePath) throws IOException {
        Integer[] integerArray = READ_BUFFER_SIZE;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int readBufferSize = integerArray[i];
            Integer[] integerArray2 = FOOTER_READ_BUFFER_SIZE;
            int n2 = integerArray2.length;
            for (int j = 0; j < n2; ++j) {
                int footerReadBufferSize = integerArray2[j];
                this.changeFooterConfigs(spiedFs, true, fileSize, footerReadBufferSize, readBufferSize);
                this.validatePartialReadWithNoData((FileSystem)spiedFs, testFilePath, fileSize - 16384, 16384, fileContent, footerReadBufferSize, readBufferSize);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validatePartialReadWithNoData(FileSystem fs, Path testFilePath, int seekPos, int length, byte[] fileContent, int footerReadBufferSize, int readBufferSize) throws IOException {
        try (FSDataInputStream iStream = fs.open(testFilePath);){
            AbfsInputStream abfsInputStream = (AbfsInputStream)iStream.getWrappedStream();
            int footerBufferSizeAssert = Math.min(readBufferSize, footerReadBufferSize);
            ((AbstractIntegerAssert)Assertions.assertThat((int)abfsInputStream.getFooterReadBufferSize()).describedAs("Footer Read Buffer Size Should be same as what set in builder", new Object[0])).isEqualTo(footerBufferSizeAssert);
            abfsInputStream = (AbfsInputStream)Mockito.spy((Object)abfsInputStream);
            ((AbfsInputStream)Mockito.doReturn((Object)10).doReturn((Object)10).doCallRealMethod().when((Object)abfsInputStream)).readRemote(ArgumentMatchers.anyLong(), (byte[])ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt(), (TracingContext)ArgumentMatchers.any(TracingContext.class));
            iStream = new FSDataInputStream((InputStream)abfsInputStream);
            this.abfsInputStreamTestUtils.seek(iStream, seekPos);
            byte[] buffer = new byte[length];
            int bytesRead = iStream.read(buffer, 0, length);
            ITestAbfsInputStreamReadFooter.assertEquals((long)length, (long)bytesRead);
            this.abfsInputStreamTestUtils.assertContentReadCorrectly(fileContent, seekPos, length, buffer, testFilePath);
            ITestAbfsInputStreamReadFooter.assertEquals((long)fileContent.length, (long)abfsInputStream.getFCursor());
            ITestAbfsInputStreamReadFooter.assertEquals((long)length, (long)abfsInputStream.getBCursor());
            ITestAbfsInputStreamReadFooter.assertTrue((abfsInputStream.getLimit() >= (long)length ? 1 : 0) != 0);
        }
    }

    @Test
    public void testPartialReadWithSomeData() throws Exception {
        int fileIdx = 0;
        ArrayList<Future<Void>> futureList = new ArrayList<Future<Void>>();
        Integer[] integerArray = FILE_SIZES;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int fileSize = integerArray[i];
            int fileId = fileIdx++;
            futureList.add(executorService.submit(() -> {
                Void void_;
                block8: {
                    AzureBlobFileSystem spiedFs = this.createSpiedFs(this.getRawConfiguration());
                    try {
                        String fileName = this.methodName.getMethodName() + fileId;
                        byte[] fileContent = this.abfsInputStreamTestUtils.getRandomBytesArray(fileSize);
                        Path testFilePath = this.abfsInputStreamTestUtils.createFileWithContent((FileSystem)spiedFs, fileName, fileContent);
                        this.validatePartialReadWithSomeData(spiedFs, fileSize, testFilePath, fileContent);
                        void_ = null;
                        if (spiedFs == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (spiedFs != null) {
                                try {
                                    spiedFs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception ex) {
                            throw new RuntimeException(ex);
                        }
                    }
                    spiedFs.close();
                }
                return void_;
            }));
        }
        FutureIO.awaitAllFutures(futureList);
    }

    private void validatePartialReadWithSomeData(AzureBlobFileSystem spiedFs, int fileSize, Path testFilePath, byte[] fileContent) throws IOException {
        Integer[] integerArray = READ_BUFFER_SIZE;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int readBufferSize = integerArray[i];
            Integer[] integerArray2 = FOOTER_READ_BUFFER_SIZE;
            int n2 = integerArray2.length;
            for (int j = 0; j < n2; ++j) {
                int footerReadBufferSize = integerArray2[j];
                this.changeFooterConfigs(spiedFs, true, fileSize, footerReadBufferSize, readBufferSize);
                this.validatePartialReadWithSomeData((FileSystem)spiedFs, testFilePath, fileSize - 16384, 16384, fileContent, footerReadBufferSize, readBufferSize);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validatePartialReadWithSomeData(FileSystem fs, Path testFilePath, int seekPos, int length, byte[] fileContent, int footerReadBufferSize, int readBufferSize) throws IOException {
        try (FSDataInputStream iStream = fs.open(testFilePath);){
            this.verifyConfigValueInStream(iStream, Math.min(footerReadBufferSize, readBufferSize));
            AbfsInputStream abfsInputStream = (AbfsInputStream)Mockito.spy((Object)((AbfsInputStream)iStream.getWrappedStream()));
            int someDataLength = 2;
            int secondReturnSize = Math.min(fileContent.length, abfsInputStream.getFooterReadBufferSize()) - 10 - someDataLength;
            ((AbfsInputStream)Mockito.doReturn((Object)10).doReturn((Object)secondReturnSize).doCallRealMethod().when((Object)abfsInputStream)).readRemote(ArgumentMatchers.anyLong(), (byte[])ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt(), (TracingContext)ArgumentMatchers.any(TracingContext.class));
            iStream = new FSDataInputStream((InputStream)abfsInputStream);
            this.abfsInputStreamTestUtils.seek(iStream, seekPos);
            byte[] buffer = new byte[length];
            int bytesRead = iStream.read(buffer, 0, length);
            ITestAbfsInputStreamReadFooter.assertEquals((long)length, (long)bytesRead);
            ITestAbfsInputStreamReadFooter.assertEquals((long)fileContent.length, (long)abfsInputStream.getFCursor());
            ITestAbfsInputStreamReadFooter.assertEquals((long)someDataLength, (long)abfsInputStream.getBCursor());
            ITestAbfsInputStreamReadFooter.assertEquals((long)someDataLength, (long)abfsInputStream.getLimit());
        }
    }

    @Test
    public void testFooterReadBufferSizeConfiguration() throws Exception {
        Configuration config = new Configuration(this.getRawConfiguration());
        config.unset("fs.azure.footer.read.request.size");
        try (AzureBlobFileSystem fs = this.createSpiedFs(config);){
            Path testFilePath = this.createPathAndFileWithContent(fs, 0, 1024);
            int footerReadBufferSizeConfig = 4096;
            int footerReadBufferSizeBuilder = 5120;
            FSDataInputStream iStream = fs.open(testFilePath);
            this.verifyConfigValueInStream(iStream, 524288);
            AbfsConfiguration spiedConfig = fs.getAbfsStore().getAbfsConfiguration();
            ((AbfsConfiguration)Mockito.doReturn((Object)4096).when((Object)spiedConfig)).getFooterReadBufferSize();
            iStream = fs.open(testFilePath);
            this.verifyConfigValueInStream(iStream, 4096);
            spiedConfig.unset("fs.azure.footer.read.request.size");
            FutureDataInputStreamBuilder builder = fs.openFile(testFilePath);
            builder.opt("fs.azure.footer.read.request.size", 5120);
            iStream = (FSDataInputStream)builder.build().get();
            this.verifyConfigValueInStream(iStream, 5120);
            ((AbfsConfiguration)Mockito.doReturn((Object)4096).when((Object)spiedConfig)).getFooterReadBufferSize();
            iStream = (FSDataInputStream)builder.build().get();
            this.verifyConfigValueInStream(iStream, 5120);
            ((AbfsConfiguration)Mockito.doReturn((Object)4096).when((Object)spiedConfig)).getFooterReadBufferSize();
            builder = fs.openFile(testFilePath);
            iStream = (FSDataInputStream)builder.build().get();
            this.verifyConfigValueInStream(iStream, 4096);
        }
    }

    private void verifyConfigValueInStream(FSDataInputStream inputStream, int expectedValue) {
        AbfsInputStream stream = (AbfsInputStream)inputStream.getWrappedStream();
        ((AbstractIntegerAssert)Assertions.assertThat((int)stream.getFooterReadBufferSize()).describedAs("Footer Read Buffer Size Value Is Not As Expected", new Object[0])).isEqualTo(expectedValue);
    }

    private Path createPathAndFileWithContent(AzureBlobFileSystem fs, int fileIdx, int fileSize) throws Exception {
        String fileName = this.methodName.getMethodName() + fileIdx;
        byte[] fileContent = this.abfsInputStreamTestUtils.getRandomBytesArray(fileSize);
        return this.abfsInputStreamTestUtils.createFileWithContent((FileSystem)fs, fileName, fileContent);
    }

    private FutureDataInputStreamBuilder getParameterizedBuilder(Path path, AzureBlobFileSystem fs, int footerReadBufferSize) throws Exception {
        FutureDataInputStreamBuilder builder = fs.openFile(path);
        builder.opt("fs.azure.footer.read.request.size", footerReadBufferSize);
        return builder;
    }

    private void changeFooterConfigs(AzureBlobFileSystem spiedFs, boolean optimizeFooterRead, int fileSize, int readBufferSize) {
        AbfsConfiguration configuration = spiedFs.getAbfsStore().getAbfsConfiguration();
        ((AbfsConfiguration)Mockito.doReturn((Object)optimizeFooterRead).when((Object)configuration)).optimizeFooterRead();
        if (fileSize <= readBufferSize) {
            ((AbfsConfiguration)Mockito.doReturn((Object)false).when((Object)configuration)).readSmallFilesCompletely();
        }
    }

    private AzureBlobFileSystem createSpiedFs(Configuration configuration) throws IOException {
        AzureBlobFileSystem spiedFs = (AzureBlobFileSystem)Mockito.spy((Object)((AzureBlobFileSystem)FileSystem.newInstance((Configuration)configuration)));
        AzureBlobFileSystemStore store = (AzureBlobFileSystemStore)Mockito.spy((Object)spiedFs.getAbfsStore());
        ((AzureBlobFileSystem)Mockito.doReturn((Object)store).when((Object)spiedFs)).getAbfsStore();
        AbfsConfiguration spiedConfig = (AbfsConfiguration)Mockito.spy((Object)store.getAbfsConfiguration());
        ((AzureBlobFileSystemStore)Mockito.doReturn((Object)spiedConfig).when((Object)store)).getAbfsConfiguration();
        return spiedFs;
    }

    private void changeFooterConfigs(AzureBlobFileSystem spiedFs, boolean optimizeFooterRead, int fileSize, int footerReadBufferSize, int readBufferSize) {
        AbfsConfiguration configuration = spiedFs.getAbfsStore().getAbfsConfiguration();
        ((AbfsConfiguration)Mockito.doReturn((Object)optimizeFooterRead).when((Object)configuration)).optimizeFooterRead();
        ((AbfsConfiguration)Mockito.doReturn((Object)footerReadBufferSize).when((Object)configuration)).getFooterReadBufferSize();
        ((AbfsConfiguration)Mockito.doReturn((Object)readBufferSize).when((Object)configuration)).getReadBufferSize();
        if (fileSize <= readBufferSize) {
            ((AbfsConfiguration)Mockito.doReturn((Object)false).when((Object)configuration)).readSmallFilesCompletely();
        }
    }

    static {
        FILE_SIZES = new Integer[]{262144, 524288, 0x100000, 0x400000};
        READ_BUFFER_SIZE = new Integer[]{262144, 524288, 0x100000, 0x400000};
        FOOTER_READ_BUFFER_SIZE = new Integer[]{262144, 524288, 0x100000};
    }

    private static enum SeekTo {
        BEGIN,
        AT_FOOTER_START,
        BEFORE_FOOTER_START,
        AFTER_FOOTER_START,
        END;

    }
}

