/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.azure.AbstractWasbTestBase;
import org.apache.hadoop.fs.azure.AzureBlobStorageTestAccount;
import org.apache.hadoop.fs.azure.AzureNativeFileSystemStore;
import org.apache.hadoop.fs.azure.NativeAzureFileSystem;
import org.junit.Test;

public class TestKeyPageBlobDirectories
extends AbstractWasbTestBase {
    @Override
    protected AzureBlobStorageTestAccount createTestAccount() throws Exception {
        return AzureBlobStorageTestAccount.create();
    }

    public void expectPageBlobKey(boolean expectedOutcome, AzureNativeFileSystemStore store, String path) {
        TestKeyPageBlobDirectories.assertEquals((String)("Unexpected result for isPageBlobKey(" + path + ")"), (Object)expectedOutcome, (Object)store.isPageBlobKey(path));
    }

    @Test
    public void testKeySetWithoutAsterisk() throws Exception {
        NativeAzureFileSystem azureFs = this.fs;
        AzureNativeFileSystemStore store = azureFs.getStore();
        Configuration conf = this.fs.getConf();
        String dirList = "/service/WALs,/data/mypageblobfiles";
        conf.set("fs.azure.page.blob.dir", dirList);
        URI uri = this.fs.getUri();
        this.fs.initialize(uri, conf);
        this.expectPageBlobKey(false, store, "/");
        this.expectPageBlobKey(false, store, "service");
        this.expectPageBlobKey(false, store, "service/dir/recovered.edits");
        this.expectPageBlobKey(true, store, "service/WALs/recovered.edits");
        this.expectPageBlobKey(false, store, "data/dir/recovered.txt");
        this.expectPageBlobKey(true, store, "data/mypageblobfiles/recovered.txt");
    }

    @Test
    public void testKeySetWithAsterisk() throws Exception {
        NativeAzureFileSystem azureFs = this.fs;
        AzureNativeFileSystemStore store = azureFs.getStore();
        Configuration conf = this.fs.getConf();
        String dirList = "/service/*/*/*/recovered.edits,/*/recovered.edits,/*/*/*/WALs, /*/*/oldWALs/*/*";
        conf.set("fs.azure.page.blob.dir", dirList);
        URI uri = this.fs.getUri();
        this.fs.initialize(uri, conf);
        this.expectPageBlobKey(false, store, "/");
        this.expectPageBlobKey(false, store, "service");
        this.expectPageBlobKey(false, store, "service/dir/recovered.edits");
        this.expectPageBlobKey(true, store, "service/dir1/dir2/dir3/recovered.edits");
        this.expectPageBlobKey(false, store, "data/dir/recovered.edits");
        this.expectPageBlobKey(true, store, "data/recovered.edits");
        this.expectPageBlobKey(false, store, "dir1/dir2/WALs/data");
        this.expectPageBlobKey(true, store, "dir1/dir2/dir3/WALs/data1");
        this.expectPageBlobKey(true, store, "dir1/dir2/dir3/WALs/data2");
        this.expectPageBlobKey(false, store, "dir1/oldWALs/data");
        this.expectPageBlobKey(false, store, "dir1/dir2/oldWALs/data");
        this.expectPageBlobKey(true, store, "dir1/dir2/oldWALs/dir3/dir4/data");
    }

    @Test
    public void testKeySetUsingFullName() throws Exception {
        NativeAzureFileSystem azureFs = this.fs;
        AzureNativeFileSystemStore store = azureFs.getStore();
        Configuration conf = this.fs.getConf();
        String dirList = "/service/WALs,/data/mypageblobfiles,/*/*/WALs,/*/*/recover.edits";
        conf.set("fs.azure.page.blob.dir", dirList);
        URI uri = this.fs.getUri();
        this.fs.initialize(uri, conf);
        String defaultFS = FileSystem.getDefaultUri((Configuration)conf).toString();
        this.expectPageBlobKey(false, store, defaultFS + "service/recover.edits");
        this.expectPageBlobKey(true, store, defaultFS + "service/WALs/recover.edits");
        this.expectPageBlobKey(false, store, defaultFS + "data/mismatch/mypageblobfiles/data");
        this.expectPageBlobKey(true, store, defaultFS + "data/mypageblobfiles/data");
        this.expectPageBlobKey(false, store, defaultFS + "dir1/dir2/dir3/WALs/data");
        this.expectPageBlobKey(true, store, defaultFS + "dir1/dir2/WALs/data");
        this.expectPageBlobKey(false, store, defaultFS + "dir1/dir2/dir3/recover.edits");
        this.expectPageBlobKey(true, store, defaultFS + "dir1/dir2/recover.edits");
    }

    @Test
    public void testKeyContainsAsterisk() throws IOException {
        NativeAzureFileSystem azureFs = this.fs;
        AzureNativeFileSystemStore store = azureFs.getStore();
        Configuration conf = this.fs.getConf();
        String dirList = "/service/*/*/*/d*ir,/*/fi**le.data,/*/*/*/WALs*, /*/*/oldWALs";
        conf.set("fs.azure.page.blob.dir", dirList);
        URI uri = this.fs.getUri();
        this.fs.initialize(uri, conf);
        this.expectPageBlobKey(false, store, "/");
        this.expectPageBlobKey(false, store, "service");
        this.expectPageBlobKey(false, store, "service/d*ir/data");
        this.expectPageBlobKey(true, store, "service/dir1/dir2/dir3/d*ir/data");
        this.expectPageBlobKey(false, store, "dir/fi*le.data");
        this.expectPageBlobKey(true, store, "dir/fi**le.data");
        this.expectPageBlobKey(false, store, "dir1/dir2/WALs/data");
        this.expectPageBlobKey(false, store, "dir1/dir2/dir3/WALs/data");
        this.expectPageBlobKey(true, store, "dir1/dir2/dir3/WALs*/data1");
        this.expectPageBlobKey(true, store, "dir1/dir2/dir3/WALs*/data2");
        this.expectPageBlobKey(false, store, "dir1/oldWALs/data");
        this.expectPageBlobKey(true, store, "dir1/dir2/oldWALs/data1");
        this.expectPageBlobKey(true, store, "dir1/dir2/oldWALs/data2");
    }

    @Test
    public void testKeyWithCommonPrefix() throws IOException {
        NativeAzureFileSystem azureFs = this.fs;
        AzureNativeFileSystemStore store = azureFs.getStore();
        Configuration conf = this.fs.getConf();
        String dirList = "/service/WALs,/*/*/WALs";
        conf.set("fs.azure.page.blob.dir", dirList);
        URI uri = this.fs.getUri();
        this.fs.initialize(uri, conf);
        this.expectPageBlobKey(false, store, "/");
        this.expectPageBlobKey(false, store, "service");
        this.expectPageBlobKey(false, store, "service/WALsssssss/dir");
        this.expectPageBlobKey(true, store, "service/WALs/dir");
        this.expectPageBlobKey(false, store, "service/dir/WALsss/data");
        this.expectPageBlobKey(true, store, "service/dir/WALs/data");
    }
}

