/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.oauth2;

import java.io.IOException;
import java.util.Date;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.azurebfs.extensions.CustomTokenProviderAdaptee;
import org.apache.hadoop.fs.azurebfs.oauth2.AccessTokenProvider;
import org.apache.hadoop.fs.azurebfs.oauth2.CustomTokenProviderAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryTestTokenProvider
implements CustomTokenProviderAdaptee {
    private static final Logger LOG = LoggerFactory.getLogger(RetryTestTokenProvider.class);
    private boolean isThisFirstTokenFetch = true;
    private int retryCount = 0;

    public void initialize(Configuration configuration, String accountName) throws IOException {
    }

    public void resetStatusToFirstTokenFetch() {
        this.isThisFirstTokenFetch = true;
        this.retryCount = 0;
    }

    public String getAccessToken() throws IOException {
        if (this.isThisFirstTokenFetch) {
            this.isThisFirstTokenFetch = false;
        } else {
            ++this.retryCount;
        }
        LOG.debug("RetryTestTokenProvider: Throw an exception in fetching tokens");
        throw new IOException("test exception");
    }

    public Date getExpiryTime() {
        return new Date();
    }

    public static RetryTestTokenProvider getCurrentRetryTestProviderInstance(AccessTokenProvider customTokenProvider) {
        return (RetryTestTokenProvider)((CustomTokenProviderAdapter)customTokenProvider).getCustomTokenProviderAdaptee();
    }

    public int getRetryCount() {
        return this.retryCount;
    }
}

