/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.commit;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.commit.AbfsCommitTestHelper;
import org.apache.hadoop.fs.azurebfs.contract.ABFSContractTestBinding;
import org.apache.hadoop.fs.azurebfs.contract.AbfsFileSystemContract;
import org.apache.hadoop.fs.contract.AbstractFSContract;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.TestJobThroughManifestCommitter;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.FileEntry;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.TaskManifest;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.impl.ManifestCommitterSupport;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.impl.ManifestStoreOperations;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.FixMethodOrder;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class ITestAbfsJobThroughManifestCommitter
extends TestJobThroughManifestCommitter {
    private final ABFSContractTestBinding binding = new ABFSContractTestBinding();

    public void setup() throws Exception {
        this.binding.setup();
        super.setup();
    }

    protected Configuration createConfiguration() {
        return this.enableManifestCommitter(AbfsCommitTestHelper.prepareTestConfiguration(this.binding));
    }

    protected AbstractFSContract createContract(Configuration conf) {
        return new AbfsFileSystemContract(conf, this.binding.isSecureMode());
    }

    protected boolean shouldDeleteTestRootAtEndOfTestRun() {
        return true;
    }

    protected void validateTaskAttemptManifest(String attemptId, List<Path> files, TaskManifest manifest) throws IOException {
        super.validateTaskAttemptManifest(attemptId, files, manifest);
        List commit = manifest.getFilesToCommit();
        ManifestStoreOperations operations = this.getStoreOperations();
        for (FileEntry entry : commit) {
            ((AbstractStringAssert)Assertions.assertThat((String)entry.getEtag()).describedAs("Etag of %s", new Object[]{entry})).isNotEmpty();
            FileStatus sourceStatus = operations.getFileStatus(entry.getSourcePath());
            String etag = ManifestCommitterSupport.getEtag((FileStatus)sourceStatus);
            ((AbstractStringAssert)Assertions.assertThat((String)etag).describedAs("Etag of %s", new Object[]{sourceStatus})).isEqualTo((Object)entry.getEtag());
        }
    }
}

