/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.SecureAzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.services.AuthType;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class ITestFileSystemInitialization
extends AbstractAbfsIntegrationTest {
    @Test
    public void ensureAzureBlobFileSystemIsInitialized() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        String accountName = this.getAccountName();
        String filesystem = this.getFileSystemName();
        String scheme = this.getAuthType() == AuthType.SharedKey ? "abfs" : "abfss";
        ITestFileSystemInitialization.assertEquals((Object)fs.getUri(), (Object)new URI(scheme, filesystem + "@" + accountName, null, null, null));
        ITestFileSystemInitialization.assertNotNull((String)"working directory", (Object)fs.getWorkingDirectory());
    }

    @Test
    public void ensureSecureAzureBlobFileSystemIsInitialized() throws Exception {
        String accountName = this.getAccountName();
        String filesystem = this.getFileSystemName();
        URI defaultUri = new URI("abfss", filesystem + "@" + accountName, null, null, null);
        Configuration rawConfig = this.getRawConfiguration();
        rawConfig.set("fs.defaultFS", defaultUri.toString());
        try (SecureAzureBlobFileSystem fs = (SecureAzureBlobFileSystem)FileSystem.newInstance((Configuration)rawConfig);){
            ITestFileSystemInitialization.assertEquals((Object)fs.getUri(), (Object)new URI("abfss", filesystem + "@" + accountName, null, null, null));
            ITestFileSystemInitialization.assertNotNull((String)"working directory", (Object)fs.getWorkingDirectory());
        }
    }

    @Test
    public void testFileSystemCapabilities() throws Throwable {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path p = new Path("}");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.hasPathCapability(p, "fs.capability.etags.available")).describedAs("path capability %s in %s", new Object[]{"fs.capability.etags.available", fs})).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.hasPathCapability(p, "fs.azure.capability.readahead.safe")).describedAs("path capability %s in %s", new Object[]{"fs.azure.capability.readahead.safe", fs})).isTrue();
        boolean etagsAcrossRename = fs.hasPathCapability(p, "fs.capability.etags.preserved.in.rename");
        boolean acls = fs.hasPathCapability(p, "fs.capability.paths.acls");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)etagsAcrossRename).describedAs("capabilities %s=%s and %s=%s in %s", new Object[]{"fs.capability.etags.preserved.in.rename", etagsAcrossRename, "fs.capability.paths.acls", acls, fs})).isEqualTo(acls);
    }
}

