/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbfsStatistic;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.fs.statistics.IOStatisticAssertions;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.assertj.core.api.AbstractLongAssert;
import org.junit.Assert;
import org.junit.Test;

public class ITestAzureBlobFileSystemRename
extends AbstractAbfsIntegrationTest {
    @Test
    public void testEnsureFileIsRenamed() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path src = this.path("testEnsureFileIsRenamed-src");
        this.touch(src);
        Path dest = this.path("testEnsureFileIsRenamed-dest");
        fs.delete(dest, true);
        ContractTestUtils.assertRenameOutcome((FileSystem)fs, (Path)src, (Path)dest, (boolean)true);
        ContractTestUtils.assertIsFile((FileSystem)fs, (Path)dest);
        ContractTestUtils.assertPathDoesNotExist((FileSystem)fs, (String)"expected renamed", (Path)src);
    }

    @Test
    public void testRenameWithPreExistingDestination() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path src = this.path("renameSrc");
        this.touch(src);
        Path dest = this.path("renameDest");
        this.touch(dest);
        ContractTestUtils.assertRenameOutcome((FileSystem)fs, (Path)src, (Path)dest, (boolean)false);
    }

    @Test
    public void testRenameFileUnderDir() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path sourceDir = this.path("/testSrc");
        ContractTestUtils.assertMkdirs((FileSystem)fs, (Path)sourceDir);
        String filename = "file1";
        Path file1 = new Path(sourceDir, filename);
        this.touch(file1);
        Path destDir = this.path("/testDst");
        ContractTestUtils.assertRenameOutcome((FileSystem)fs, (Path)sourceDir, (Path)destDir, (boolean)true);
        FileStatus[] fileStatus = fs.listStatus(destDir);
        ITestAzureBlobFileSystemRename.assertNotNull((String)"Null file status", (Object)fileStatus);
        FileStatus status = fileStatus[0];
        ITestAzureBlobFileSystemRename.assertEquals((String)("Wrong filename in " + status), (Object)filename, (Object)status.getPath().getName());
    }

    @Test
    public void testRenameDirectory() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path testDir = this.path("testDir");
        fs.mkdirs(testDir);
        Path test1 = new Path(testDir + "/test1");
        fs.mkdirs(test1);
        fs.mkdirs(new Path(testDir + "/test1/test2"));
        fs.mkdirs(new Path(testDir + "/test1/test2/test3"));
        ContractTestUtils.assertRenameOutcome((FileSystem)fs, (Path)test1, (Path)new Path(testDir + "/test10"), (boolean)true);
        ContractTestUtils.assertPathDoesNotExist((FileSystem)fs, (String)"rename source dir", (Path)test1);
    }

    @Test
    public void testRenameFirstLevelDirectory() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        ArrayList<Future<Void>> tasks = new ArrayList<Future<Void>>();
        ExecutorService es = Executors.newFixedThreadPool(10);
        Path source = this.path("/test");
        for (int i = 0; i < 1000; ++i) {
            final Path path = new Path(source + "/" + i);
            Callable<Void> callable = new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    ITestAzureBlobFileSystemRename.this.touch(path);
                    return null;
                }
            };
            tasks.add(es.submit(callable));
        }
        for (Future future : tasks) {
            future.get();
        }
        es.shutdownNow();
        Path dest = this.path("/renamedDir");
        ContractTestUtils.assertRenameOutcome((FileSystem)fs, (Path)source, (Path)dest, (boolean)true);
        FileStatus[] fileStatusArray = fs.listStatus(dest);
        ITestAzureBlobFileSystemRename.assertEquals((String)"Wrong number of files in listing", (long)1000L, (long)fileStatusArray.length);
        ContractTestUtils.assertPathDoesNotExist((FileSystem)fs, (String)"rename source dir", (Path)source);
    }

    @Test
    public void testRenameRoot() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        ContractTestUtils.assertRenameOutcome((FileSystem)fs, (Path)new Path("/"), (Path)new Path("/testRenameRoot"), (boolean)false);
        ContractTestUtils.assertRenameOutcome((FileSystem)fs, (Path)new Path(fs.getUri().toString() + "/"), (Path)new Path(fs.getUri().toString() + "/s"), (boolean)false);
    }

    @Test
    public void testPosixRenameDirectory() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path testDir2 = this.path("testDir2");
        fs.mkdirs(new Path(testDir2 + "/test1/test2/test3"));
        fs.mkdirs(new Path(testDir2 + "/test4"));
        Assert.assertTrue((boolean)fs.rename(new Path(testDir2 + "/test1/test2/test3"), new Path(testDir2 + "/test4")));
        ContractTestUtils.assertPathExists((FileSystem)fs, (String)"This path should exist", (Path)testDir2);
        ContractTestUtils.assertPathExists((FileSystem)fs, (String)"This path should exist", (Path)new Path(testDir2 + "/test1/test2"));
        ContractTestUtils.assertPathExists((FileSystem)fs, (String)"This path should exist", (Path)new Path(testDir2 + "/test4"));
        ContractTestUtils.assertPathExists((FileSystem)fs, (String)"This path should exist", (Path)new Path(testDir2 + "/test4/test3"));
        ContractTestUtils.assertPathDoesNotExist((FileSystem)fs, (String)"This path should not exist", (Path)new Path(testDir2 + "/test1/test2/test3"));
    }

    @Test
    public void testRenameWithNoDestinationParentDir() throws Exception {
        this.describe("Verifying the expected behaviour of ABFS rename when destination parent Dir doesn't exist.", new Object[0]);
        AzureBlobFileSystem fs = this.getFileSystem();
        Path sourcePath = this.path(this.getMethodName());
        Path destPath = new Path("falseParent", "someChildFile");
        byte[] data = ContractTestUtils.dataset((int)1024, (int)97, (int)122);
        ContractTestUtils.writeDataset((FileSystem)fs, (Path)sourcePath, (byte[])data, (int)data.length, (int)1024, (boolean)true);
        ITestAzureBlobFileSystemRename.assertFalse((String)"Rename result expected to be false with no Parent dir", (boolean)fs.rename(sourcePath, destPath));
        IOStatistics ioStatistics = fs.getIOStatistics();
        ((AbstractLongAssert)IOStatisticAssertions.assertThatStatisticCounter((IOStatistics)ioStatistics, (String)AbfsStatistic.RENAME_PATH_ATTEMPTS.getStatName()).describedAs("There should be 2 rename attempts if metadata incomplete state failure is hit", new Object[0])).isEqualTo(2L);
    }
}

