/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.nio.file.AccessDeniedException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.constants.ConfigurationKeys;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AzureBlobFileSystemException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.SASTokenProviderException;
import org.apache.hadoop.fs.azurebfs.extensions.MockDelegationSASTokenProvider;
import org.apache.hadoop.fs.azurebfs.services.AuthType;
import org.apache.hadoop.fs.azurebfs.services.FixedSASTokenProvider;
import org.apache.hadoop.fs.azurebfs.utils.AccountSASGenerator;
import org.apache.hadoop.fs.azurebfs.utils.Base64;
import org.apache.hadoop.test.LambdaTestUtils;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.Assume;
import org.junit.Test;

public class ITestAzureBlobFileSystemChooseSAS
extends AbstractAbfsIntegrationTest {
    private String accountSAS = null;
    private static final String TEST_PATH = "testPath";

    public ITestAzureBlobFileSystemChooseSAS() throws Exception {
        Assume.assumeTrue((this.getAuthType() == AuthType.SharedKey ? 1 : 0) != 0);
    }

    @Override
    public void setup() throws Exception {
        this.createFilesystemWithTestFileForSASTests(new Path(TEST_PATH));
        super.setup();
        this.generateAccountSAS();
    }

    private void generateAccountSAS() throws AzureBlobFileSystemException {
        String accountKey = this.getConfiguration().getStorageAccountKey();
        AccountSASGenerator configAccountSASGenerator = new AccountSASGenerator(Base64.decode((String)accountKey));
        configAccountSASGenerator.setPermissions("r");
        this.accountSAS = configAccountSASGenerator.getAccountSAS(this.getAccountName());
    }

    @Test
    public void testBothProviderFixedTokenConfigured() throws Exception {
        AbfsConfiguration testAbfsConfig = new AbfsConfiguration(this.getRawConfiguration(), this.getAccountName());
        this.removeAnyPresetConfiguration(testAbfsConfig);
        testAbfsConfig.set("fs.azure.sas.token.provider.type", MockDelegationSASTokenProvider.class.getName());
        testAbfsConfig.set("fs.azure.sas.fixed.token", this.accountSAS);
        try (AzureBlobFileSystem newTestFs = (AzureBlobFileSystem)FileSystem.newInstance((Configuration)testAbfsConfig.getRawConfiguration());){
            ((ObjectAssert)Assertions.assertThat((Object)testAbfsConfig.getSASTokenProvider()).describedAs("Custom SASTokenProvider Class must be used", new Object[0])).isInstanceOf(MockDelegationSASTokenProvider.class);
            Path testPath = this.path(this.getMethodName());
            newTestFs.create(testPath).close();
            newTestFs.open(testPath).close();
        }
    }

    @Test
    public void testOnlyFixedTokenConfigured() throws Exception {
        AbfsConfiguration testAbfsConfig = new AbfsConfiguration(this.getRawConfiguration(), this.getAccountName());
        this.removeAnyPresetConfiguration(testAbfsConfig);
        testAbfsConfig.set(ConfigurationKeys.accountProperty((String)"fs.azure.sas.fixed.token", (String)this.getAccountName()), this.accountSAS);
        this.testOnlyFixedTokenConfiguredInternal(testAbfsConfig);
        this.removeAnyPresetConfiguration(testAbfsConfig);
        testAbfsConfig.set("fs.azure.sas.fixed.token", this.accountSAS);
        this.testOnlyFixedTokenConfiguredInternal(testAbfsConfig);
    }

    private void testOnlyFixedTokenConfiguredInternal(AbfsConfiguration testAbfsConfig) throws Exception {
        try (AzureBlobFileSystem newTestFs = (AzureBlobFileSystem)FileSystem.newInstance((Configuration)testAbfsConfig.getRawConfiguration());){
            ((ObjectAssert)Assertions.assertThat((Object)testAbfsConfig.getSASTokenProvider()).describedAs("FixedSASTokenProvider Class must be used", new Object[0])).isInstanceOf(FixedSASTokenProvider.class);
            Path testPath = this.path(this.getMethodName());
            LambdaTestUtils.intercept(AccessDeniedException.class, () -> newTestFs.create(testPath));
            newTestFs.getFileStatus(new Path(TEST_PATH));
        }
    }

    @Test
    public void testBothProviderFixedTokenUnset() throws Exception {
        AbfsConfiguration testAbfsConfig = new AbfsConfiguration(this.getRawConfiguration(), this.getAccountName());
        this.removeAnyPresetConfiguration(testAbfsConfig);
        LambdaTestUtils.intercept(SASTokenProviderException.class, () -> FileSystem.newInstance((Configuration)testAbfsConfig.getRawConfiguration()));
    }

    private void removeAnyPresetConfiguration(AbfsConfiguration testAbfsConfig) {
        testAbfsConfig.unset("fs.azure.sas.token.provider.type");
        testAbfsConfig.unset("fs.azure.sas.fixed.token");
        testAbfsConfig.unset(ConfigurationKeys.accountProperty((String)"fs.azure.sas.token.provider.type", (String)this.getAccountName()));
        testAbfsConfig.unset(ConfigurationKeys.accountProperty((String)"fs.azure.sas.fixed.token", (String)this.getAccountName()));
    }
}

