/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.IOException;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.oauth2.AzureADToken;
import org.apache.hadoop.fs.azurebfs.oauth2.MsiTokenProvider;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assume;
import org.junit.Test;

public final class ITestAbfsMsiTokenProvider
extends AbstractAbfsIntegrationTest {
    @Test
    public void test() throws IOException {
        AbfsConfiguration conf = this.getConfiguration();
        Assume.assumeThat((Object)conf.get("fs.azure.account.oauth2.msi.endpoint"), (Matcher)CoreMatchers.not((Matcher)Matchers.isEmptyOrNullString()));
        Assume.assumeThat((Object)conf.get("fs.azure.account.oauth2.msi.tenant"), (Matcher)CoreMatchers.not((Matcher)Matchers.isEmptyOrNullString()));
        Assume.assumeThat((Object)conf.get("fs.azure.account.oauth2.client.id"), (Matcher)CoreMatchers.not((Matcher)Matchers.isEmptyOrNullString()));
        Assume.assumeThat((Object)conf.get("fs.azure.account.oauth2.msi.authority"), (Matcher)CoreMatchers.not((Matcher)Matchers.isEmptyOrNullString()));
        String tenantGuid = conf.getPasswordString("fs.azure.account.oauth2.msi.tenant");
        String clientId = conf.getPasswordString("fs.azure.account.oauth2.client.id");
        String authEndpoint = this.getTrimmedPasswordString(conf, "fs.azure.account.oauth2.msi.endpoint", "http://169.254.169.254/metadata/identity/oauth2/token");
        String authority = this.getTrimmedPasswordString(conf, "fs.azure.account.oauth2.msi.authority", "https://login.microsoftonline.com/");
        MsiTokenProvider tokenProvider = new MsiTokenProvider(authEndpoint, tenantGuid, clientId, authority);
        AzureADToken token = null;
        token = tokenProvider.getToken();
        ITestAbfsMsiTokenProvider.assertThat((Object)token.getAccessToken(), (Matcher)CoreMatchers.not((Matcher)Matchers.isEmptyString()));
        ITestAbfsMsiTokenProvider.assertThat((Object)token.getExpiry().after(new Date()), (Matcher)CoreMatchers.is((Object)true));
    }

    private String getTrimmedPasswordString(AbfsConfiguration conf, String key, String defaultValue) throws IOException {
        String value = conf.getPasswordString(key);
        if (StringUtils.isBlank((CharSequence)value)) {
            value = defaultValue;
        }
        return value.trim();
    }
}

