/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.IOException;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.junit.rules.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractAbfsTestWithTimeout
extends Assert {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractAbfsTestWithTimeout.class);
    @Rule
    public TestName methodName = new TestName();
    @Rule
    public Timeout testTimeout = new Timeout(this.getTestTimeoutMillis());

    @BeforeClass
    public static void nameTestThread() {
        Thread.currentThread().setName("JUnit");
    }

    @Before
    public void nameThread() {
        Thread.currentThread().setName("JUnit-" + this.methodName.getMethodName());
    }

    protected int getTestTimeoutMillis() {
        return 900000;
    }

    protected void describe(String text, Object ... args) {
        LOG.info("\n\n{}: {}\n", (Object)this.methodName.getMethodName(), (Object)String.format(text, args));
    }

    protected boolean validateContent(AzureBlobFileSystem fs, Path path, byte[] originalByteArray) throws IOException {
        int lenOfOriginalByteArray = originalByteArray.length;
        try (FSDataInputStream in = fs.open(path);){
            byte valueOfContentAtPos = (byte)in.read();
            for (int pos = 0; valueOfContentAtPos != -1 && pos < lenOfOriginalByteArray; ++pos) {
                if (originalByteArray[pos] != valueOfContentAtPos) {
                    AbstractAbfsTestWithTimeout.assertEquals((String)"Mismatch in content validation at position {}", (float)pos, (float)originalByteArray[pos], (float)valueOfContentAtPos);
                    boolean bl = false;
                    return bl;
                }
                valueOfContentAtPos = (byte)in.read();
            }
            if (valueOfContentAtPos != -1) {
                AbstractAbfsTestWithTimeout.assertEquals((String)"Expected end of file", (long)-1L, (long)valueOfContentAtPos);
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }
}

