/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.Hashtable;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azure.AzureNativeFileSystemStore;
import org.apache.hadoop.fs.azure.NativeAzureFileSystem;
import org.apache.hadoop.fs.azure.NativeFileSystemStore;
import org.apache.hadoop.fs.azure.metrics.AzureFileSystemInstrumentation;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.AbfsStatistic;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsTestWithTimeout;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystemStore;
import org.apache.hadoop.fs.azurebfs.constants.ConfigurationKeys;
import org.apache.hadoop.fs.azurebfs.constants.FSOperationType;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AbfsRestOperationException;
import org.apache.hadoop.fs.azurebfs.contracts.services.AzureServiceErrorCode;
import org.apache.hadoop.fs.azurebfs.oauth2.AccessTokenProvider;
import org.apache.hadoop.fs.azurebfs.security.AbfsDelegationTokenManager;
import org.apache.hadoop.fs.azurebfs.services.AbfsClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsOutputStream;
import org.apache.hadoop.fs.azurebfs.services.AuthType;
import org.apache.hadoop.fs.azurebfs.services.ITestAbfsClient;
import org.apache.hadoop.fs.azurebfs.utils.TracingContext;
import org.apache.hadoop.fs.azurebfs.utils.TracingHeaderFormat;
import org.apache.hadoop.fs.azurebfs.utils.UriUtils;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.After;
import org.junit.Assume;
import org.junit.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAbfsIntegrationTest
extends AbstractAbfsTestWithTimeout {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractAbfsIntegrationTest.class);
    private boolean isIPAddress;
    private NativeAzureFileSystem wasb;
    private AzureBlobFileSystem abfs;
    private String abfsScheme;
    private Configuration rawConfig;
    private AbfsConfiguration abfsConfig;
    private String fileSystemName = "abfs-testcontainer-" + UUID.randomUUID().toString();
    private String accountName;
    private String testUrl;
    private AuthType authType;
    private boolean useConfiguredFileSystem = false;
    private boolean usingFilesystemForSASTests = false;
    public static final int SHORTENED_GUID_LEN = 12;

    protected AbstractAbfsIntegrationTest() throws Exception {
        String endPoint;
        this.rawConfig = new Configuration();
        this.rawConfig.addResource("azure-test.xml");
        this.accountName = this.rawConfig.get("fs.azure.account.name");
        if (this.accountName == null) {
            this.accountName = this.rawConfig.get("fs.azure.abfs.account.name");
        }
        Assume.assumeTrue((String)"Not set: fs.azure.abfs.account.name", (this.accountName != null && !this.accountName.isEmpty() ? 1 : 0) != 0);
        this.abfsConfig = new AbfsConfiguration(this.rawConfig, this.accountName);
        this.authType = (AuthType)this.abfsConfig.getEnum("fs.azure.account.auth.type", (Enum)AuthType.SharedKey);
        this.assumeValidAuthConfigsPresent();
        this.abfsScheme = this.authType == AuthType.SharedKey ? "abfs" : "abfss";
        String abfsUrl = this.getFileSystemName() + "@" + this.getAccountName();
        URI defaultUri = null;
        try {
            defaultUri = new URI(this.abfsScheme, abfsUrl, null, null, null);
        }
        catch (Exception ex) {
            throw new AssertionError((Object)ex);
        }
        this.testUrl = defaultUri.toString();
        this.abfsConfig.set("fs.defaultFS", defaultUri.toString());
        this.abfsConfig.setBoolean("fs.azure.createRemoteFileSystemDuringInitialization", true);
        if (this.isAppendBlobEnabled()) {
            String appendblobDirs = this.testUrl + "," + this.abfsConfig.get("fs.contract.test.fs.abfs");
            this.rawConfig.set("fs.azure.appendblob.directories", appendblobDirs);
        }
        this.isIPAddress = (endPoint = this.abfsConfig.get("fs.azure.abfs.endpoint")) != null && endPoint.contains(":") && endPoint.split(":").length == 2;
        this.abfsConfig.setIsChecksumValidationEnabled(true);
    }

    protected boolean getIsNamespaceEnabled(AzureBlobFileSystem fs) throws IOException {
        return fs.getIsNamespaceEnabled(this.getTestTracingContext(fs, false));
    }

    public static TracingContext getSampleTracingContext(AzureBlobFileSystem fs, boolean needsPrimaryReqId) {
        String correlationId = "test-corr-id";
        String fsId = "test-filesystem-id";
        TracingHeaderFormat format = TracingHeaderFormat.ALL_ID_FORMAT;
        return new TracingContext(correlationId, fsId, FSOperationType.TEST_OP, needsPrimaryReqId, format, null);
    }

    public TracingContext getTestTracingContext(AzureBlobFileSystem fs, boolean needsPrimaryReqId) {
        TracingHeaderFormat format;
        String fsId;
        String correlationId;
        if (fs == null) {
            correlationId = "test-corr-id";
            fsId = "test-filesystem-id";
            format = TracingHeaderFormat.ALL_ID_FORMAT;
        } else {
            AbfsConfiguration abfsConf = fs.getAbfsStore().getAbfsConfiguration();
            correlationId = abfsConf.getClientCorrelationId();
            fsId = fs.getFileSystemId();
            format = abfsConf.getTracingHeaderFormat();
        }
        return new TracingContext(correlationId, fsId, FSOperationType.TEST_OP, needsPrimaryReqId, format, null);
    }

    @Before
    public void setup() throws Exception {
        this.createFileSystem();
        if (!this.isIPAddress && this.abfsConfig.getAuthType(this.accountName) != AuthType.SAS && !this.abfs.getIsNamespaceEnabled(this.getTestTracingContext(this.getFileSystem(), false))) {
            URI wasbUri = new URI(AbstractAbfsIntegrationTest.abfsUrlToWasbUrl(this.getTestUrl(), this.abfsConfig.isHttpsAlwaysUsed()));
            AzureNativeFileSystemStore azureNativeFileSystemStore = new AzureNativeFileSystemStore();
            String accountNameWithoutDomain = this.accountName.split("\\.")[0];
            String wasbAccountName = accountNameWithoutDomain + ".blob.core.windows.net";
            String keyProperty = "fs.azure.account.key." + wasbAccountName;
            if (this.rawConfig.get(keyProperty) == null) {
                this.rawConfig.set(keyProperty, this.getAccountKey());
            }
            azureNativeFileSystemStore.initialize(wasbUri, this.rawConfig, new AzureFileSystemInstrumentation(this.rawConfig));
            this.wasb = new NativeAzureFileSystem((NativeFileSystemStore)azureNativeFileSystemStore);
            this.wasb.initialize(wasbUri, this.rawConfig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void teardown() throws Exception {
        try {
            IOUtils.closeStream((Closeable)this.wasb);
            this.wasb = null;
            if (this.abfs == null) {
                return;
            }
            final TracingContext tracingContext = this.getTestTracingContext(this.getFileSystem(), false);
            if (this.usingFilesystemForSASTests) {
                this.abfsConfig.set("fs.azure.account.auth.type", AuthType.SharedKey.name());
                AzureBlobFileSystem tempFs = (AzureBlobFileSystem)FileSystem.newInstance((Configuration)this.rawConfig);
                tempFs.getAbfsStore().deleteFilesystem(tracingContext);
            } else if (!this.useConfiguredFileSystem) {
                final AzureBlobFileSystemStore abfsStore = this.abfs.getAbfsStore();
                abfsStore.deleteFilesystem(tracingContext);
                AbfsRestOperationException ex = (AbfsRestOperationException)LambdaTestUtils.intercept(AbfsRestOperationException.class, (Callable)new Callable<Hashtable<String, String>>(){

                    @Override
                    public Hashtable<String, String> call() throws Exception {
                        return abfsStore.getFilesystemProperties(tracingContext);
                    }
                });
                if (AzureServiceErrorCode.FILE_SYSTEM_NOT_FOUND.getStatusCode() != ex.getStatusCode()) {
                    LOG.warn("Deleted test filesystem may still exist: {}", (Object)this.abfs, (Object)ex);
                }
            }
        }
        catch (Exception e) {
            LOG.warn("During cleanup: {}", (Object)e, (Object)e);
        }
        finally {
            IOUtils.closeStream((Closeable)this.abfs);
            this.abfs = null;
        }
    }

    public AccessTokenProvider getAccessTokenProvider(AzureBlobFileSystem fs) {
        return ITestAbfsClient.getAccessTokenProvider(fs.getAbfsStore().getClient());
    }

    public void loadConfiguredFileSystem() throws Exception {
        this.abfsConfig.setBoolean("fs.azure.createRemoteFileSystemDuringInitialization", false);
        this.assumeValidTestConfigPresent(this.getRawConfiguration(), "fs.contract.test.fs.abfs");
        String[] authorityParts = new URI(this.rawConfig.get("fs.contract.test.fs.abfs")).getRawAuthority().split("@", 2);
        this.fileSystemName = authorityParts[0];
        String abfsUrl = this.getFileSystemName() + "@" + this.getAccountName();
        URI defaultUri = null;
        defaultUri = new URI(this.abfsScheme, abfsUrl, null, null, null);
        this.testUrl = defaultUri.toString();
        this.abfsConfig.set("fs.defaultFS", defaultUri.toString());
        this.useConfiguredFileSystem = true;
    }

    protected void createFilesystemForSASTests() throws Exception {
        this.createFilesystemWithTestFileForSASTests(null);
    }

    protected void createFilesystemWithTestFileForSASTests(Path testPath) throws Exception {
        try (AzureBlobFileSystem tempFs = (AzureBlobFileSystem)FileSystem.newInstance((Configuration)this.rawConfig);){
            ContractTestUtils.assertPathExists((FileSystem)tempFs, (String)"This path should exist", (Path)new Path("/"));
            if (testPath != null) {
                tempFs.create(testPath).close();
            }
            this.abfsConfig.set("fs.azure.account.auth.type", AuthType.SAS.name());
            this.usingFilesystemForSASTests = true;
        }
    }

    public AzureBlobFileSystem getFileSystem() throws IOException {
        return this.abfs;
    }

    public AzureBlobFileSystem getFileSystem(Configuration configuration) throws Exception {
        AzureBlobFileSystem fs = (AzureBlobFileSystem)FileSystem.get((Configuration)configuration);
        return fs;
    }

    public AzureBlobFileSystem getFileSystem(String abfsUri) throws Exception {
        this.abfsConfig.set("fs.defaultFS", abfsUri);
        AzureBlobFileSystem fs = (AzureBlobFileSystem)FileSystem.get((Configuration)this.rawConfig);
        return fs;
    }

    public AzureBlobFileSystem createFileSystem() throws IOException {
        if (this.abfs == null) {
            this.abfs = (AzureBlobFileSystem)FileSystem.newInstance((Configuration)this.rawConfig);
        }
        return this.abfs;
    }

    protected NativeAzureFileSystem getWasbFileSystem() {
        return this.wasb;
    }

    protected String getHostName() {
        String endPoint = this.abfsConfig.get("fs.azure.abfs.endpoint");
        return endPoint.split(":")[0];
    }

    protected void setTestUrl(String testUrl) {
        this.testUrl = testUrl;
    }

    protected String getTestUrl() {
        return this.testUrl;
    }

    protected void setFileSystemName(String fileSystemName) {
        this.fileSystemName = fileSystemName;
    }

    protected String getMethodName() {
        return this.methodName.getMethodName();
    }

    protected String getFileSystemName() {
        return this.fileSystemName;
    }

    protected String getAccountName() {
        return this.accountName;
    }

    protected String getAccountKey() {
        return this.abfsConfig.get("fs.azure.account.key");
    }

    public AbfsConfiguration getConfiguration() {
        return this.abfsConfig;
    }

    public AbfsConfiguration getConfiguration(AzureBlobFileSystem fs) {
        return fs.getAbfsStore().getAbfsConfiguration();
    }

    public Map<String, Long> getInstrumentationMap(AzureBlobFileSystem fs) {
        return fs.getInstrumentationMap();
    }

    public Configuration getRawConfiguration() {
        return this.abfsConfig.getRawConfiguration();
    }

    public AuthType getAuthType() {
        return this.authType;
    }

    public String getAbfsScheme() {
        return this.abfsScheme;
    }

    protected boolean isIPAddress() {
        return this.isIPAddress;
    }

    protected void write(Path path, byte[] buffer) throws IOException {
        ContractTestUtils.writeDataset((FileSystem)this.getFileSystem(), (Path)path, (byte[])buffer, (int)buffer.length, (int)4096, (boolean)false);
    }

    protected void touch(Path path) throws IOException {
        ContractTestUtils.touch((FileSystem)this.getFileSystem(), (Path)path);
    }

    protected static String wasbUrlToAbfsUrl(String wasbUrl) {
        return AbstractAbfsIntegrationTest.convertTestUrls(wasbUrl, "wasb", "wasbs", "blob", "abfs", "abfss", "dfs", false);
    }

    protected static String abfsUrlToWasbUrl(String abfsUrl, boolean isAlwaysHttpsUsed) {
        return AbstractAbfsIntegrationTest.convertTestUrls(abfsUrl, "abfs", "abfss", "dfs", "wasb", "wasbs", "blob", isAlwaysHttpsUsed);
    }

    private static String convertTestUrls(String url, String fromNonSecureScheme, String fromSecureScheme, String fromDnsPrefix, String toNonSecureScheme, String toSecureScheme, String toDnsPrefix, boolean isAlwaysHttpsUsed) {
        String data = null;
        if (url.startsWith(fromNonSecureScheme + "://") && isAlwaysHttpsUsed) {
            data = url.replace(fromNonSecureScheme + "://", toSecureScheme + "://");
        } else if (url.startsWith(fromNonSecureScheme + "://")) {
            data = url.replace(fromNonSecureScheme + "://", toNonSecureScheme + "://");
        } else if (url.startsWith(fromSecureScheme + "://")) {
            data = url.replace(fromSecureScheme + "://", toSecureScheme + "://");
        }
        if (data != null) {
            data = data.replace("." + fromDnsPrefix + ".", "." + toDnsPrefix + ".");
        }
        return data;
    }

    public Path getTestPath() {
        Path path = new Path(UriUtils.generateUniqueTestPath());
        return path;
    }

    public AzureBlobFileSystemStore getAbfsStore(AzureBlobFileSystem fs) {
        return fs.getAbfsStore();
    }

    public AbfsClient getAbfsClient(AzureBlobFileSystemStore abfsStore) {
        return abfsStore.getClient();
    }

    public void setAbfsClient(AzureBlobFileSystemStore abfsStore, AbfsClient client) {
        abfsStore.setClient(client);
    }

    public Path makeQualified(Path path) throws IOException {
        return this.getFileSystem().makeQualified(path);
    }

    protected Path path(String filepath) throws IOException {
        return this.getFileSystem().makeQualified(new Path(this.getTestPath(), this.getUniquePath(filepath)));
    }

    protected Path getUniquePath(String filepath) {
        if (filepath.equals("/")) {
            return new Path(filepath);
        }
        return new Path(filepath + StringUtils.right((String)UUID.randomUUID().toString(), (int)12));
    }

    protected AbfsDelegationTokenManager getDelegationTokenManager() throws IOException {
        return this.getFileSystem().getDelegationTokenManager();
    }

    protected AbfsOutputStream createAbfsOutputStreamWithFlushEnabled(AzureBlobFileSystem fs, Path path) throws IOException {
        AzureBlobFileSystemStore abfss = fs.getAbfsStore();
        abfss.getAbfsConfiguration().setDisableOutputStreamFlush(false);
        return (AbfsOutputStream)abfss.createFile(path, fs.getFsStatistics(), true, FsPermission.getDefault(), FsPermission.getUMask((Configuration)fs.getConf()), this.getTestTracingContext(fs, false));
    }

    protected long assertAbfsStatistics(AbfsStatistic statistic, long expectedValue, Map<String, Long> metricMap) {
        AbstractAbfsIntegrationTest.assertEquals((String)("Mismatch in " + statistic.getStatName()), (long)expectedValue, (long)metricMap.get(statistic.getStatName()));
        return expectedValue;
    }

    protected void assumeValidTestConfigPresent(Configuration conf, String key) {
        String configuredValue = conf.get(ConfigurationKeys.accountProperty((String)key, (String)this.accountName), conf.get(key, ""));
        Assume.assumeTrue((String)String.format("Missing Required Test Config: %s.", key), (!configuredValue.isEmpty() ? 1 : 0) != 0);
    }

    protected void assumeValidAuthConfigsPresent() {
        AuthType currentAuthType = this.getAuthType();
        Assume.assumeFalse((String)"SAS Based Authentication Not Allowed For Integration Tests", (currentAuthType == AuthType.SAS ? 1 : 0) != 0);
        if (currentAuthType == AuthType.SharedKey) {
            this.assumeValidTestConfigPresent(this.getRawConfiguration(), "fs.azure.account.key");
        } else {
            this.assumeValidTestConfigPresent(this.getRawConfiguration(), "fs.azure.account.oauth.provider.type");
        }
    }

    protected boolean isAppendBlobEnabled() {
        return this.getRawConfiguration().getBoolean("fs.azure.test.appendblob.enabled", false);
    }
}

