/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import java.io.IOException;
import java.util.HashMap;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azure.AbstractWasbTestBase;
import org.apache.hadoop.fs.azure.AzureBlobStorageTestAccount;
import org.apache.hadoop.fs.azure.InMemoryBlockBlobStore;
import org.apache.hadoop.fs.azure.WasbFsck;
import org.junit.Test;

public class TestNativeAzureFileSystemFileNameCheck
extends AbstractWasbTestBase {
    private String root = null;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.root = this.fs.getUri().toString();
    }

    @Override
    protected AzureBlobStorageTestAccount createTestAccount() throws Exception {
        return AzureBlobStorageTestAccount.createMock();
    }

    @Test
    public void testCreate() throws Exception {
        Path testFile1 = new Path(this.root + "/testFile1");
        TestNativeAzureFileSystemFileNameCheck.assertTrue((boolean)this.fs.createNewFile(testFile1));
        Path testFile2 = new Path(this.root + "/testFile2:2");
        try {
            this.fs.createNewFile(testFile2);
            TestNativeAzureFileSystemFileNameCheck.fail((String)"Should've thrown.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testRename() throws Exception {
        Path testFile1 = new Path(this.root + "/testFile1");
        TestNativeAzureFileSystemFileNameCheck.assertTrue((boolean)this.fs.createNewFile(testFile1));
        Path testFile2 = new Path(this.root + "/testFile2");
        this.fs.rename(testFile1, testFile2);
        TestNativeAzureFileSystemFileNameCheck.assertTrue((!this.fs.exists(testFile1) && this.fs.exists(testFile2) ? 1 : 0) != 0);
        Path testFile3 = new Path(this.root + "/testFile3:3");
        try {
            this.fs.rename(testFile2, testFile3);
            TestNativeAzureFileSystemFileNameCheck.fail((String)"Should've thrown.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        TestNativeAzureFileSystemFileNameCheck.assertTrue((boolean)this.fs.exists(testFile2));
    }

    @Test
    public void testMkdirs() throws Exception {
        Path testFolder1 = new Path(this.root + "/testFolder1");
        TestNativeAzureFileSystemFileNameCheck.assertTrue((boolean)this.fs.mkdirs(testFolder1));
        Path testFolder2 = new Path(this.root + "/testFolder2:2");
        try {
            TestNativeAzureFileSystemFileNameCheck.assertTrue((boolean)this.fs.mkdirs(testFolder2));
            TestNativeAzureFileSystemFileNameCheck.fail((String)"Should've thrown.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testWasbFsck() throws Exception {
        Path testFolder1 = new Path(this.root + "/testFolder1");
        TestNativeAzureFileSystemFileNameCheck.assertTrue((boolean)this.fs.mkdirs(testFolder1));
        Path testFolder2 = new Path(testFolder1, "testFolder2");
        TestNativeAzureFileSystemFileNameCheck.assertTrue((boolean)this.fs.mkdirs(testFolder2));
        Path testFolder3 = new Path(testFolder1, "testFolder3");
        TestNativeAzureFileSystemFileNameCheck.assertTrue((boolean)this.fs.mkdirs(testFolder3));
        Path testFile1 = new Path(testFolder2, "testFile1");
        TestNativeAzureFileSystemFileNameCheck.assertTrue((boolean)this.fs.createNewFile(testFile1));
        Path testFile2 = new Path(testFolder1, "testFile2");
        TestNativeAzureFileSystemFileNameCheck.assertTrue((boolean)this.fs.createNewFile(testFile2));
        TestNativeAzureFileSystemFileNameCheck.assertFalse((boolean)this.runWasbFsck(testFolder1));
        InMemoryBlockBlobStore backingStore = this.testAccount.getMockStorage().getBackingStore();
        backingStore.setContent(AzureBlobStorageTestAccount.toMockUri("testFolder1/testFolder2/test2:2"), new byte[]{1, 2}, new HashMap<String, String>(), false, 0L);
        TestNativeAzureFileSystemFileNameCheck.assertTrue((boolean)this.runWasbFsck(testFolder1));
    }

    private boolean runWasbFsck(Path p) throws Exception {
        WasbFsck fsck = new WasbFsck(this.fs.getConf());
        fsck.setMockFileSystemForTesting((FileSystem)this.fs);
        fsck.run(new String[]{p.toString()});
        return fsck.getPathNameWarning();
    }
}

