/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.utils;

import java.time.Instant;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AzureBlobFileSystemException;
import org.apache.hadoop.fs.azurebfs.services.AbfsUriQueryBuilder;
import org.apache.hadoop.fs.azurebfs.utils.SASGenerator;

public class AccountSASGenerator
extends SASGenerator {
    private String permissions = "racwdl";

    public AccountSASGenerator(byte[] accountKey) {
        super(accountKey);
    }

    public String getAccountSAS(String accountName) throws AzureBlobFileSystemException {
        accountName = this.getCanonicalAccountName(accountName);
        String sp = this.permissions;
        String sv = "2021-06-08";
        String srt = "sco";
        String st = ISO_8601_FORMATTER.format(Instant.now().minus(FIVE_MINUTES));
        String se = ISO_8601_FORMATTER.format(Instant.now().plus(ONE_DAY));
        String ss = "bf";
        String spr = "https";
        String signature = this.computeSignatureForSAS(sp, ss, srt, st, se, sv, accountName);
        AbfsUriQueryBuilder qb = new AbfsUriQueryBuilder();
        qb.addQuery("sp", sp);
        qb.addQuery("ss", ss);
        qb.addQuery("srt", srt);
        qb.addQuery("st", st);
        qb.addQuery("se", se);
        qb.addQuery("sv", sv);
        qb.addQuery("sig", signature);
        return qb.toString().substring(1);
    }

    private String computeSignatureForSAS(String signedPerm, String signedService, String signedResType, String signedStart, String signedExp, String signedVersion, String accountName) {
        StringBuilder sb = new StringBuilder();
        sb.append(accountName);
        sb.append("\n");
        sb.append(signedPerm);
        sb.append("\n");
        sb.append(signedService);
        sb.append("\n");
        sb.append(signedResType);
        sb.append("\n");
        sb.append(signedStart);
        sb.append("\n");
        sb.append(signedExp);
        sb.append("\n");
        sb.append("\n");
        sb.append("\n");
        sb.append(signedVersion);
        sb.append("\n");
        sb.append("\n");
        String stringToSign = sb.toString();
        LOG.debug("Account SAS stringToSign: " + stringToSign.replace("\n", "."));
        return this.computeHmac256(stringToSign);
    }

    public void setPermissions(String permissions) {
        this.permissions = permissions;
    }
}

