/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.constants.AbfsHttpConstants;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AbfsRestOperationException;
import org.apache.hadoop.fs.azurebfs.oauth2.ClientCredsTokenProvider;
import org.apache.hadoop.fs.azurebfs.services.AbfsClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsClientUtils;
import org.apache.hadoop.fs.azurebfs.services.AbfsRestOperation;
import org.apache.hadoop.fs.azurebfs.services.AuthType;
import org.apache.hadoop.fs.azurebfs.services.ITestAbfsClient;
import org.apache.hadoop.fs.azurebfs.utils.AclTestHelpers;
import org.apache.hadoop.fs.azurebfs.utils.TracingContext;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.util.Lists;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.mockito.Mockito;

public class ITestAbfsPaginatedDelete
extends AbstractAbfsIntegrationTest {
    private AzureBlobFileSystem superUserFs;
    private AzureBlobFileSystem testUserFs;
    private boolean isHnsEnabled;

    @Override
    public void setup() throws Exception {
        super.setup();
        this.superUserFs = this.getFileSystem();
        this.assumeValidTestConfigPresent(this.getRawConfiguration(), "fs.azure.test.namespace.enabled");
        this.isHnsEnabled = this.getConfiguration().getBoolean("fs.azure.test.namespace.enabled", false);
        this.assumeTestUserCredentialsConfigured();
        this.testUserFs = this.isHnsEnabled ? this.createTestUserFs() : null;
    }

    private AzureBlobFileSystem createTestUserFs() throws IOException {
        String firstTestUserGuid = this.getConfiguration().get("fs.azure.check.access.testuser.guid");
        String clientId = this.getConfiguration().getString("fs.azure.account.test.oauth2.client.id", "");
        String clientSecret = this.getConfiguration().getString("fs.azure.account.test.oauth2.client.secret", "");
        Configuration testUserConf = new Configuration(this.getRawConfiguration());
        this.setTestUserConf(testUserConf, "fs.azure.account.auth.type", AuthType.OAuth.name());
        this.setTestUserConf(testUserConf, "fs.azure.account.oauth2.client.id", clientId);
        this.setTestUserConf(testUserConf, "fs.azure.account.oauth2.client.secret", clientSecret);
        this.setTestUserConf(testUserConf, "fs.azure.account.oauth.provider.type", ClientCredsTokenProvider.class.getName());
        testUserConf.setBoolean("fs.azure.createRemoteFileSystemDuringInitialization", false);
        testUserConf.setBoolean(String.format("fs.%s.impl.disable.cache", "abfss"), true);
        this.setDefaultAclOnRoot(firstTestUserGuid);
        return (AzureBlobFileSystem)FileSystem.newInstance((Configuration)testUserConf);
    }

    private void setTestUserConf(Configuration conf, String key, String value) {
        conf.set(key, value);
        conf.set(key + "." + this.getAccountName(), value);
    }

    @Test
    public void testRecursiveDeleteWithPagination() throws Exception {
        this.testRecursiveDeleteWithPaginationInternal(false, true, AbfsHttpConstants.ApiVersion.DEC_12_2019);
        this.testRecursiveDeleteWithPaginationInternal(false, true, AbfsHttpConstants.ApiVersion.AUG_03_2023);
        this.testRecursiveDeleteWithPaginationInternal(false, false, AbfsHttpConstants.ApiVersion.DEC_12_2019);
        this.testRecursiveDeleteWithPaginationInternal(false, false, AbfsHttpConstants.ApiVersion.AUG_03_2023);
        this.testRecursiveDeleteWithPaginationInternal(true, true, AbfsHttpConstants.ApiVersion.DEC_12_2019);
        this.testRecursiveDeleteWithPaginationInternal(true, false, AbfsHttpConstants.ApiVersion.AUG_03_2023);
    }

    @Test
    public void testNonRecursiveDeleteWithPagination() throws Exception {
        this.testNonRecursiveDeleteWithPaginationInternal(true);
        this.testNonRecursiveDeleteWithPaginationInternal(false);
    }

    @Test
    public void testRecursiveDeleteWithInvalidCT() throws Exception {
        this.testRecursiveDeleteWithInvalidCTInternal(true);
        this.testRecursiveDeleteWithInvalidCTInternal(false);
    }

    private void testRecursiveDeleteWithPaginationInternal(boolean isEmptyDir, boolean isPaginatedDeleteEnabled, AbfsHttpConstants.ApiVersion xMsVersion) throws Exception {
        Path testPath;
        AzureBlobFileSystem fs = this.getUserFileSystem();
        TracingContext testTC = this.getTestTracingContext(fs, true);
        if (isEmptyDir) {
            testPath = new Path("/emptyPath" + StringUtils.right((String)UUID.randomUUID().toString(), (int)10));
            this.superUserFs.mkdirs(testPath);
        } else {
            testPath = this.createSmallDir();
        }
        AbfsClient spiedClient = (AbfsClient)Mockito.spy((Object)fs.getAbfsStore().getClient());
        ITestAbfsClient.setAbfsClientField(spiedClient, "xMsVersion", xMsVersion);
        ((AbfsClient)Mockito.doReturn((Object)isPaginatedDeleteEnabled).when((Object)spiedClient)).getIsPaginatedDeleteEnabled();
        AbfsRestOperation op = spiedClient.deletePath(testPath.toString(), true, null, testTC, this.isHnsEnabled);
        String xMsVersionUsed = AbfsClientUtils.getHeaderValue(op.getRequestHeaders(), "x-ms-version");
        String urlUsed = op.getUrl().toString();
        if (isPaginatedDeleteEnabled && this.isHnsEnabled) {
            ((AbstractStringAssert)Assertions.assertThat((String)urlUsed).describedAs("Url must have paginated = true as query param", new Object[0])).contains(new CharSequence[]{"paginated"});
            if (xMsVersion.compareTo((Enum)AbfsHttpConstants.ApiVersion.AUG_03_2023) < 0) {
                ((AbstractStringAssert)Assertions.assertThat((String)xMsVersionUsed).describedAs("Request was made with wrong x-ms-version", new Object[0])).isEqualTo((Object)AbfsHttpConstants.ApiVersion.AUG_03_2023.toString());
            } else if (xMsVersion.compareTo((Enum)AbfsHttpConstants.ApiVersion.AUG_03_2023) >= 0) {
                ((AbstractStringAssert)Assertions.assertThat((String)xMsVersionUsed).describedAs("Request was made with wrong x-ms-version", new Object[0])).isEqualTo((Object)xMsVersion.toString());
            }
        } else {
            ((AbstractStringAssert)Assertions.assertThat((String)urlUsed).describedAs("Url must not have paginated = true as query param", new Object[0])).doesNotContain(new CharSequence[]{"paginated"});
            ((AbstractStringAssert)Assertions.assertThat((String)xMsVersionUsed).describedAs("Request was made with wrong x-ms-version", new Object[0])).isEqualTo((Object)xMsVersion.toString());
        }
        AbfsRestOperationException e = (AbfsRestOperationException)LambdaTestUtils.intercept(AbfsRestOperationException.class, () -> spiedClient.getPathStatus(testPath.toString(), false, testTC, null));
        this.assertStatusCode(e, 404);
    }

    private void testNonRecursiveDeleteWithPaginationInternal(boolean isPaginatedDeleteEnabled) throws Exception {
        AzureBlobFileSystem fs = this.getUserFileSystem();
        TracingContext testTC = this.getTestTracingContext(fs, true);
        Path testPath = new Path("/emptyPath");
        this.superUserFs.mkdirs(testPath);
        AbfsClient spiedClient = (AbfsClient)Mockito.spy((Object)fs.getAbfsStore().getClient());
        ((AbfsClient)Mockito.doReturn((Object)isPaginatedDeleteEnabled).when((Object)spiedClient)).getIsPaginatedDeleteEnabled();
        AbfsRestOperation op = spiedClient.deletePath(testPath.toString(), false, null, testTC, this.isHnsEnabled);
        String urlUsed = op.getUrl().toString();
        ((AbstractStringAssert)Assertions.assertThat((String)urlUsed).describedAs("Url must not have paginated as query param", new Object[0])).doesNotContain(new CharSequence[]{"paginated"});
        AbfsRestOperationException e = (AbfsRestOperationException)LambdaTestUtils.intercept(AbfsRestOperationException.class, () -> spiedClient.getPathStatus(testPath.toString(), false, testTC, null));
        this.assertStatusCode(e, 404);
    }

    private void testRecursiveDeleteWithInvalidCTInternal(boolean isPaginatedEnabled) throws Exception {
        AzureBlobFileSystem fs = this.getUserFileSystem();
        Path testPath = this.createSmallDir();
        String randomCT = "randomContinuationToken1234";
        TracingContext testTC = this.getTestTracingContext(this.testUserFs, true);
        AbfsClient spiedClient = (AbfsClient)Mockito.spy((Object)fs.getAbfsStore().getClient());
        ((AbfsClient)Mockito.doReturn((Object)isPaginatedEnabled).when((Object)spiedClient)).getIsPaginatedDeleteEnabled();
        AbfsRestOperationException e = (AbfsRestOperationException)LambdaTestUtils.intercept(AbfsRestOperationException.class, () -> spiedClient.deletePath(testPath.toString(), true, randomCT, testTC, this.isHnsEnabled));
        this.assertStatusCode(e, 400);
    }

    private void setDefaultAclOnRoot(String uid) throws IOException {
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, uid, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, uid, FsAction.ALL)});
        this.superUserFs.modifyAclEntries(new Path("/"), (List)aclSpec);
    }

    private Path createSmallDir() throws IOException {
        String rootPath = "/smallDir" + StringUtils.right((String)UUID.randomUUID().toString(), (int)10);
        String firstFilePath = rootPath + "/placeholderFile";
        this.superUserFs.create(new Path(firstFilePath));
        for (int i = 1; i <= 2; ++i) {
            String dirPath = "/dirLevel1-" + i + "/dirLevel2-" + i;
            String filePath = rootPath + dirPath + "/file-" + i;
            this.superUserFs.create(new Path(filePath));
        }
        return new Path(rootPath);
    }

    private AzureBlobFileSystem getUserFileSystem() {
        return this.isHnsEnabled ? this.testUserFs : this.superUserFs;
    }

    private void assertStatusCode(AbfsRestOperationException e, int statusCode) {
        ((AbstractIntegerAssert)Assertions.assertThat((int)e.getStatusCode()).describedAs("Request Should fail with Bad Request instead of %s", new Object[]{e.toString()})).isEqualTo(statusCode);
    }

    private void assumeTestUserCredentialsConfigured() {
        this.assumeValidTestConfigPresent(this.getRawConfiguration(), "fs.azure.account.oauth2.client.endpoint");
        this.assumeValidTestConfigPresent(this.getRawConfiguration(), "fs.azure.check.access.testuser.guid");
        this.assumeValidTestConfigPresent(this.getRawConfiguration(), "fs.azure.account.test.oauth2.client.id");
        this.assumeValidTestConfigPresent(this.getRawConfiguration(), "fs.azure.account.test.oauth2.client.secret");
    }
}

