/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.extensions;

import java.io.IOException;
import java.net.URI;
import java.util.Date;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.azurebfs.extensions.BoundDTExtension;
import org.apache.hadoop.fs.azurebfs.extensions.CustomTokenProviderAdaptee;
import org.apache.hadoop.fs.azurebfs.services.AuthType;

public class WrappingTokenProvider
implements CustomTokenProviderAdaptee,
BoundDTExtension {
    public static final String NAME = "org.apache.hadoop.fs.azurebfs.extensions.WrappingTokenProvider";
    public static final String UA_STRING = "provider=";
    public static final String CREATED = "provider=created";
    public static final String INITED = "provider=inited";
    public static final String BOUND = "provider=bound";
    public static final String CLOSED = "provider=closed";
    public static final String ACCESS_TOKEN = "accessToken";
    private URI uri;
    private String accountName;
    private String state = "provider=created";

    public void initialize(Configuration configuration, String account) throws IOException {
        this.state = INITED;
        this.accountName = account;
    }

    public String getAccessToken() throws IOException {
        return ACCESS_TOKEN;
    }

    public Date getExpiryTime() {
        return new Date(System.currentTimeMillis());
    }

    public void bind(URI fsURI, Configuration conf) throws IOException {
        this.state = BOUND;
        this.uri = fsURI;
    }

    public URI getUri() {
        return this.uri;
    }

    public void close() throws IOException {
        this.state = CLOSED;
    }

    public String getUserAgentSuffix() {
        return this.state;
    }

    public static void enable(Configuration conf) {
        conf.setEnum("fs.azure.account.auth.type", (Enum)AuthType.Custom);
        conf.set("fs.azure.account.oauth.provider.type", NAME);
    }
}

