/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.utils;

import com.microsoft.azure.storage.CloudStorageAccount;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import com.microsoft.azure.storage.blob.CloudBlobContainer;
import org.apache.hadoop.fs.azure.AzureBlobStorageTestAccount;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.services.AuthType;
import org.junit.Assume;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AbfsTestUtils
extends AbstractAbfsIntegrationTest {
    private static final Logger LOG = LoggerFactory.getLogger(AbfsTestUtils.class);

    public void checkContainers() throws Throwable {
        Assume.assumeTrue((this.getAuthType() == AuthType.SharedKey ? 1 : 0) != 0);
        int count = 0;
        CloudStorageAccount storageAccount = AzureBlobStorageTestAccount.createTestAccount();
        CloudBlobClient blobClient = storageAccount.createCloudBlobClient();
        Iterable containers = blobClient.listContainers("abfs-testcontainer-");
        for (CloudBlobContainer container : containers) {
            ++count;
            LOG.info("Container {}, URI {}", (Object)container.getName(), (Object)container.getUri());
        }
        LOG.info("Found {} test containers", (Object)count);
    }

    public void deleteContainers() throws Throwable {
        Assume.assumeTrue((this.getAuthType() == AuthType.SharedKey ? 1 : 0) != 0);
        int count = 0;
        CloudStorageAccount storageAccount = AzureBlobStorageTestAccount.createTestAccount();
        CloudBlobClient blobClient = storageAccount.createCloudBlobClient();
        Iterable containers = blobClient.listContainers("abfs-testcontainer-");
        for (CloudBlobContainer container : containers) {
            LOG.info("Container {} URI {}", (Object)container.getName(), (Object)container.getUri());
            if (!container.deleteIfExists()) continue;
            ++count;
        }
        LOG.info("Deleted {} test containers", (Object)count);
    }
}

