/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.NoSuchFileException;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.fs.azurebfs.utils.TextFileBasedIdentityHandler;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestTextFileBasedIdentityHandler {
    @ClassRule
    public static TemporaryFolder tempDir = new TemporaryFolder();
    private static File userMappingFile = null;
    private static File groupMappingFile = null;
    private static final String NEW_LINE = "\n";
    private static String testUserDataLine1 = "a2b27aec-77bd-46dd-8c8c-39611a333331:user1:11000:21000:spi-user1:abcf86e9-5a5b-49e2-a253-f5c9e2afd4ec\n";
    private static String testUserDataLine2 = "#i2j27aec-77bd-46dd-8c8c-39611a333331:user2:41000:21000:spi-user2:mnof86e9-5a5b-49e2-a253-f5c9e2afd4ec\n";
    private static String testUserDataLine3 = "c2d27aec-77bd-46dd-8c8c-39611a333331:user2:21000:21000:spi-user2:deff86e9-5a5b-49e2-a253-f5c9e2afd4ec\n";
    private static String testUserDataLine4 = "e2f27aec-77bd-46dd-8c8c-39611a333331c\n";
    private static String testUserDataLine5 = "g2h27aec-77bd-46dd-8c8c-39611a333331:user4:41000:21000:spi-user4:jklf86e9-5a5b-49e2-a253-f5c9e2afd4ec\n";
    private static String testUserDataLine6 = "          \n";
    private static String testUserDataLine7 = "i2j27aec-77bd-46dd-8c8c-39611a333331:user5:41000:21000:spi-user5:mknf86e9-5a5b-49e2-a253-f5c9e2afd4ec\n";
    private static String testGroupDataLine1 = "1d23024d-957c-4456-aac1-a57f9e2de914:group1:21000:sgp-group1\n";
    private static String testGroupDataLine2 = "3d43024d-957c-4456-aac1-a57f9e2de914:group2:21000:sgp-group2\n";
    private static String testGroupDataLine3 = "5d63024d-957c-4456-aac1-a57f9e2de914\n";
    private static String testGroupDataLine4 = "          \n";
    private static String testGroupDataLine5 = "7d83024d-957c-4456-aac1-a57f9e2de914:group4:21000:sgp-group4\n";

    @BeforeClass
    public static void init() throws IOException {
        userMappingFile = tempDir.newFile("user-mapping.conf");
        groupMappingFile = tempDir.newFile("group-mapping.conf");
        FileUtils.writeStringToFile((File)userMappingFile, (String)testUserDataLine1, (Charset)Charset.forName("UTF-8"), (boolean)true);
        FileUtils.writeStringToFile((File)userMappingFile, (String)testUserDataLine2, (Charset)Charset.forName("UTF-8"), (boolean)true);
        FileUtils.writeStringToFile((File)userMappingFile, (String)testUserDataLine3, (Charset)Charset.forName("UTF-8"), (boolean)true);
        FileUtils.writeStringToFile((File)userMappingFile, (String)testUserDataLine4, (Charset)Charset.forName("UTF-8"), (boolean)true);
        FileUtils.writeStringToFile((File)userMappingFile, (String)testUserDataLine5, (Charset)Charset.forName("UTF-8"), (boolean)true);
        FileUtils.writeStringToFile((File)userMappingFile, (String)testUserDataLine6, (Charset)Charset.forName("UTF-8"), (boolean)true);
        FileUtils.writeStringToFile((File)userMappingFile, (String)testUserDataLine7, (Charset)Charset.forName("UTF-8"), (boolean)true);
        FileUtils.writeStringToFile((File)userMappingFile, (String)NEW_LINE, (Charset)Charset.forName("UTF-8"), (boolean)true);
        FileUtils.writeStringToFile((File)groupMappingFile, (String)testGroupDataLine1, (Charset)Charset.forName("UTF-8"), (boolean)true);
        FileUtils.writeStringToFile((File)groupMappingFile, (String)testGroupDataLine2, (Charset)Charset.forName("UTF-8"), (boolean)true);
        FileUtils.writeStringToFile((File)groupMappingFile, (String)testGroupDataLine3, (Charset)Charset.forName("UTF-8"), (boolean)true);
        FileUtils.writeStringToFile((File)groupMappingFile, (String)testGroupDataLine4, (Charset)Charset.forName("UTF-8"), (boolean)true);
        FileUtils.writeStringToFile((File)groupMappingFile, (String)testGroupDataLine5, (Charset)Charset.forName("UTF-8"), (boolean)true);
        FileUtils.writeStringToFile((File)groupMappingFile, (String)NEW_LINE, (Charset)Charset.forName("UTF-8"), (boolean)true);
    }

    private void assertUserLookup(TextFileBasedIdentityHandler handler, String userInTest, String expectedUser) throws IOException {
        String actualUser = handler.lookupForLocalUserIdentity(userInTest);
        Assert.assertEquals((String)"Wrong user identity for ", (Object)expectedUser, (Object)actualUser);
    }

    @Test
    public void testLookupForUser() throws IOException {
        TextFileBasedIdentityHandler handler = new TextFileBasedIdentityHandler(userMappingFile.getPath(), groupMappingFile.getPath());
        this.assertUserLookup(handler, testUserDataLine3.split(":")[0], testUserDataLine3.split(":")[1]);
        this.assertUserLookup(handler, "bogusIdentity", "");
        this.assertUserLookup(handler, "", "");
    }

    @Test
    public void testLookupForUserFileNotFound() throws Exception {
        TextFileBasedIdentityHandler handler = new TextFileBasedIdentityHandler(userMappingFile.getPath() + ".test", groupMappingFile.getPath());
        LambdaTestUtils.intercept(NoSuchFileException.class, (String)"NoSuchFileException", () -> handler.lookupForLocalUserIdentity(testUserDataLine3.split(":")[0]));
    }

    private void assertGroupLookup(TextFileBasedIdentityHandler handler, String groupInTest, String expectedGroup) throws IOException {
        String actualGroup = handler.lookupForLocalGroupIdentity(groupInTest);
        Assert.assertEquals((String)"Wrong group identity for ", (Object)expectedGroup, (Object)actualGroup);
    }

    @Test
    public void testLookupForGroup() throws IOException {
        TextFileBasedIdentityHandler handler = new TextFileBasedIdentityHandler(userMappingFile.getPath(), groupMappingFile.getPath());
        this.assertGroupLookup(handler, testGroupDataLine2.split(":")[0], testGroupDataLine2.split(":")[1]);
        this.assertGroupLookup(handler, "bogusIdentity", "");
        this.assertGroupLookup(handler, "", "");
    }

    @Test
    public void testLookupForGroupFileNotFound() throws Exception {
        TextFileBasedIdentityHandler handler = new TextFileBasedIdentityHandler(userMappingFile.getPath(), groupMappingFile.getPath() + ".test");
        LambdaTestUtils.intercept(NoSuchFileException.class, (String)"NoSuchFileException", () -> handler.lookupForLocalGroupIdentity(testGroupDataLine2.split(":")[0]));
    }
}

