/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.constants.AbfsHttpConstants;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AzureBlobFileSystemException;
import org.apache.hadoop.fs.azurebfs.oauth2.AccessTokenProvider;
import org.apache.hadoop.fs.azurebfs.services.AbfsClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsClientContext;
import org.apache.hadoop.fs.azurebfs.services.AbfsClientContextBuilder;
import org.apache.hadoop.fs.azurebfs.services.AbfsHttpHeader;
import org.apache.hadoop.fs.azurebfs.services.AbfsPerfTracker;
import org.apache.hadoop.fs.azurebfs.services.AbfsRestOperation;
import org.apache.hadoop.fs.azurebfs.services.AbfsRestOperationType;
import org.apache.hadoop.fs.azurebfs.services.AbfsThrottlingInterceptFactory;
import org.apache.hadoop.fs.azurebfs.services.AbfsUriQueryBuilder;
import org.apache.hadoop.fs.azurebfs.services.AuthType;
import org.apache.hadoop.fs.azurebfs.services.ExponentialRetryPolicy;
import org.apache.hadoop.fs.azurebfs.services.SharedKeyCredentials;
import org.apache.hadoop.security.ssl.DelegatingSSLSocketFactory;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assume;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public final class TestAbfsClient {
    private static final String ACCOUNT_NAME = "bogusAccountName.dfs.core.windows.net";
    private static final String FS_AZURE_USER_AGENT_PREFIX = "Partner Service";
    private final Pattern userAgentStringPattern;

    public TestAbfsClient() {
        StringBuilder regEx = new StringBuilder();
        regEx.append("^");
        regEx.append("APN/1.0");
        regEx.append(" ");
        regEx.append(AbfsHttpConstants.CLIENT_VERSION);
        regEx.append(" ");
        regEx.append("\\(");
        regEx.append(System.getProperty("java.vendor").replaceAll(" ", ""));
        regEx.append(" ");
        regEx.append("JavaJRE");
        regEx.append(" ");
        regEx.append(System.getProperty("java.version"));
        regEx.append(";");
        regEx.append(" ");
        regEx.append(System.getProperty("os.name").replaceAll(" ", ""));
        regEx.append(" ");
        regEx.append(System.getProperty("os.version"));
        regEx.append("/");
        regEx.append(System.getProperty("os.arch"));
        regEx.append(";");
        regEx.append("([a-zA-Z].*; )?");
        regEx.append("([a-zA-Z].*; )?");
        regEx.append(" ?");
        regEx.append(".+");
        regEx.append("/");
        regEx.append(".+");
        regEx.append("\\)");
        regEx.append("( .*)?");
        regEx.append("$");
        this.userAgentStringPattern = Pattern.compile(regEx.toString());
    }

    private String getUserAgentString(AbfsConfiguration config, boolean includeSSLProvider) throws IOException {
        AbfsClientContext abfsClientContext = new AbfsClientContextBuilder().build();
        AbfsClient client = new AbfsClient(new URL("https://azure.com"), null, config, (AccessTokenProvider)null, abfsClientContext);
        String sslProviderName = null;
        if (includeSSLProvider) {
            sslProviderName = DelegatingSSLSocketFactory.getDefaultFactory().getProviderName();
        }
        return client.initializeUserAgent(config, sslProviderName);
    }

    @Test
    public void verifybBasicInfo() throws Exception {
        Configuration configuration = new Configuration();
        configuration.addResource("azure-test.xml");
        AbfsConfiguration abfsConfiguration = new AbfsConfiguration(configuration, ACCOUNT_NAME);
        this.verifybBasicInfo(this.getUserAgentString(abfsConfiguration, false));
    }

    private void verifybBasicInfo(String userAgentStr) {
        ((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)userAgentStr).describedAs("User-Agent string [" + userAgentStr + "] should be of the pattern: " + this.userAgentStringPattern.pattern(), new Object[0])).matches(this.userAgentStringPattern)).describedAs("User-Agent string should contain java vendor", new Object[0])).contains(new CharSequence[]{System.getProperty("java.vendor").replaceAll(" ", "")})).describedAs("User-Agent string should contain java version", new Object[0])).contains(new CharSequence[]{System.getProperty("java.version")})).describedAs("User-Agent string should contain  OS name", new Object[0])).contains(new CharSequence[]{System.getProperty("os.name").replaceAll(" ", "")})).describedAs("User-Agent string should contain OS version", new Object[0])).contains(new CharSequence[]{System.getProperty("os.version")})).describedAs("User-Agent string should contain OS arch", new Object[0])).contains(new CharSequence[]{System.getProperty("os.arch")});
    }

    @Test
    public void verifyUserAgentPrefix() throws IOException, IllegalAccessException {
        Configuration configuration = new Configuration();
        configuration.addResource("azure-test.xml");
        configuration.set("fs.azure.user.agent.prefix", FS_AZURE_USER_AGENT_PREFIX);
        AbfsConfiguration abfsConfiguration = new AbfsConfiguration(configuration, ACCOUNT_NAME);
        String userAgentStr = this.getUserAgentString(abfsConfiguration, false);
        this.verifybBasicInfo(userAgentStr);
        ((AbstractStringAssert)Assertions.assertThat((String)userAgentStr).describedAs("User-Agent string should contain Partner Service", new Object[0])).contains(new CharSequence[]{FS_AZURE_USER_AGENT_PREFIX});
        configuration.unset("fs.azure.user.agent.prefix");
        abfsConfiguration = new AbfsConfiguration(configuration, ACCOUNT_NAME);
        userAgentStr = this.getUserAgentString(abfsConfiguration, false);
        this.verifybBasicInfo(userAgentStr);
        ((AbstractStringAssert)Assertions.assertThat((String)userAgentStr).describedAs("User-Agent string should not contain Partner Service", new Object[0])).doesNotContain(new CharSequence[]{FS_AZURE_USER_AGENT_PREFIX});
    }

    @Test
    public void verifyUserAgentWithoutSSLProvider() throws Exception {
        Configuration configuration = new Configuration();
        configuration.addResource("azure-test.xml");
        configuration.set("fs.azure.ssl.channel.mode", DelegatingSSLSocketFactory.SSLChannelMode.Default_JSSE.name());
        AbfsConfiguration abfsConfiguration = new AbfsConfiguration(configuration, ACCOUNT_NAME);
        String userAgentStr = this.getUserAgentString(abfsConfiguration, true);
        this.verifybBasicInfo(userAgentStr);
        ((AbstractStringAssert)Assertions.assertThat((String)userAgentStr).describedAs("User-Agent string should contain sslProvider", new Object[0])).contains(new CharSequence[]{DelegatingSSLSocketFactory.getDefaultFactory().getProviderName()});
        userAgentStr = this.getUserAgentString(abfsConfiguration, false);
        this.verifybBasicInfo(userAgentStr);
        ((AbstractStringAssert)Assertions.assertThat((String)userAgentStr).describedAs("User-Agent string should not contain sslProvider", new Object[0])).doesNotContain(new CharSequence[]{DelegatingSSLSocketFactory.getDefaultFactory().getProviderName()});
    }

    @Test
    public void verifyUserAgentClusterName() throws Exception {
        String clusterName = "testClusterName";
        Configuration configuration = new Configuration();
        configuration.addResource("azure-test.xml");
        configuration.set("fs.azure.cluster.name", "testClusterName");
        AbfsConfiguration abfsConfiguration = new AbfsConfiguration(configuration, ACCOUNT_NAME);
        String userAgentStr = this.getUserAgentString(abfsConfiguration, false);
        this.verifybBasicInfo(userAgentStr);
        ((AbstractStringAssert)Assertions.assertThat((String)userAgentStr).describedAs("User-Agent string should contain cluster name", new Object[0])).contains(new CharSequence[]{"testClusterName"});
        configuration.unset("fs.azure.cluster.name");
        abfsConfiguration = new AbfsConfiguration(configuration, ACCOUNT_NAME);
        userAgentStr = this.getUserAgentString(abfsConfiguration, false);
        this.verifybBasicInfo(userAgentStr);
        ((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)userAgentStr).describedAs("User-Agent string should not contain cluster name", new Object[0])).doesNotContain(new CharSequence[]{"testClusterName"})).describedAs("User-Agent string should contain UNKNOWN as cluster name config is absent", new Object[0])).contains(new CharSequence[]{"UNKNOWN"});
    }

    @Test
    public void verifyUserAgentClusterType() throws Exception {
        String clusterType = "testClusterType";
        Configuration configuration = new Configuration();
        configuration.addResource("azure-test.xml");
        configuration.set("fs.azure.cluster.type", "testClusterType");
        AbfsConfiguration abfsConfiguration = new AbfsConfiguration(configuration, ACCOUNT_NAME);
        String userAgentStr = this.getUserAgentString(abfsConfiguration, false);
        this.verifybBasicInfo(userAgentStr);
        ((AbstractStringAssert)Assertions.assertThat((String)userAgentStr).describedAs("User-Agent string should contain cluster type", new Object[0])).contains(new CharSequence[]{"testClusterType"});
        configuration.unset("fs.azure.cluster.type");
        abfsConfiguration = new AbfsConfiguration(configuration, ACCOUNT_NAME);
        userAgentStr = this.getUserAgentString(abfsConfiguration, false);
        this.verifybBasicInfo(userAgentStr);
        ((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)userAgentStr).describedAs("User-Agent string should not contain cluster type", new Object[0])).doesNotContain(new CharSequence[]{"testClusterType"})).describedAs("User-Agent string should contain UNKNOWN as cluster type config is absent", new Object[0])).contains(new CharSequence[]{"UNKNOWN"});
    }

    public static AbfsClient createTestClientFromCurrentContext(AbfsClient baseAbfsClientInstance, AbfsConfiguration abfsConfig) throws IOException {
        AuthType currentAuthType = abfsConfig.getAuthType(abfsConfig.getAccountName());
        AbfsPerfTracker tracker = new AbfsPerfTracker("test", abfsConfig.getAccountName(), abfsConfig);
        AbfsClientContext abfsClientContext = new AbfsClientContextBuilder().withAbfsPerfTracker(tracker).withExponentialRetryPolicy(new ExponentialRetryPolicy(abfsConfig.getMaxIoRetries())).build();
        AbfsClient testClient = new AbfsClient(baseAbfsClientInstance.getBaseUrl(), currentAuthType == AuthType.SharedKey ? new SharedKeyCredentials(abfsConfig.getAccountName().substring(0, abfsConfig.getAccountName().indexOf(".")), abfsConfig.getStorageAccountKey()) : null, abfsConfig, currentAuthType == AuthType.OAuth ? abfsConfig.getTokenProvider() : null, abfsClientContext);
        return testClient;
    }

    public static AbfsClient getMockAbfsClient(AbfsClient baseAbfsClientInstance, AbfsConfiguration abfsConfig) throws Exception {
        AuthType currentAuthType = abfsConfig.getAuthType(abfsConfig.getAccountName());
        Assume.assumeTrue((currentAuthType == AuthType.SharedKey || currentAuthType == AuthType.OAuth ? 1 : 0) != 0);
        AbfsClient client = (AbfsClient)Mockito.mock(AbfsClient.class);
        AbfsPerfTracker tracker = new AbfsPerfTracker("test", abfsConfig.getAccountName(), abfsConfig);
        Mockito.when((Object)client.getAbfsPerfTracker()).thenReturn((Object)tracker);
        Mockito.when((Object)client.getAuthType()).thenReturn((Object)currentAuthType);
        Mockito.when((Object)client.getRetryPolicy()).thenReturn((Object)new ExponentialRetryPolicy(1));
        Mockito.when((Object)client.createDefaultUriQueryBuilder()).thenCallRealMethod();
        Mockito.when((Object)client.createRequestUrl((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenCallRealMethod();
        Mockito.when((Object)client.getAccessToken()).thenCallRealMethod();
        Mockito.when((Object)client.getSharedKeyCredentials()).thenCallRealMethod();
        Mockito.when((Object)client.createDefaultHeaders()).thenCallRealMethod();
        Mockito.when((Object)client.getAbfsConfiguration()).thenReturn((Object)abfsConfig);
        Mockito.when((Object)client.getIntercept()).thenReturn((Object)AbfsThrottlingInterceptFactory.getInstance((String)abfsConfig.getAccountName().substring(0, abfsConfig.getAccountName().indexOf(".")), (AbfsConfiguration)abfsConfig));
        client = TestAbfsClient.setAbfsClientField(client, "abfsConfiguration", abfsConfig);
        client = TestAbfsClient.setAbfsClientField(client, "baseUrl", baseAbfsClientInstance.getBaseUrl());
        client = currentAuthType == AuthType.SharedKey ? TestAbfsClient.setAbfsClientField(client, "sharedKeyCredentials", new SharedKeyCredentials(abfsConfig.getAccountName().substring(0, abfsConfig.getAccountName().indexOf(".")), abfsConfig.getStorageAccountKey())) : TestAbfsClient.setAbfsClientField(client, "tokenProvider", abfsConfig.getTokenProvider());
        String userAgent = "APN/1.0 Azure Blob FS/3.4.0-SNAPSHOT (PrivateBuild JavaJRE 1.8.0_252; Linux 5.3.0-59-generic/amd64; openssl-1.0; UNKNOWN/UNKNOWN) MSFT";
        client = TestAbfsClient.setAbfsClientField(client, "userAgent", userAgent);
        return client;
    }

    private static AbfsClient setAbfsClientField(AbfsClient client, String fieldName, Object fieldObject) throws Exception {
        Field field = AbfsClient.class.getDeclaredField(fieldName);
        field.setAccessible(true);
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        field.set(client, fieldObject);
        return client;
    }

    public static URL getTestUrl(AbfsClient client, String path) throws AzureBlobFileSystemException {
        AbfsUriQueryBuilder abfsUriQueryBuilder = client.createDefaultUriQueryBuilder();
        return client.createRequestUrl(path, abfsUriQueryBuilder.toString());
    }

    public static List<AbfsHttpHeader> getTestRequestHeaders(AbfsClient client) {
        return client.createDefaultHeaders();
    }

    public static AbfsRestOperation getRestOp(AbfsRestOperationType type, AbfsClient client, String method, URL url, List<AbfsHttpHeader> requestHeaders) {
        return new AbfsRestOperation(type, client, method, url, requestHeaders);
    }

    public static AccessTokenProvider getAccessTokenProvider(AbfsClient client) {
        return client.getTokenProvider();
    }
}

