/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.extensions;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.URI;
import java.time.Clock;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.Objects;
import java.util.UUID;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenIdentifier;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;

public class StubAbfsTokenIdentifier
extends DelegationTokenIdentifier {
    public static final String ID = "StubAbfsTokenIdentifier";
    public static final int MAX_TEXT_LENGTH = 512;
    public static final Text TOKEN_KIND = new Text("StubAbfsTokenIdentifier");
    private URI uri;
    private long created = System.currentTimeMillis();
    private String uuid = UUID.randomUUID().toString();

    public StubAbfsTokenIdentifier() {
        super(TOKEN_KIND);
    }

    public StubAbfsTokenIdentifier(URI uri, Text owner, Text renewer) {
        super(TOKEN_KIND, owner, renewer, new Text());
        this.uri = uri;
        Clock clock = Clock.systemDefaultZone();
        long now = clock.millis();
        Instant nowTime = Instant.ofEpochMilli(now);
        this.setIssueDate(now);
        this.setMaxDate(nowTime.plus(1L, ChronoUnit.HOURS).toEpochMilli());
    }

    public static StubAbfsTokenIdentifier decodeIdentifier(Token<?> token) throws IOException {
        StubAbfsTokenIdentifier id = (StubAbfsTokenIdentifier)token.decodeIdentifier();
        Preconditions.checkNotNull((Object)((Object)id), (Object)"Null decoded identifier");
        return id;
    }

    public URI getUri() {
        return this.uri;
    }

    public long getCreated() {
        return this.created;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        Text.writeString((DataOutput)out, (String)this.uri.toString());
        Text.writeString((DataOutput)out, (String)this.uuid);
        out.writeLong(this.created);
    }

    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.uri = URI.create(Text.readString((DataInput)in, (int)512));
        this.uuid = Text.readString((DataInput)in, (int)512);
        this.created = in.readLong();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("AbfsIDBTokenIdentifier{");
        sb.append("uri=").append(this.uri);
        sb.append(", uuid='").append(this.uuid).append('\'');
        sb.append(", created='").append(new Date(this.created)).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StubAbfsTokenIdentifier that = (StubAbfsTokenIdentifier)((Object)o);
        return this.created == that.created && this.uri.equals(that.uri) && this.uuid.equals(that.uuid);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.uri, this.uuid);
    }
}

