/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.azurebfs.Abfs;
import org.apache.hadoop.fs.azurebfs.Abfss;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.SecureAzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.services.AuthType;
import org.junit.Test;

public class ITestFileSystemRegistration
extends AbstractAbfsIntegrationTest {
    protected static final String ABFS = "org.apache.hadoop.fs.azurebfs.Abfs";
    protected static final String ABFSS = "org.apache.hadoop.fs.azurebfs.Abfss";

    private void assertConfigMatches(Configuration conf, String key, String expected) {
        String v = conf.get(key);
        ITestFileSystemRegistration.assertNotNull((String)("No value for key " + key), (Object)v);
        ITestFileSystemRegistration.assertEquals((String)("Wrong value for key " + key), (Object)expected, (Object)v);
    }

    @Test
    public void testAbfsFileSystemRegistered() throws Throwable {
        this.assertConfigMatches(new Configuration(true), "fs.abfs.impl", "org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem");
    }

    @Test
    public void testSecureAbfsFileSystemRegistered() throws Throwable {
        this.assertConfigMatches(new Configuration(true), "fs.abfss.impl", "org.apache.hadoop.fs.azurebfs.SecureAzureBlobFileSystem");
    }

    @Test
    public void testAbfsFileContextRegistered() throws Throwable {
        this.assertConfigMatches(new Configuration(true), "fs.AbstractFileSystem.abfs.impl", ABFS);
    }

    @Test
    public void testSecureAbfsFileContextRegistered() throws Throwable {
        this.assertConfigMatches(new Configuration(true), "fs.AbstractFileSystem.abfss.impl", ABFSS);
    }

    @Test
    public void ensureAzureBlobFileSystemIsDefaultFileSystem() throws Exception {
        Configuration rawConfig = this.getRawConfiguration();
        AzureBlobFileSystem fs = (AzureBlobFileSystem)FileSystem.get((Configuration)rawConfig);
        ITestFileSystemRegistration.assertNotNull((String)"filesystem", (Object)fs);
        if (this.getAuthType() == AuthType.OAuth) {
            Abfss afs = (Abfss)FileContext.getFileContext((Configuration)rawConfig).getDefaultFileSystem();
            ITestFileSystemRegistration.assertNotNull((String)"filecontext", (Object)afs);
        } else {
            Abfs afs = (Abfs)FileContext.getFileContext((Configuration)rawConfig).getDefaultFileSystem();
            ITestFileSystemRegistration.assertNotNull((String)"filecontext", (Object)afs);
        }
    }

    @Test
    public void ensureSecureAzureBlobFileSystemIsDefaultFileSystem() throws Exception {
        String accountName = this.getAccountName();
        String fileSystemName = this.getFileSystemName();
        URI defaultUri = new URI("abfss", fileSystemName + "@" + accountName, null, null, null);
        Configuration rawConfig = this.getRawConfiguration();
        rawConfig.set("fs.defaultFS", defaultUri.toString());
        SecureAzureBlobFileSystem fs = (SecureAzureBlobFileSystem)FileSystem.get((Configuration)rawConfig);
        ITestFileSystemRegistration.assertNotNull((String)"filesystem", (Object)fs);
        Abfss afs = (Abfss)FileContext.getFileContext((Configuration)rawConfig).getDefaultFileSystem();
        ITestFileSystemRegistration.assertNotNull((String)"filecontext", (Object)afs);
    }
}

