/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.lang.ref.WeakReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsScaleTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.junit.Assert;
import org.junit.Test;

public class ITestAzureBlobFileSystemFinalize
extends AbstractAbfsScaleTest {
    static final String DISABLE_ABFS_CACHE_KEY = "fs.abfs.impl.disable.cache";
    static final String DISABLE_ABFSS_CACHE_KEY = "fs.abfss.impl.disable.cache";

    @Test
    public void testFinalize() throws Exception {
        Configuration rawConfig = this.getRawConfiguration();
        rawConfig.setBoolean(DISABLE_ABFS_CACHE_KEY, true);
        rawConfig.setBoolean(DISABLE_ABFSS_CACHE_KEY, true);
        AzureBlobFileSystem fs = (AzureBlobFileSystem)FileSystem.get((Configuration)rawConfig);
        WeakReference<AzureBlobFileSystem> ref = new WeakReference<AzureBlobFileSystem>(fs);
        fs = null;
        int maxTries = 1000;
        for (int i = 0; ref.get() != null && i < maxTries; ++i) {
            System.gc();
            System.runFinalization();
        }
        Assert.assertTrue((String)"testFinalizer didn't get cleaned up within maxTries", (ref.get() == null ? 1 : 0) != 0);
    }
}

