/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbfsStatistic;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.services.AbfsOutputStream;
import org.apache.hadoop.fs.azurebfs.services.AbfsOutputStreamStatisticsImpl;
import org.apache.hadoop.fs.statistics.IOStatisticAssertions;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.IOStatisticsLogging;
import org.assertj.core.api.AbstractDoubleAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ITestAbfsOutputStreamStatistics
extends AbstractAbfsIntegrationTest {
    private static final int OPERATIONS = 10;
    private static final Logger LOG = LoggerFactory.getLogger(ITestAbfsOutputStreamStatistics.class);

    @Test
    public void testAbfsOutputStreamUploadingBytes() throws IOException {
        this.describe("Testing bytes uploaded successfully by AbfsOutputSteam", new Object[0]);
        AzureBlobFileSystem fs = this.getFileSystem();
        Path uploadBytesFilePath = this.path(this.getMethodName());
        String testBytesToUpload = "bytes";
        try (AbfsOutputStream outForSomeBytes = this.createAbfsOutputStreamWithFlushEnabled(fs, uploadBytesFilePath);){
            AbfsOutputStreamStatisticsImpl abfsOutputStreamStatisticsForUploadBytes = ITestAbfsOutputStreamStatistics.getAbfsOutputStreamStatistics(outForSomeBytes);
            ITestAbfsOutputStreamStatistics.assertEquals((String)"Mismatch in bytes to upload", (long)0L, (long)abfsOutputStreamStatisticsForUploadBytes.getBytesToUpload());
            outForSomeBytes.write(testBytesToUpload.getBytes());
            outForSomeBytes.flush();
            abfsOutputStreamStatisticsForUploadBytes = ITestAbfsOutputStreamStatistics.getAbfsOutputStreamStatistics(outForSomeBytes);
            ITestAbfsOutputStreamStatistics.assertEquals((String)"Mismatch in bytes to upload", (long)testBytesToUpload.getBytes().length, (long)abfsOutputStreamStatisticsForUploadBytes.getBytesToUpload());
            ITestAbfsOutputStreamStatistics.assertEquals((String)"Mismatch in successful bytes uploaded", (long)testBytesToUpload.getBytes().length, (long)abfsOutputStreamStatisticsForUploadBytes.getBytesUploadSuccessful());
        }
        try (AbfsOutputStream outForLargeBytes = this.createAbfsOutputStreamWithFlushEnabled(fs, uploadBytesFilePath);){
            for (int i = 0; i < 10; ++i) {
                outForLargeBytes.write(testBytesToUpload.getBytes());
            }
            outForLargeBytes.flush();
            AbfsOutputStreamStatisticsImpl abfsOutputStreamStatistics = ITestAbfsOutputStreamStatistics.getAbfsOutputStreamStatistics(outForLargeBytes);
            ITestAbfsOutputStreamStatistics.assertEquals((String)"Mismatch in bytes to upload", (long)(10 * testBytesToUpload.getBytes().length), (long)abfsOutputStreamStatistics.getBytesToUpload());
            ITestAbfsOutputStreamStatistics.assertEquals((String)"Mismatch in successful bytes uploaded", (long)(10 * testBytesToUpload.getBytes().length), (long)abfsOutputStreamStatistics.getBytesUploadSuccessful());
        }
    }

    @Test
    public void testAbfsOutputStreamQueueShrink() throws IOException {
        this.describe("Testing queue shrink operations by AbfsOutputStream", new Object[0]);
        AzureBlobFileSystem fs = this.getFileSystem();
        Path queueShrinkFilePath = this.path(this.getMethodName());
        String testQueueShrink = "testQueue";
        if (fs.getAbfsStore().isAppendBlobKey(fs.makeQualified(queueShrinkFilePath).toString())) {
            return;
        }
        try (AbfsOutputStream outForOneOp = this.createAbfsOutputStreamWithFlushEnabled(fs, queueShrinkFilePath);){
            AbfsOutputStreamStatisticsImpl abfsOutputStreamStatistics = ITestAbfsOutputStreamStatistics.getAbfsOutputStreamStatistics(outForOneOp);
            ITestAbfsOutputStreamStatistics.assertEquals((String)"Mismatch in queue shrunk operations", (long)0L, (long)abfsOutputStreamStatistics.getQueueShrunkOps());
        }
        try (AbfsOutputStream outForLargeOps = this.createAbfsOutputStreamWithFlushEnabled(fs, queueShrinkFilePath);){
            for (int i = 0; i < 10; ++i) {
                outForLargeOps.write(testQueueShrink.getBytes());
                outForLargeOps.flush();
            }
            AbfsOutputStreamStatisticsImpl abfsOutputStreamStatistics = ITestAbfsOutputStreamStatistics.getAbfsOutputStreamStatistics(outForLargeOps);
            ITestAbfsOutputStreamStatistics.assertEquals((String)"Mismatch in queue shrunk operations", (long)(10 - outForLargeOps.getWriteOperationsSize()), (long)abfsOutputStreamStatistics.getQueueShrunkOps());
        }
    }

    @Test
    public void testAbfsOutputStreamWriteBuffer() throws IOException {
        this.describe("Testing write current buffer operations by AbfsOutputStream", new Object[0]);
        AzureBlobFileSystem fs = this.getFileSystem();
        Path writeBufferFilePath = this.path(this.getMethodName());
        String testWriteBuffer = "Buffer";
        try (AbfsOutputStream outForOneOp = this.createAbfsOutputStreamWithFlushEnabled(fs, writeBufferFilePath);){
            AbfsOutputStreamStatisticsImpl abfsOutputStreamStatistics = ITestAbfsOutputStreamStatistics.getAbfsOutputStreamStatistics(outForOneOp);
            ITestAbfsOutputStreamStatistics.assertEquals((String)"Mismatch in write current buffer operations", (long)0L, (long)abfsOutputStreamStatistics.getWriteCurrentBufferOperations());
            outForOneOp.write(testWriteBuffer.getBytes());
            outForOneOp.flush();
            abfsOutputStreamStatistics = ITestAbfsOutputStreamStatistics.getAbfsOutputStreamStatistics(outForOneOp);
            ITestAbfsOutputStreamStatistics.assertEquals((String)"Mismatch in write current buffer operations", (long)1L, (long)abfsOutputStreamStatistics.getWriteCurrentBufferOperations());
        }
        try (AbfsOutputStream outForLargeOps = this.createAbfsOutputStreamWithFlushEnabled(fs, writeBufferFilePath);){
            for (int i = 0; i < 10; ++i) {
                outForLargeOps.write(testWriteBuffer.getBytes());
                outForLargeOps.flush();
            }
            AbfsOutputStreamStatisticsImpl abfsOutputStreamStatistics = ITestAbfsOutputStreamStatistics.getAbfsOutputStreamStatistics(outForLargeOps);
            ITestAbfsOutputStreamStatistics.assertEquals((String)"Mismatch in write current buffer operations", (long)10L, (long)abfsOutputStreamStatistics.getWriteCurrentBufferOperations());
        }
    }

    @Test
    public void testAbfsOutputStreamDurationTrackerPutRequest() throws IOException {
        this.describe("Testing to check if DurationTracker for PUT request is working correctly.", new Object[0]);
        AzureBlobFileSystem fs = this.getFileSystem();
        Path pathForPutRequest = this.path(this.getMethodName());
        try (AbfsOutputStream outputStream = this.createAbfsOutputStreamWithFlushEnabled(fs, pathForPutRequest);){
            outputStream.write(97);
            outputStream.hflush();
            IOStatistics ioStatistics = IOStatisticAssertions.extractStatistics((Object)fs);
            LOG.info("AbfsOutputStreamStats info: {}", (Object)IOStatisticsLogging.ioStatisticsToPrettyString((IOStatistics)ioStatistics));
            ((AbstractDoubleAssert)Assertions.assertThat((double)IOStatisticAssertions.lookupMeanStatistic((IOStatistics)ioStatistics, (String)(AbfsStatistic.HTTP_PUT_REQUEST.getStatName() + ".mean")).mean()).describedAs("Mismatch in timeSpentOnPutRequest DurationTracker", new Object[0])).isGreaterThan(0.0);
        }
    }

    private static AbfsOutputStreamStatisticsImpl getAbfsOutputStreamStatistics(AbfsOutputStream out) {
        return (AbfsOutputStreamStatisticsImpl)out.getOutputStreamStatistics();
    }
}

