/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsScaleTest;
import org.apache.hadoop.fs.azurebfs.oauth2.IdentityTransformer;
import org.apache.hadoop.fs.azurebfs.utils.AclTestHelpers;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.thirdparty.com.google.common.collect.Lists;
import org.junit.Test;

public class ITestAbfsIdentityTransformer
extends AbstractAbfsScaleTest {
    private final UserGroupInformation userGroupInfo = UserGroupInformation.getCurrentUser();
    private final String localUser = this.userGroupInfo.getShortUserName();
    private final String localGroup = this.userGroupInfo.getPrimaryGroupName();
    private static final String DAEMON = "daemon";
    private static final String ASTERISK = "*";
    private static final String SHORT_NAME = "abc";
    private static final String DOMAIN = "domain.com";
    private static final String FULLY_QUALIFIED_NAME = "abc@domain.com";
    private static final String SERVICE_PRINCIPAL_ID = UUID.randomUUID().toString();

    @Test
    public void testDaemonServiceSettingIdentity() throws IOException {
        Configuration config = this.getRawConfiguration();
        this.resetIdentityConfig(config);
        IdentityTransformer identityTransformer = this.getTransformerWithDefaultIdentityConfig(config);
        ITestAbfsIdentityTransformer.assertEquals((String)"Identity should not change for default config", (Object)DAEMON, (Object)identityTransformer.transformUserOrGroupForSetRequest(DAEMON));
        config.set("fs.azure.identity.transformer.service.principal.id", SERVICE_PRINCIPAL_ID);
        config.set("fs.azure.identity.transformer.service.principal.substitution.list", "a,b,c,d");
        identityTransformer = this.getTransformerWithCustomizedIdentityConfig(config);
        ITestAbfsIdentityTransformer.assertEquals((String)"Identity should not change when substitution list doesn't contain daemon", (Object)DAEMON, (Object)identityTransformer.transformUserOrGroupForSetRequest(DAEMON));
        config.set("fs.azure.identity.transformer.service.principal.substitution.list", "daemon,a,b,c,d");
        identityTransformer = this.getTransformerWithCustomizedIdentityConfig(config);
        ITestAbfsIdentityTransformer.assertEquals((String)"Identity should be replaced to servicePrincipalId", (Object)SERVICE_PRINCIPAL_ID, (Object)identityTransformer.transformUserOrGroupForSetRequest(DAEMON));
        config.set("fs.azure.identity.transformer.service.principal.substitution.list", ASTERISK);
        identityTransformer = this.getTransformerWithCustomizedIdentityConfig(config);
        ITestAbfsIdentityTransformer.assertEquals((String)"Identity should be replaced to servicePrincipalId", (Object)SERVICE_PRINCIPAL_ID, (Object)identityTransformer.transformUserOrGroupForSetRequest(DAEMON));
    }

    @Test
    public void testFullyQualifiedNameSettingIdentity() throws IOException {
        Configuration config = this.getRawConfiguration();
        IdentityTransformer identityTransformer = this.getTransformerWithDefaultIdentityConfig(config);
        ITestAbfsIdentityTransformer.assertEquals((String)"short name should not be converted to full name by default", (Object)SHORT_NAME, (Object)identityTransformer.transformUserOrGroupForSetRequest(SHORT_NAME));
        this.resetIdentityConfig(config);
        config.setBoolean("fs.azure.identity.transformer.enable.short.name", true);
        config.set("fs.azure.identity.transformer.domain.name", DOMAIN);
        identityTransformer = this.getTransformerWithCustomizedIdentityConfig(config);
        ITestAbfsIdentityTransformer.assertEquals((String)"short name should be converted to full name", (Object)FULLY_QUALIFIED_NAME, (Object)identityTransformer.transformUserOrGroupForSetRequest(SHORT_NAME));
    }

    @Test
    public void testNoOpForSettingOidAsIdentity() throws IOException {
        Configuration config = this.getRawConfiguration();
        this.resetIdentityConfig(config);
        config.setBoolean("fs.azure.identity.transformer.enable.short.name", true);
        config.set("fs.azure.identity.transformer.domain.name", DOMAIN);
        config.set("fs.azure.identity.transformer.service.principal.id", UUID.randomUUID().toString());
        config.set("fs.azure.identity.transformer.service.principal.substitution.list", "a,b,c,d");
        IdentityTransformer identityTransformer = this.getTransformerWithCustomizedIdentityConfig(config);
        String principalId = UUID.randomUUID().toString();
        ITestAbfsIdentityTransformer.assertEquals((String)"Identity should not be changed when owner is already a principal id ", (Object)principalId, (Object)identityTransformer.transformUserOrGroupForSetRequest(principalId));
    }

    @Test
    public void testNoOpWhenSettingSuperUserAsdentity() throws IOException {
        Configuration config = this.getRawConfiguration();
        this.resetIdentityConfig(config);
        config.setBoolean("fs.azure.identity.transformer.enable.short.name", true);
        config.set("fs.azure.identity.transformer.domain.name", DOMAIN);
        IdentityTransformer identityTransformer = this.getTransformerWithDefaultIdentityConfig(config);
        ITestAbfsIdentityTransformer.assertEquals((String)"Identity should not be changed because it is not in substitution list", (Object)"$superuser", (Object)identityTransformer.transformUserOrGroupForSetRequest("$superuser"));
    }

    @Test
    public void testIdentityReplacementForSuperUserGetRequest() throws IOException {
        Configuration config = this.getRawConfiguration();
        this.resetIdentityConfig(config);
        IdentityTransformer identityTransformer = this.getTransformerWithDefaultIdentityConfig(config);
        ITestAbfsIdentityTransformer.assertEquals((String)"$superuser should be replaced with local user by default", (Object)this.localUser, (Object)identityTransformer.transformIdentityForGetRequest("$superuser", true, this.localUser));
        config.setBoolean("fs.azure.identity.transformer.skip.superuser.replacement", true);
        identityTransformer = this.getTransformerWithCustomizedIdentityConfig(config);
        ITestAbfsIdentityTransformer.assertEquals((String)"$superuser should not be replaced", (Object)"$superuser", (Object)identityTransformer.transformIdentityForGetRequest("$superuser", true, this.localUser));
    }

    @Test
    public void testIdentityReplacementForDaemonServiceGetRequest() throws IOException {
        Configuration config = this.getRawConfiguration();
        this.resetIdentityConfig(config);
        IdentityTransformer identityTransformer = this.getTransformerWithDefaultIdentityConfig(config);
        ITestAbfsIdentityTransformer.assertEquals((String)"By default servicePrincipalId should not be converted for GetFileStatus(), listFileStatus(), getAcl()", (Object)SERVICE_PRINCIPAL_ID, (Object)identityTransformer.transformIdentityForGetRequest(SERVICE_PRINCIPAL_ID, true, this.localUser));
        this.resetIdentityConfig(config);
        config.set("fs.azure.identity.transformer.service.principal.substitution.list", "a,b,c,d");
        identityTransformer = this.getTransformerWithCustomizedIdentityConfig(config);
        ITestAbfsIdentityTransformer.assertEquals((String)"servicePrincipalId should not be replaced if local daemon user is not in substitution list", (Object)SERVICE_PRINCIPAL_ID, (Object)identityTransformer.transformIdentityForGetRequest(SERVICE_PRINCIPAL_ID, true, this.localUser));
        this.resetIdentityConfig(config);
        config.set("fs.azure.identity.transformer.service.principal.substitution.list", this.localUser + ",a,b,c,d");
        config.set("fs.azure.identity.transformer.service.principal.id", UUID.randomUUID().toString());
        identityTransformer = this.getTransformerWithCustomizedIdentityConfig(config);
        ITestAbfsIdentityTransformer.assertEquals((String)"servicePrincipalId should not be replaced if it is not equal to the SPN set in config", (Object)SERVICE_PRINCIPAL_ID, (Object)identityTransformer.transformIdentityForGetRequest(SERVICE_PRINCIPAL_ID, true, this.localUser));
        this.resetIdentityConfig(config);
        config.set("fs.azure.identity.transformer.service.principal.substitution.list", this.localUser + ",a,b,c,d");
        config.set("fs.azure.identity.transformer.service.principal.id", SERVICE_PRINCIPAL_ID);
        identityTransformer = this.getTransformerWithCustomizedIdentityConfig(config);
        ITestAbfsIdentityTransformer.assertEquals((String)"servicePrincipalId should be transformed to local use", (Object)this.localUser, (Object)identityTransformer.transformIdentityForGetRequest(SERVICE_PRINCIPAL_ID, true, this.localUser));
        this.resetIdentityConfig(config);
        config.set("fs.azure.identity.transformer.service.principal.substitution.list", ASTERISK);
        config.set("fs.azure.identity.transformer.service.principal.id", UUID.randomUUID().toString());
        identityTransformer = this.getTransformerWithCustomizedIdentityConfig(config);
        ITestAbfsIdentityTransformer.assertEquals((String)"servicePrincipalId should not be replaced if it is not equal to the SPN set in config", (Object)SERVICE_PRINCIPAL_ID, (Object)identityTransformer.transformIdentityForGetRequest(SERVICE_PRINCIPAL_ID, true, this.localUser));
        this.resetIdentityConfig(config);
        config.set("fs.azure.identity.transformer.service.principal.substitution.list", ASTERISK);
        config.set("fs.azure.identity.transformer.service.principal.id", SERVICE_PRINCIPAL_ID);
        identityTransformer = this.getTransformerWithCustomizedIdentityConfig(config);
        ITestAbfsIdentityTransformer.assertEquals((String)"servicePrincipalId should be transformed to local user", (Object)this.localUser, (Object)identityTransformer.transformIdentityForGetRequest(SERVICE_PRINCIPAL_ID, true, this.localUser));
    }

    @Test
    public void testIdentityReplacementForKinitUserGetRequest() throws IOException {
        Configuration config = this.getRawConfiguration();
        this.resetIdentityConfig(config);
        IdentityTransformer identityTransformer = this.getTransformerWithDefaultIdentityConfig(config);
        ITestAbfsIdentityTransformer.assertEquals((String)"full name should not be transformed if shortname is not enabled", (Object)FULLY_QUALIFIED_NAME, (Object)identityTransformer.transformIdentityForGetRequest(FULLY_QUALIFIED_NAME, true, this.localUser));
        config.setBoolean("fs.azure.identity.transformer.enable.short.name", true);
        identityTransformer = this.getTransformerWithCustomizedIdentityConfig(config);
        ITestAbfsIdentityTransformer.assertEquals((String)"should convert the full owner name to shortname ", (Object)SHORT_NAME, (Object)identityTransformer.transformIdentityForGetRequest(FULLY_QUALIFIED_NAME, true, this.localUser));
        ITestAbfsIdentityTransformer.assertEquals((String)"group name should not be converted to shortname ", (Object)FULLY_QUALIFIED_NAME, (Object)identityTransformer.transformIdentityForGetRequest(FULLY_QUALIFIED_NAME, false, this.localGroup));
    }

    @Test
    public void transformAclEntriesForSetRequest() throws IOException {
        Configuration config = this.getRawConfiguration();
        this.resetIdentityConfig(config);
        ArrayList aclEntriesToBeTransformed = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, DAEMON, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FULLY_QUALIFIED_NAME, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "$superuser", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, SERVICE_PRINCIPAL_ID, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, SHORT_NAME, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, DAEMON, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, SHORT_NAME, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.ALL)});
        ArrayList aclEntries = Lists.newArrayList((Iterable)aclEntriesToBeTransformed);
        IdentityTransformer identityTransformer = this.getTransformerWithDefaultIdentityConfig(config);
        identityTransformer.transformAclEntriesForSetRequest((List)aclEntries);
        this.checkAclEntriesList(aclEntriesToBeTransformed, aclEntries);
        this.resetIdentityConfig(config);
        config.set("fs.azure.identity.transformer.service.principal.substitution.list", "daemon,a,b,c,d");
        config.setBoolean("fs.azure.identity.transformer.enable.short.name", true);
        config.set("fs.azure.identity.transformer.domain.name", DOMAIN);
        config.set("fs.azure.identity.transformer.service.principal.id", SERVICE_PRINCIPAL_ID);
        identityTransformer = this.getTransformerWithCustomizedIdentityConfig(config);
        identityTransformer.transformAclEntriesForSetRequest((List)aclEntries);
        ArrayList expectedAclEntries = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, SERVICE_PRINCIPAL_ID, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FULLY_QUALIFIED_NAME, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "$superuser", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, SERVICE_PRINCIPAL_ID, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FULLY_QUALIFIED_NAME, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, SERVICE_PRINCIPAL_ID, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, SHORT_NAME, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.ALL)});
        this.checkAclEntriesList(aclEntries, expectedAclEntries);
    }

    @Test
    public void transformAclEntriesForGetRequest() throws IOException {
        Configuration config = this.getRawConfiguration();
        this.resetIdentityConfig(config);
        ArrayList aclEntriesToBeTransformed = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FULLY_QUALIFIED_NAME, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "$superuser", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, SERVICE_PRINCIPAL_ID, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, SHORT_NAME, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, SHORT_NAME, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.ALL)});
        ArrayList aclEntries = Lists.newArrayList((Iterable)aclEntriesToBeTransformed);
        IdentityTransformer identityTransformer = this.getTransformerWithDefaultIdentityConfig(config);
        identityTransformer.transformAclEntriesForGetRequest((List)aclEntries, this.localUser, this.localGroup);
        this.checkAclEntriesList(aclEntriesToBeTransformed, aclEntries);
        this.resetIdentityConfig(config);
        config.set("fs.azure.identity.transformer.service.principal.substitution.list", this.localUser + ",a,b,c,d");
        config.setBoolean("fs.azure.identity.transformer.enable.short.name", true);
        config.set("fs.azure.identity.transformer.domain.name", DOMAIN);
        config.set("fs.azure.identity.transformer.service.principal.id", SERVICE_PRINCIPAL_ID);
        identityTransformer = this.getTransformerWithCustomizedIdentityConfig(config);
        aclEntries = Lists.newArrayList((Iterable)aclEntriesToBeTransformed);
        identityTransformer.transformAclEntriesForGetRequest((List)aclEntries, this.localUser, this.localGroup);
        ArrayList expectedAclEntries = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, SHORT_NAME, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, this.localUser, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, this.localUser, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, SHORT_NAME, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, SHORT_NAME, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.ALL)});
        this.checkAclEntriesList(aclEntries, expectedAclEntries);
    }

    private void resetIdentityConfig(Configuration config) {
        config.unset("fs.azure.identity.transformer.enable.short.name");
        config.unset("fs.azure.identity.transformer.domain.name");
        config.unset("fs.azure.identity.transformer.service.principal.id");
        config.unset("fs.azure.identity.transformer.service.principal.substitution.list");
        config.unset("fs.azure.identity.transformer.skip.superuser.replacement");
    }

    private IdentityTransformer getTransformerWithDefaultIdentityConfig(Configuration config) throws IOException {
        this.resetIdentityConfig(config);
        return new IdentityTransformer(config);
    }

    private IdentityTransformer getTransformerWithCustomizedIdentityConfig(Configuration config) throws IOException {
        return new IdentityTransformer(config);
    }

    private void checkAclEntriesList(List<AclEntry> aclEntries, List<AclEntry> expected) {
        ITestAbfsIdentityTransformer.assertTrue((String)"list size not equals", (aclEntries.size() == expected.size() ? 1 : 0) != 0);
        for (int i = 0; i < aclEntries.size(); ++i) {
            ITestAbfsIdentityTransformer.assertEquals((String)"Identity doesn't match", (Object)expected.get(i).getName(), (Object)aclEntries.get(i).getName());
        }
    }
}

