/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azure.integration.AzureTestUtils;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsScaleTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ITestAbfsHugeFiles
extends AbstractAbfsScaleTest {
    private static final int ONE_MB = 0x100000;
    private static final int EIGHT_MB = 0x800000;
    private static final int HUGE_FILE = AzureTestUtils.getTestPropertyInt(new Configuration(), "fs.azure.scale.test.huge.upload", 0x1000000);
    private int size;
    private String blockFactoryName;

    @Parameterized.Parameters(name="size [{0}] ; blockFactoryName [{1}]")
    public static Collection<Object[]> sizes() {
        return Arrays.asList({0x800000, "disk"}, {HUGE_FILE, "disk"}, {0x800000, "array"}, {HUGE_FILE, "array"}, {0x800000, "bytebuffer"}, {HUGE_FILE, "bytebuffer"});
    }

    public ITestAbfsHugeFiles(int size, String blockFactoryName) throws Exception {
        this.size = size;
        this.blockFactoryName = blockFactoryName;
    }

    @Before
    public void setUp() throws Exception {
        Configuration configuration = this.getRawConfiguration();
        configuration.unset("fs.azure.data.blocks.buffer");
        configuration.set("fs.azure.data.blocks.buffer", this.blockFactoryName);
        super.setup();
    }

    @Test
    public void testHugeFileWrite() throws IOException {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path filePath = this.path(this.getMethodName());
        byte[] b = new byte[this.size];
        new Random().nextBytes(b);
        try (FSDataOutputStream out = fs.create(filePath);){
            out.write(b);
        }
        ITestAbfsHugeFiles.assertEquals((String)"Mismatch in content length of file uploaded", (long)this.size, (long)fs.getFileStatus(filePath).getLen());
    }

    @Test
    public void testLotsOfWrites() throws IOException {
        AzureTestUtils.assume("If the size isn't a multiple of 8M this test would not pass, so skip", this.size % 0x800000 == 0);
        AzureBlobFileSystem fs = this.getFileSystem();
        Path filePath = this.path(this.getMethodName());
        byte[] b = new byte[this.size];
        new Random().nextBytes(b);
        try (FSDataOutputStream out = fs.create(filePath);){
            int offset = 0;
            for (int i = 0; i < this.size / 0x800000; ++i) {
                out.write(b, offset, 0x800000);
                offset += 0x800000;
            }
        }
        ITestAbfsHugeFiles.assertEquals((String)"Mismatch in content length of file uploaded", (long)this.size, (long)fs.getFileStatus(filePath).getLen());
    }
}

