/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import java.io.IOException;
import java.util.Arrays;
import java.util.Random;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azure.AzureException;
import org.apache.hadoop.fs.azure.AzureNativeFileSystemStore;
import org.apache.hadoop.fs.azure.NativeAzureFileSystem;
import org.apache.hadoop.fs.azure.integration.AbstractAzureScaleTest;
import org.apache.hadoop.fs.azure.integration.AzureTestUtils;
import org.apache.hadoop.util.Time;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ITestReadAndSeekPageBlobAfterWrite
extends AbstractAzureScaleTest {
    private static final Logger LOG = LoggerFactory.getLogger(ITestReadAndSeekPageBlobAfterWrite.class);
    private FileSystem fs;
    private byte[] randomData;
    private static final int PAGE_SIZE = 512;
    private static final int PAGE_DATA_SIZE = 510;
    private static final int MAX_BYTES = 0x2000000;
    private static final int MAX_PAGES = 65536;
    private Random rand = new Random();
    private static final String KEY = "/pageBlobs/file.dat";
    private Path blobPath;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.fs = this.getTestAccount().getFileSystem();
        ITestReadAndSeekPageBlobAfterWrite.assertEquals((long)0L, (long)0L);
        this.randomData = new byte[0x2000000];
        this.rand.nextBytes(this.randomData);
        this.blobPath = this.blobPath("ITestReadAndSeekPageBlobAfterWrite");
    }

    @Override
    public void tearDown() throws Exception {
        AzureTestUtils.deleteQuietly(this.fs, this.blobPath, true);
        super.tearDown();
    }

    @Test
    public void testIsPageBlobFileName() {
        AzureNativeFileSystemStore store = ((NativeAzureFileSystem)this.fs).getStore();
        String[] a = this.blobPath.toUri().getPath().split("/");
        String key2 = a[1] + "/";
        ITestReadAndSeekPageBlobAfterWrite.assertTrue((String)("Not a page blob: " + this.blobPath), (boolean)store.isPageBlobKey(key2));
    }

    @Test
    public void testReadAfterWriteRandomData() throws IOException {
        int[] dataSizes;
        int pds = 510;
        for (int i : dataSizes = new int[]{0, 1, 2, 3, 509, 510, 511, 512, 513, 1019, 1020, 1021, 1022, 1023, 5099, 5100, 5101, 5102, 5103, 0x2000000}) {
            this.testReadAfterWriteRandomData(i);
        }
    }

    private void testReadAfterWriteRandomData(int size) throws IOException {
        this.writeRandomData(size);
        this.readRandomDataAndVerify(size);
    }

    private void readRandomDataAndVerify(int size) throws AzureException, IOException {
        byte[] b = new byte[size];
        FSDataInputStream stream = this.fs.open(this.blobPath);
        int bytesRead = stream.read(b);
        stream.close();
        ITestReadAndSeekPageBlobAfterWrite.assertEquals((long)bytesRead, (long)size);
        ITestReadAndSeekPageBlobAfterWrite.assertTrue((boolean)this.comparePrefix(this.randomData, b, size));
    }

    private boolean comparePrefix(byte[] a, byte[] b, int size) {
        if (a.length < size || b.length < size) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    private void writeRandomData(int size) throws IOException {
        FSDataOutputStream output = this.fs.create(this.blobPath);
        output.write(this.randomData, 0, size);
        output.close();
    }

    @Test
    public void testPageBlobSeekAndReadAfterWrite() throws IOException {
        this.writeRandomData(0x2000000);
        int recordSize = 100;
        byte[] b = new byte[recordSize];
        try (FSDataInputStream stream = this.fs.open(this.blobPath);){
            int seekPosition = 2810;
            stream.seek((long)seekPosition);
            int bytesRead = stream.read(b);
            this.verifyReadRandomData(b, bytesRead, seekPosition, recordSize);
            seekPosition = 5370;
            stream.seek((long)seekPosition);
            recordSize = 1000;
            b = new byte[recordSize];
            bytesRead = stream.read(b);
            this.verifyReadRandomData(b, bytesRead, seekPosition, recordSize);
            recordSize = 100;
            seekPosition = 0x2000000 - recordSize;
            stream.seek((long)seekPosition);
            b = new byte[recordSize];
            bytesRead = stream.read(b);
            this.verifyReadRandomData(b, bytesRead, seekPosition, recordSize);
            recordSize = 100;
            seekPosition = 0x2000000 - recordSize + 50;
            stream.seek((long)seekPosition);
            b = new byte[recordSize];
            bytesRead = stream.read(b);
            ITestReadAndSeekPageBlobAfterWrite.assertEquals((long)50L, (long)bytesRead);
            byte[] tail = Arrays.copyOfRange(this.randomData, seekPosition, this.randomData.length);
            ITestReadAndSeekPageBlobAfterWrite.assertTrue((boolean)this.comparePrefix(tail, b, 50));
        }
    }

    private void verifyReadRandomData(byte[] b, int bytesRead, int seekPosition, int recordSize) {
        byte[] originalRecordData = Arrays.copyOfRange(this.randomData, seekPosition, seekPosition + recordSize + 1);
        ITestReadAndSeekPageBlobAfterWrite.assertEquals((long)recordSize, (long)bytesRead);
        ITestReadAndSeekPageBlobAfterWrite.assertTrue((boolean)this.comparePrefix(originalRecordData, b, recordSize));
    }

    @Test
    public void testManySmallWritesWithHFlush() throws IOException {
        this.writeAndReadOneFile(50, 100, 20);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeAndReadOneFile(int numWrites, int recordLength, int syncInterval) throws IOException {
        long MINIMUM_EXPECTED_TIME = 20L;
        LOG.info("Writing " + numWrites * recordLength + " bytes to " + this.blobPath.getName());
        FSDataOutputStream output = this.fs.create(this.blobPath);
        int writesSinceHFlush = 0;
        try {
            output.flush();
            output.hflush();
            for (int i = 0; i < numWrites; ++i) {
                output.write(this.randomData, i * recordLength, recordLength);
                ++writesSinceHFlush;
                output.flush();
                if (i % syncInterval != 0) continue;
                output.hflush();
                writesSinceHFlush = 0;
            }
        }
        catch (Throwable throwable) {
            long start = Time.monotonicNow();
            output.close();
            long end = Time.monotonicNow();
            LOG.debug("close duration = " + (end - start) + " msec.");
            if (writesSinceHFlush > 0) {
                ITestReadAndSeekPageBlobAfterWrite.assertTrue((String)String.format("close duration with >= 1 pending write is %d, less than minimum expected of %d", end - start, 20L), (end - start >= 20L ? 1 : 0) != 0);
            }
            throw throwable;
        }
        long start = Time.monotonicNow();
        output.close();
        long end = Time.monotonicNow();
        LOG.debug("close duration = " + (end - start) + " msec.");
        if (writesSinceHFlush > 0) {
            ITestReadAndSeekPageBlobAfterWrite.assertTrue((String)String.format("close duration with >= 1 pending write is %d, less than minimum expected of %d", end - start, 20L), (end - start >= 20L ? 1 : 0) != 0);
        }
        FSDataInputStream stream = this.fs.open(this.blobPath);
        int SIZE = numWrites * recordLength;
        byte[] b = new byte[SIZE];
        try {
            stream.seek(0L);
            stream.read(b, 0, SIZE);
            this.verifyReadRandomData(b, SIZE, 0, SIZE);
        }
        finally {
            stream.close();
        }
        this.fs.delete(this.blobPath, false);
    }

    @Test
    public void testLargeFileStress() throws IOException {
        int numWrites = 32;
        int recordSize = 0x100000;
        int syncInterval = 10;
        int repetitions = 1;
        for (int i = 0; i < repetitions; ++i) {
            this.writeAndReadOneFile(numWrites, recordSize, syncInterval);
        }
    }

    public void testFileSizeExtension() throws IOException {
        int writeSize = 0x100000;
        int numWrites = 129;
        int dataByte = 5;
        byte[] data = new byte[0x100000];
        Arrays.fill(data, (byte)5);
        try (FSDataOutputStream output = this.fs.create(this.blobPath);){
            for (int i = 0; i < 129; ++i) {
                output.write(data);
                output.hflush();
                LOG.debug("total writes = " + (i + 1));
            }
        }
        ITestReadAndSeekPageBlobAfterWrite.assertTrue((boolean)true);
        FileStatus[] status = this.fs.listStatus(this.blobPath);
        ITestReadAndSeekPageBlobAfterWrite.assertEquals((String)("File size hasn't changed " + status), (long)0x8100000L, (long)status[0].getLen());
        LOG.debug("Total bytes written to " + this.blobPath + " = " + status[0].getLen());
        this.fs.delete(this.blobPath, false);
    }
}

