/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import com.microsoft.azure.storage.CloudStorageAccount;
import java.net.URI;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.azure.AbstractWasbTestWithTimeout;
import org.apache.hadoop.fs.azure.AzureBlobStorageTestAccount;
import org.apache.hadoop.fs.azure.AzureException;
import org.apache.hadoop.fs.azure.NativeAzureFileSystem;
import org.apache.hadoop.fs.azure.integration.AzureTestUtils;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Test;

public class ITestFileSystemOperationExceptionMessage
extends AbstractWasbTestWithTimeout {
    @Test
    public void testAnonymouseCredentialExceptionMessage() throws Throwable {
        Configuration conf = AzureBlobStorageTestAccount.createTestConfiguration();
        CloudStorageAccount account = AzureBlobStorageTestAccount.createTestAccount(conf);
        AzureTestUtils.assume("No test account", account != null);
        String testStorageAccount = AzureTestUtils.verifyWasbAccountNameInConfig(conf);
        conf = new Configuration();
        conf.set("fs.AbstractFileSystem.wasb.impl", "org.apache.hadoop.fs.azure.Wasb");
        conf.set("fs.azure.skip.metrics", "true");
        String testContainer = UUID.randomUUID().toString();
        String wasbUri = String.format("wasb://%s@%s", testContainer, testStorageAccount);
        try (NativeAzureFileSystem filesystem = new NativeAzureFileSystem();){
            filesystem.initialize(new URI(wasbUri), conf);
            ITestFileSystemOperationExceptionMessage.fail((String)("Expected an exception, got " + filesystem));
        }
        catch (Exception ex) {
            Throwable innerException;
            for (innerException = ex.getCause(); innerException != null && !(innerException instanceof AzureException); innerException = innerException.getCause()) {
            }
            if (innerException != null) {
                GenericTestUtils.assertExceptionContains((String)String.format("No credentials found for account %s in the configuration, and its container %s is not accessible using anonymous credentials. Please check if the container exists first. If it is not publicly available, you have to provide account credentials.", testStorageAccount, testContainer), (Throwable)ex);
            }
            ITestFileSystemOperationExceptionMessage.fail((String)"No inner azure exception");
        }
    }
}

