/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azure.AbstractWasbTestWithTimeout;
import org.apache.hadoop.fs.azure.AzureBlobStorageTestAccount;
import org.apache.hadoop.fs.azure.NativeAzureFileSystem;
import org.apache.hadoop.fs.azure.integration.AzureTestConstants;
import org.apache.hadoop.fs.azure.integration.AzureTestUtils;
import org.apache.hadoop.io.IOUtils;
import org.junit.After;
import org.junit.Assume;
import org.junit.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWasbTestBase
extends AbstractWasbTestWithTimeout
implements AzureTestConstants {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractWasbTestBase.class);
    protected NativeAzureFileSystem fs;
    protected AzureBlobStorageTestAccount testAccount;

    @Before
    public void setUp() throws Exception {
        AzureBlobStorageTestAccount account = this.createTestAccount();
        Assume.assumeNotNull((Object[])new Object[]{"test account", account});
        this.bindToTestAccount(account);
    }

    @After
    public void tearDown() throws Exception {
        this.describe("closing test account and filesystem", new Object[0]);
        this.testAccount = AzureTestUtils.cleanupTestAccount(this.testAccount);
        IOUtils.closeStream((Closeable)this.fs);
        this.fs = null;
    }

    public Configuration createConfiguration() {
        return AzureBlobStorageTestAccount.createTestConfiguration();
    }

    protected abstract AzureBlobStorageTestAccount createTestAccount() throws Exception;

    protected AzureBlobStorageTestAccount getTestAccount() {
        return this.testAccount;
    }

    protected NativeAzureFileSystem getFileSystem() {
        return this.fs;
    }

    protected Configuration getConfiguration() {
        return this.getFileSystem().getConf();
    }

    protected void bindToTestAccount(AzureBlobStorageTestAccount account) {
        AzureTestUtils.cleanupTestAccount(this.testAccount);
        IOUtils.closeStream((Closeable)this.fs);
        this.testAccount = account;
        if (this.testAccount != null) {
            this.fs = this.testAccount.getFileSystem();
        }
    }

    protected Path blobPath(String filepath) throws IOException {
        return AzureTestUtils.blobPathForTests((FileSystem)this.getFileSystem(), filepath);
    }

    protected Path path(String filepath) throws IOException {
        return AzureTestUtils.pathForTests((FileSystem)this.getFileSystem(), filepath);
    }

    protected Path methodPath() throws IOException {
        return this.path(this.methodName.getMethodName());
    }

    protected Path methodBlobPath() throws IOException {
        return this.blobPath(this.methodName.getMethodName());
    }

    protected void describe(String text, Object ... args) {
        LOG.info("\n\n{}: {}\n", (Object)this.methodName.getMethodName(), (Object)String.format(text, args));
    }
}

