/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azure.AbstractWasbTestBase;
import org.apache.hadoop.fs.azure.AzureBlobStorageTestAccount;
import org.apache.hadoop.fs.azure.InMemoryBlockBlobStore;
import org.apache.hadoop.util.StringUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestNativeAzureFileSystemConcurrency
extends AbstractWasbTestBase {
    private InMemoryBlockBlobStore backingStore;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.backingStore = this.getTestAccount().getMockStorage().getBackingStore();
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        this.backingStore = null;
    }

    @Override
    protected AzureBlobStorageTestAccount createTestAccount() throws Exception {
        return AzureBlobStorageTestAccount.createMock();
    }

    @Test
    public void testLinkBlobs() throws Exception {
        Path filePath = new Path("/inProgress");
        FSDataOutputStream outputStream = this.fs.create(filePath);
        HashMap<String, String> metadata = this.backingStore.getMetadata(AzureBlobStorageTestAccount.toMockUri(filePath));
        TestNativeAzureFileSystemConcurrency.assertNotNull(metadata);
        String linkValue = metadata.get("hdi_tmpupload");
        linkValue = URLDecoder.decode(linkValue, "UTF-8");
        TestNativeAzureFileSystemConcurrency.assertNotNull((Object)linkValue);
        TestNativeAzureFileSystemConcurrency.assertTrue((boolean)this.backingStore.exists(AzureBlobStorageTestAccount.toMockUri(linkValue)));
        TestNativeAzureFileSystemConcurrency.assertTrue((boolean)this.fs.exists(filePath));
        outputStream.close();
        metadata = this.backingStore.getMetadata(AzureBlobStorageTestAccount.toMockUri(filePath));
        TestNativeAzureFileSystemConcurrency.assertNull((Object)metadata.get("hdi_tmpupload"));
    }

    private static String toString(FileStatus[] list) {
        String[] asStrings = new String[list.length];
        for (int i = 0; i < list.length; ++i) {
            asStrings[i] = list[i].getPath().toString();
        }
        return StringUtils.join((CharSequence)",", (String[])asStrings);
    }

    @Test
    public void testNoTempBlobsVisible() throws Exception {
        Path filePath = new Path("/inProgress");
        FSDataOutputStream outputStream = this.fs.create(filePath);
        FileStatus[] listOfRoot = this.fs.listStatus(new Path("/"));
        TestNativeAzureFileSystemConcurrency.assertEquals((String)("Expected one file listed, instead got: " + TestNativeAzureFileSystemConcurrency.toString(listOfRoot)), (long)1L, (long)listOfRoot.length);
        TestNativeAzureFileSystemConcurrency.assertEquals((Object)this.fs.makeQualified(filePath), (Object)listOfRoot[0].getPath());
        outputStream.close();
    }

    private static Iterable<String> selectToString(final Iterable<Throwable> collection) {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                final Iterator exceptionIterator = collection.iterator();
                return new Iterator<String>(){

                    @Override
                    public boolean hasNext() {
                        return exceptionIterator.hasNext();
                    }

                    @Override
                    public String next() {
                        StringWriter stringWriter = new StringWriter();
                        PrintWriter printWriter = new PrintWriter(stringWriter);
                        ((Throwable)exceptionIterator.next()).printStackTrace(printWriter);
                        printWriter.close();
                        return stringWriter.toString();
                    }

                    @Override
                    public void remove() {
                        exceptionIterator.remove();
                    }
                };
            }
        };
    }

    @Test
    public void testMultiThreadedOperation() throws Exception {
        for (int iter = 0; iter < 10; ++iter) {
            int numThreads = 20;
            Thread[] threads = new Thread[20];
            final ConcurrentLinkedQueue<Throwable> exceptionsEncountered = new ConcurrentLinkedQueue<Throwable>();
            for (int i = 0; i < 20; ++i) {
                final Path threadLocalFile = new Path("/myFile" + i);
                threads[i] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Assert.assertTrue((!TestNativeAzureFileSystemConcurrency.this.fs.exists(threadLocalFile) ? 1 : 0) != 0);
                            FSDataOutputStream output = TestNativeAzureFileSystemConcurrency.this.fs.create(threadLocalFile);
                            output.write(5);
                            output.close();
                            Assert.assertTrue((boolean)TestNativeAzureFileSystemConcurrency.this.fs.exists(threadLocalFile));
                            Assert.assertTrue((TestNativeAzureFileSystemConcurrency.this.fs.listStatus(new Path("/")).length > 0 ? 1 : 0) != 0);
                        }
                        catch (Throwable ex) {
                            exceptionsEncountered.add(ex);
                        }
                    }
                });
            }
            for (Thread t : threads) {
                t.start();
            }
            for (Thread t : threads) {
                t.join();
            }
            TestNativeAzureFileSystemConcurrency.assertTrue((String)("Encountered exceptions: " + StringUtils.join((CharSequence)"\r\n", TestNativeAzureFileSystemConcurrency.selectToString(exceptionsEncountered))), (boolean)exceptionsEncountered.isEmpty());
            this.tearDown();
            this.setUp();
        }
    }
}

