/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.extensions;

import java.net.URI;
import java.util.Date;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsTestWithTimeout;
import org.apache.hadoop.fs.azurebfs.extensions.ExtensionHelper;
import org.apache.hadoop.fs.azurebfs.extensions.WrappingTokenProvider;
import org.apache.hadoop.fs.azurebfs.oauth2.AzureADToken;
import org.apache.hadoop.fs.azurebfs.oauth2.CustomTokenProviderAdapter;
import org.junit.Test;

public class TestCustomOauthTokenProvider
extends AbstractAbfsTestWithTimeout {
    @Test
    public void testCustomProviderBinding() throws Throwable {
        Configuration conf = new Configuration();
        WrappingTokenProvider.enable(conf);
        AbfsConfiguration abfs = new AbfsConfiguration(conf, "not-a-real-account");
        CustomTokenProviderAdapter provider = (CustomTokenProviderAdapter)abfs.getTokenProvider();
        TestCustomOauthTokenProvider.assertEquals((String)"User agent", (Object)"provider=inited", (Object)provider.getUserAgentSuffix());
        ExtensionHelper.bind((Object)provider, (URI)new URI("abfs://store@user.dfs.core.windows.net"), (Configuration)conf);
        TestCustomOauthTokenProvider.assertEquals((String)"User agent", (Object)"provider=bound", (Object)ExtensionHelper.getUserAgentSuffix((Object)provider, (String)""));
        AzureADToken token = provider.getToken();
        TestCustomOauthTokenProvider.assertEquals((String)"Access token propagation", (Object)"accessToken", (Object)token.getAccessToken());
        Date expiry = token.getExpiry();
        long time = expiry.getTime();
        TestCustomOauthTokenProvider.assertTrue((String)("date wrong: " + expiry), (time <= System.currentTimeMillis() ? 1 : 0) != 0);
        provider.close();
        TestCustomOauthTokenProvider.assertEquals((String)"User agent", (Object)"provider=closed", (Object)provider.getUserAgentSuffix());
    }
}

