/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessDeniedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.contracts.services.AzureServiceErrorCode;
import org.apache.hadoop.fs.azurebfs.extensions.MockDelegationSASTokenProvider;
import org.apache.hadoop.fs.azurebfs.services.AbfsHttpOperation;
import org.apache.hadoop.fs.azurebfs.services.AbfsRestOperation;
import org.apache.hadoop.fs.azurebfs.services.AuthType;
import org.apache.hadoop.fs.azurebfs.utils.AclTestHelpers;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.test.LambdaTestUtils;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assume;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ITestAzureBlobFileSystemDelegationSAS
extends AbstractAbfsIntegrationTest {
    private static final String TEST_GROUP = UUID.randomUUID().toString();
    private static final Logger LOG = LoggerFactory.getLogger(ITestAzureBlobFileSystemDelegationSAS.class);

    public ITestAzureBlobFileSystemDelegationSAS() throws Exception {
        String sasProvider = this.getRawConfiguration().get("fs.azure.sas.token.provider.type");
        Assume.assumeTrue((boolean)MockDelegationSASTokenProvider.class.getCanonicalName().equals(sasProvider));
        Assume.assumeNotNull((Object[])new Object[]{this.getRawConfiguration().get("fs.azure.test.app.id")});
        Assume.assumeNotNull((Object[])new Object[]{this.getRawConfiguration().get("fs.azure.test.app.secret")});
        Assume.assumeNotNull((Object[])new Object[]{this.getRawConfiguration().get("fs.azure.test.app.service.principal.tenant.id")});
        Assume.assumeNotNull((Object[])new Object[]{this.getRawConfiguration().get("fs.azure.test.app.service.principal.object.id")});
        Assume.assumeTrue((this.getAuthType() == AuthType.SharedKey ? 1 : 0) != 0);
    }

    @Override
    public void setup() throws Exception {
        boolean isHNSEnabled = this.getConfiguration().getBoolean("fs.azure.test.namespace.enabled", false);
        Assume.assumeTrue((boolean)isHNSEnabled);
        this.createFilesystemForSASTests();
        super.setup();
    }

    @Test
    public void testCheckAccess() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path rootPath = new Path("/");
        fs.setOwner(rootPath, "325f1619-4205-432f-9fce-3fd594325ce5", null);
        fs.setPermission(rootPath, new FsPermission(FsAction.ALL, FsAction.READ_EXECUTE, FsAction.EXECUTE));
        FileStatus rootStatus = fs.getFileStatus(rootPath);
        ITestAzureBlobFileSystemDelegationSAS.assertEquals((String)"The directory permissions are not expected.", (Object)"rwxr-x--x", (Object)rootStatus.getPermission().toString());
        ITestAzureBlobFileSystemDelegationSAS.assertEquals((String)"The directory owner is not expected.", (Object)"325f1619-4205-432f-9fce-3fd594325ce5", (Object)rootStatus.getOwner());
        Path dirPath = new Path(UUID.randomUUID().toString());
        fs.mkdirs(dirPath);
        Path filePath = new Path(dirPath, "file1");
        fs.create(filePath).close();
        fs.setPermission(filePath, new FsPermission(FsAction.READ, FsAction.READ, FsAction.NONE));
        FileStatus dirStatus = fs.getFileStatus(dirPath);
        FileStatus fileStatus = fs.getFileStatus(filePath);
        ITestAzureBlobFileSystemDelegationSAS.assertEquals((String)"The owner is not expected.", (Object)"325f1619-4205-432f-9fce-3fd594325ce5", (Object)dirStatus.getOwner());
        ITestAzureBlobFileSystemDelegationSAS.assertEquals((String)"The owner is not expected.", (Object)"325f1619-4205-432f-9fce-3fd594325ce5", (Object)fileStatus.getOwner());
        ITestAzureBlobFileSystemDelegationSAS.assertEquals((String)"The directory permissions are not expected.", (Object)"rwxr-xr-x", (Object)dirStatus.getPermission().toString());
        ITestAzureBlobFileSystemDelegationSAS.assertEquals((String)"The file permissions are not expected.", (Object)"r--r-----", (Object)fileStatus.getPermission().toString());
        ITestAzureBlobFileSystemDelegationSAS.assertTrue((boolean)this.isAccessible((FileSystem)fs, dirPath, FsAction.READ_WRITE));
        ITestAzureBlobFileSystemDelegationSAS.assertFalse((boolean)this.isAccessible((FileSystem)fs, filePath, FsAction.READ_WRITE));
        fs.setPermission(filePath, new FsPermission(FsAction.READ_WRITE, FsAction.READ, FsAction.NONE));
        fileStatus = fs.getFileStatus(filePath);
        ITestAzureBlobFileSystemDelegationSAS.assertEquals((String)"The file permissions are not expected.", (Object)"rw-r-----", (Object)fileStatus.getPermission().toString());
        ITestAzureBlobFileSystemDelegationSAS.assertTrue((boolean)this.isAccessible((FileSystem)fs, filePath, FsAction.READ_WRITE));
        fs.setPermission(dirPath, new FsPermission(FsAction.EXECUTE, FsAction.NONE, FsAction.NONE));
        dirStatus = fs.getFileStatus(dirPath);
        ITestAzureBlobFileSystemDelegationSAS.assertEquals((String)"The file permissions are not expected.", (Object)"--x------", (Object)dirStatus.getPermission().toString());
        ITestAzureBlobFileSystemDelegationSAS.assertFalse((boolean)this.isAccessible((FileSystem)fs, dirPath, FsAction.READ_WRITE));
        ITestAzureBlobFileSystemDelegationSAS.assertTrue((boolean)this.isAccessible((FileSystem)fs, dirPath, FsAction.EXECUTE));
        fs.setPermission(dirPath, new FsPermission(FsAction.NONE, FsAction.NONE, FsAction.NONE));
        dirStatus = fs.getFileStatus(dirPath);
        ITestAzureBlobFileSystemDelegationSAS.assertEquals((String)"The file permissions are not expected.", (Object)"---------", (Object)dirStatus.getPermission().toString());
        ITestAzureBlobFileSystemDelegationSAS.assertFalse((boolean)this.isAccessible((FileSystem)fs, filePath, FsAction.READ_WRITE));
    }

    private boolean isAccessible(FileSystem fs, Path path, FsAction fsAction) throws IOException {
        try {
            fs.access(path, fsAction);
        }
        catch (AccessControlException ace) {
            return false;
        }
        return true;
    }

    @Test
    public void testReadAndWrite() throws Exception {
        String fileContent;
        int bytesRead;
        AzureBlobFileSystem fs = this.getFileSystem();
        Path reqPath = new Path(UUID.randomUUID().toString());
        String msg1 = "purple";
        String msg2 = "yellow";
        int expectedFileLength = "purple".length() * 2;
        byte[] readBuffer = new byte[1024];
        try (FSDataOutputStream stream = fs.create(reqPath);){
            stream.writeBytes("purple");
            stream.hflush();
            stream.writeBytes("purple");
        }
        stream = fs.open(reqPath);
        try {
            bytesRead = stream.read(readBuffer, 0, readBuffer.length);
            ITestAzureBlobFileSystemDelegationSAS.assertEquals((long)expectedFileLength, (long)bytesRead);
            fileContent = new String(readBuffer, 0, bytesRead, StandardCharsets.UTF_8);
            ITestAzureBlobFileSystemDelegationSAS.assertEquals((Object)"purplepurple", (Object)fileContent);
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
        stream = fs.create(reqPath);
        try {
            stream.writeBytes("yellow");
            stream.hflush();
            stream.writeBytes("yellow");
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
        stream = fs.open(reqPath);
        try {
            bytesRead = stream.read(readBuffer, 0, readBuffer.length);
            ITestAzureBlobFileSystemDelegationSAS.assertEquals((long)expectedFileLength, (long)bytesRead);
            fileContent = new String(readBuffer, 0, bytesRead, StandardCharsets.UTF_8);
            ITestAzureBlobFileSystemDelegationSAS.assertEquals((Object)"yellowyellow", (Object)fileContent);
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
        stream = fs.append(reqPath);
        try {
            stream.writeBytes("purple");
            stream.hflush();
            stream.writeBytes("purple");
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
        stream = fs.open(reqPath);
        try {
            bytesRead = stream.read(readBuffer, 0, readBuffer.length);
            ITestAzureBlobFileSystemDelegationSAS.assertEquals((long)(2 * expectedFileLength), (long)bytesRead);
            fileContent = new String(readBuffer, 0, bytesRead, StandardCharsets.UTF_8);
            ITestAzureBlobFileSystemDelegationSAS.assertEquals((Object)"yellowyellowpurplepurple", (Object)fileContent);
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    @Test
    public void testRename() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path sourceDir = new Path(UUID.randomUUID().toString());
        Path sourcePath = new Path(sourceDir, UUID.randomUUID().toString());
        Path destinationPath = new Path(sourceDir, UUID.randomUUID().toString());
        Path destinationDir = new Path(UUID.randomUUID().toString());
        try (FSDataOutputStream stream = fs.create(sourcePath);){
            stream.writeBytes("hello");
        }
        ContractTestUtils.assertPathDoesNotExist((FileSystem)fs, (String)"This path should not exist", (Path)destinationPath);
        fs.rename(sourcePath, destinationPath);
        ContractTestUtils.assertPathDoesNotExist((FileSystem)fs, (String)"This path should not exist", (Path)sourcePath);
        ContractTestUtils.assertPathExists((FileSystem)fs, (String)"This path should exist", (Path)destinationPath);
        ContractTestUtils.assertPathDoesNotExist((FileSystem)fs, (String)"This path should not exist", (Path)destinationDir);
        fs.rename(sourceDir, destinationDir);
        ContractTestUtils.assertPathDoesNotExist((FileSystem)fs, (String)"This path should not exist", (Path)sourceDir);
        ContractTestUtils.assertPathExists((FileSystem)fs, (String)"This path should exist", (Path)destinationDir);
    }

    @Test
    public void testDelete() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path dirPath = new Path(UUID.randomUUID().toString());
        Path filePath = new Path(dirPath, UUID.randomUUID().toString());
        try (FSDataOutputStream stream = fs.create(filePath);){
            stream.writeBytes("hello");
        }
        ContractTestUtils.assertPathExists((FileSystem)fs, (String)"This path should exist", (Path)filePath);
        fs.delete(filePath, false);
        ContractTestUtils.assertPathDoesNotExist((FileSystem)fs, (String)"This path should not exist", (Path)filePath);
        ContractTestUtils.assertPathExists((FileSystem)fs, (String)"This path should exist", (Path)dirPath);
        fs.delete(dirPath, false);
        ContractTestUtils.assertPathDoesNotExist((FileSystem)fs, (String)"This path should not exist", (Path)dirPath);
    }

    @Test
    public void testDeleteRecursive() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path dirPath = new Path(UUID.randomUUID().toString());
        Path filePath = new Path(dirPath, UUID.randomUUID().toString());
        try (FSDataOutputStream stream = fs.create(filePath);){
            stream.writeBytes("hello");
        }
        ContractTestUtils.assertPathExists((FileSystem)fs, (String)"This path should exist", (Path)dirPath);
        ContractTestUtils.assertPathExists((FileSystem)fs, (String)"This path should exist", (Path)filePath);
        fs.delete(dirPath, true);
        ContractTestUtils.assertPathDoesNotExist((FileSystem)fs, (String)"This path should not exist", (Path)filePath);
        ContractTestUtils.assertPathDoesNotExist((FileSystem)fs, (String)"This path should not exist", (Path)dirPath);
    }

    @Test
    public void testList() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path dirPath = new Path(UUID.randomUUID().toString());
        Path filePath = new Path(dirPath, UUID.randomUUID().toString());
        fs.mkdirs(dirPath);
        try (FSDataOutputStream stream = fs.create(filePath);){
            stream.writeBytes("hello");
        }
        fs.listStatus(filePath);
        fs.listStatus(dirPath);
        fs.listStatus(new Path("/"));
    }

    @Test
    public void testAcl() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path reqPath = new Path(UUID.randomUUID().toString());
        fs.create(reqPath).close();
        fs.setAcl(reqPath, Arrays.asList(AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, TEST_GROUP, FsAction.ALL)));
        AclStatus acl = fs.getAclStatus(reqPath);
        ITestAzureBlobFileSystemDelegationSAS.assertEquals((Object)"325f1619-4205-432f-9fce-3fd594325ce5", (Object)acl.getOwner());
        ITestAzureBlobFileSystemDelegationSAS.assertEquals((Object)("[group::r--, group:" + TEST_GROUP + ":rwx]"), (Object)acl.getEntries().toString());
        fs.removeAcl(reqPath);
        acl = fs.getAclStatus(reqPath);
        ITestAzureBlobFileSystemDelegationSAS.assertEquals((Object)"[]", (Object)acl.getEntries().toString());
        fs.setPermission(reqPath, new FsPermission(FsAction.ALL, FsAction.NONE, FsAction.NONE));
        FileStatus status = fs.getFileStatus(reqPath);
        ITestAzureBlobFileSystemDelegationSAS.assertEquals((Object)"rwx------", (Object)status.getPermission().toString());
        acl = fs.getAclStatus(reqPath);
        ITestAzureBlobFileSystemDelegationSAS.assertEquals((Object)"rwx------", (Object)acl.getPermission().toString());
    }

    @Test
    public void testRootPath() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path rootPath = new Path("/");
        fs.setOwner(rootPath, "325f1619-4205-432f-9fce-3fd594325ce5", null);
        FileStatus status = fs.getFileStatus(rootPath);
        ITestAzureBlobFileSystemDelegationSAS.assertEquals((Object)"rwxr-x---", (Object)status.getPermission().toString());
        ITestAzureBlobFileSystemDelegationSAS.assertEquals((Object)"325f1619-4205-432f-9fce-3fd594325ce5", (Object)status.getOwner());
        ITestAzureBlobFileSystemDelegationSAS.assertTrue((boolean)status.isDirectory());
        AclStatus acl = fs.getAclStatus(rootPath);
        ITestAzureBlobFileSystemDelegationSAS.assertEquals((Object)"rwxr-x---", (Object)acl.getPermission().toString());
        ArrayList<AclEntry> aclSpec = new ArrayList<AclEntry>();
        int count = 0;
        for (AclEntry entry : acl.getEntries()) {
            aclSpec.add(entry);
            if (entry.getScope() != AclEntryScope.DEFAULT) continue;
            ++count;
        }
        ITestAzureBlobFileSystemDelegationSAS.assertEquals((long)0L, (long)count);
        aclSpec.add(AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "cd548981-afec-4ab9-9d39-f6f2add2fd9b", FsAction.EXECUTE));
        fs.modifyAclEntries(rootPath, aclSpec);
        acl = fs.getAclStatus(rootPath);
        count = 0;
        for (AclEntry entry : acl.getEntries()) {
            aclSpec.add(entry);
            if (entry.getScope() != AclEntryScope.DEFAULT) continue;
            ++count;
        }
        ITestAzureBlobFileSystemDelegationSAS.assertEquals((long)5L, (long)count);
        fs.removeDefaultAcl(rootPath);
        acl = fs.getAclStatus(rootPath);
        count = 0;
        for (AclEntry entry : acl.getEntries()) {
            aclSpec.add(entry);
            if (entry.getScope() != AclEntryScope.DEFAULT) continue;
            ++count;
        }
        ITestAzureBlobFileSystemDelegationSAS.assertEquals((long)0L, (long)count);
    }

    @Test
    public void testProperties() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path reqPath = new Path(UUID.randomUUID().toString());
        fs.create(reqPath).close();
        String propertyName = "user.mime_type";
        byte[] propertyValue = "text/plain".getBytes("utf-8");
        fs.setXAttr(reqPath, "user.mime_type", propertyValue);
        ITestAzureBlobFileSystemDelegationSAS.assertArrayEquals((byte[])propertyValue, (byte[])fs.getXAttr(reqPath, "user.mime_type"));
    }

    @Test
    public void testSignatureMask() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        String src = String.format("/testABC/test%s.xt", UUID.randomUUID());
        fs.create(new Path(src)).close();
        AbfsRestOperation abfsHttpRestOperation = fs.getAbfsClient().renamePath(src, "/testABC/abc.txt", null, this.getTestTracingContext(fs, false), null, false).getOp();
        AbfsHttpOperation result = abfsHttpRestOperation.getResult();
        String url = result.getMaskedUrl();
        String encodedUrl = result.getMaskedEncodedUrl();
        ((AbstractStringAssert)Assertions.assertThat((String)url.substring(url.indexOf("sig="))).describedAs("Signature query param should be masked", new Object[0])).startsWith((CharSequence)"sig=XXXXX");
        ((AbstractStringAssert)Assertions.assertThat((String)encodedUrl.substring(encodedUrl.indexOf("sig%3D"))).describedAs("Signature query param should be masked", new Object[0])).startsWith((CharSequence)"sig%3DXXXXX");
    }

    @Test
    public void testSignatureMaskOnExceptionMessage() throws Exception {
        LambdaTestUtils.intercept(IOException.class, (String)"sig=XXXX", () -> this.getFileSystem().getAbfsClient().renamePath("testABC/test.xt", "testABC/abc.txt", null, this.getTestTracingContext(this.getFileSystem(), false), null, false));
    }

    @Test
    public void testSetPermissionForNonOwner() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path rootPath = new Path("/");
        FileStatus rootStatus = fs.getFileStatus(rootPath);
        ITestAzureBlobFileSystemDelegationSAS.assertEquals((String)"The permissions are not expected.", (Object)"rwxr-x---", (Object)rootStatus.getPermission().toString());
        ITestAzureBlobFileSystemDelegationSAS.assertNotEquals((String)"The owner is not expected.", (Object)"325f1619-4205-432f-9fce-3fd594325ce5", (Object)rootStatus.getOwner());
        LambdaTestUtils.intercept(AccessDeniedException.class, (String)AzureServiceErrorCode.AUTHORIZATION_PERMISSION_MISS_MATCH.getErrorCode(), () -> {
            fs.setPermission(rootPath, new FsPermission(FsAction.ALL, FsAction.READ_EXECUTE, FsAction.EXECUTE));
            return "Set permission should fail because saoid is not the owner.";
        });
        fs.setOwner(rootPath, "325f1619-4205-432f-9fce-3fd594325ce5", null);
        fs.setPermission(rootPath, new FsPermission(FsAction.ALL, FsAction.READ_EXECUTE, FsAction.EXECUTE));
        rootStatus = fs.getFileStatus(rootPath);
        ITestAzureBlobFileSystemDelegationSAS.assertEquals((String)"The permissions are not expected.", (Object)"rwxr-x--x", (Object)rootStatus.getPermission().toString());
        ITestAzureBlobFileSystemDelegationSAS.assertEquals((String)"The directory owner is not expected.", (Object)"325f1619-4205-432f-9fce-3fd594325ce5", (Object)rootStatus.getOwner());
    }

    @Test
    public void testSetPermissionWithoutAgentForNonOwner() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path path = new Path("NoAgentPath");
        fs.create(path).close();
        FileStatus status = fs.getFileStatus(path);
        ITestAzureBlobFileSystemDelegationSAS.assertEquals((String)"The permissions are not expected.", (Object)"rw-r--r--", (Object)status.getPermission().toString());
        ITestAzureBlobFileSystemDelegationSAS.assertNotEquals((String)"The owner is not expected.", (Object)"fs.azure.test.app.service.principal.object.id", (Object)status.getOwner());
        fs.setPermission(path, new FsPermission(FsAction.READ, FsAction.READ, FsAction.NONE));
        FileStatus fileStatus = fs.getFileStatus(path);
        ITestAzureBlobFileSystemDelegationSAS.assertEquals((String)"The permissions are not expected.", (Object)"r--r-----", (Object)fileStatus.getPermission().toString());
    }

    @Test
    public void testSASQuesMarkPrefix() throws Exception {
        AbfsConfiguration testConfig = this.getConfiguration();
        testConfig.set("fs.azure.sas.token.provider.type", "org.apache.hadoop.fs.azurebfs.extensions.MockWithPrefixSASTokenProvider");
        AzureBlobFileSystem testFs = (AzureBlobFileSystem)FileSystem.newInstance((Configuration)this.getRawConfiguration());
        Path testFile = new Path("/testSASPrefixQuesMark");
        testFs.create(testFile).close();
    }
}

