/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.commit;

import java.io.File;
import java.io.FileNotFoundException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.examples.terasort.TeraGen;
import org.apache.hadoop.examples.terasort.TeraSort;
import org.apache.hadoop.examples.terasort.TeraSortConfigKeys;
import org.apache.hadoop.examples.terasort.TeraValidate;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.azurebfs.commit.AbstractAbfsClusterITest;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.IOStatisticsLogging;
import org.apache.hadoop.fs.statistics.IOStatisticsSnapshot;
import org.apache.hadoop.fs.statistics.IOStatisticsSupport;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.ManifestCommitterTestSupport;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.ManifestSuccessData;
import org.apache.hadoop.util.DurationInfo;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hadoop.util.functional.RemoteIterators;
import org.junit.Assume;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class ITestAbfsTerasort
extends AbstractAbfsClusterITest {
    private static final Logger LOG = LoggerFactory.getLogger(ITestAbfsTerasort.class);
    public static final int EXPECTED_PARTITION_COUNT = 10;
    public static final int PARTITION_SAMPLE_SIZE = 1000;
    public static final int ROW_COUNT = 1000;
    private static final Path TERASORT_PATH = new Path("/ITestAbfsTerasort");
    private static Optional<DurationInfo> terasortDuration = Optional.empty();
    private static final Map<String, DurationInfo> COMPLETED_STAGES = new HashMap<String, DurationInfo>();
    protected static final IOStatisticsSnapshot JOB_IOSTATS = IOStatisticsSupport.snapshotIOStatistics();
    private Path terasortPath;
    private Path sortInput;
    private Path sortOutput;
    private Path sortValidate;

    @Override
    public void setup() throws Exception {
        super.setup();
        this.prepareToTerasort();
    }

    @Override
    protected void applyCustomConfigOptions(JobConf conf) {
        conf.setInt(TeraSortConfigKeys.SAMPLE_SIZE.key(), this.getSampleSizeForEachPartition());
        conf.setInt(TeraSortConfigKeys.NUM_PARTITIONS.key(), this.getExpectedPartitionCount());
        conf.setBoolean(TeraSortConfigKeys.USE_SIMPLE_PARTITIONER.key(), false);
    }

    private int getExpectedPartitionCount() {
        return 10;
    }

    private int getSampleSizeForEachPartition() {
        return 1000;
    }

    protected int getRowCount() {
        return 1000;
    }

    private void prepareToTerasort() {
        this.terasortPath = this.getFileSystem().makeQualified(TERASORT_PATH);
        this.sortInput = new Path(this.terasortPath, "sortin");
        this.sortOutput = new Path(this.terasortPath, "sortout");
        this.sortValidate = new Path(this.terasortPath, "validate");
    }

    private static void completedStage(String stage, DurationInfo d) {
        COMPLETED_STAGES.put(stage, d);
    }

    private static void requireStage(String stage) {
        Assume.assumeTrue((String)("Required stage was not completed: " + stage), (COMPLETED_STAGES.get(stage) != null ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeStage(String stage, JobConf jobConf, Path dest, Tool tool, String[] args, int minimumFileCount) throws Exception {
        int result;
        try (DurationInfo d = new DurationInfo(LOG, stage, new Object[0]);){
            result = ToolRunner.run((Configuration)jobConf, (Tool)tool, (String[])args);
        }
        this.dumpOutputTree(dest);
        ITestAbfsTerasort.assertEquals((String)(stage + "(" + StringUtils.join((CharSequence)", ", (String[])args) + ") failed"), (long)0L, (long)result);
        ManifestSuccessData successFile = ManifestCommitterTestSupport.validateSuccessFile((FileSystem)this.getFileSystem(), (Path)dest, (int)minimumFileCount, (String)"");
        JOB_IOSTATS.aggregate((IOStatistics)successFile.getIOStatistics());
        ITestAbfsTerasort.completedStage(stage, d);
    }

    @Test
    public void test_100_terasort_setup() throws Throwable {
        this.describe("Setting up for a terasort");
        this.getFileSystem().delete(this.terasortPath, true);
        terasortDuration = Optional.of(new DurationInfo(LOG, false, "Terasort", new Object[0]));
    }

    @Test
    public void test_110_teragen() throws Throwable {
        this.describe("Teragen to %s", new Object[]{this.sortInput});
        this.getFileSystem().delete(this.sortInput, true);
        JobConf jobConf = this.newJobConf();
        this.patchConfigurationForCommitter((Configuration)jobConf);
        this.executeStage("teragen", jobConf, this.sortInput, (Tool)new TeraGen(), new String[]{Integer.toString(this.getRowCount()), this.sortInput.toString()}, 1);
    }

    @Test
    public void test_120_terasort() throws Throwable {
        this.describe("Terasort from %s to %s", new Object[]{this.sortInput, this.sortOutput});
        ITestAbfsTerasort.requireStage("teragen");
        this.getFileSystem().delete(this.sortOutput, true);
        ManifestCommitterTestSupport.loadSuccessFile((FileSystem)this.getFileSystem(), (Path)this.sortInput);
        JobConf jobConf = this.newJobConf();
        this.patchConfigurationForCommitter((Configuration)jobConf);
        this.executeStage("terasort", jobConf, this.sortOutput, (Tool)new TeraSort(), new String[]{this.sortInput.toString(), this.sortOutput.toString()}, 1);
    }

    @Test
    public void test_130_teravalidate() throws Throwable {
        this.describe("TeraValidate from %s to %s", new Object[]{this.sortOutput, this.sortValidate});
        ITestAbfsTerasort.requireStage("terasort");
        this.getFileSystem().delete(this.sortValidate, true);
        ManifestCommitterTestSupport.loadSuccessFile((FileSystem)this.getFileSystem(), (Path)this.sortOutput);
        JobConf jobConf = this.newJobConf();
        this.patchConfigurationForCommitter((Configuration)jobConf);
        this.executeStage("teravalidate", jobConf, this.sortValidate, (Tool)new TeraValidate(), new String[]{this.sortOutput.toString(), this.sortValidate.toString()}, 1);
    }

    @Test
    public void test_140_teracomplete() throws Throwable {
        terasortDuration.ifPresent(d -> {
            d.close();
            ITestAbfsTerasort.completedStage("overall", d);
        });
        IOStatisticsLogging.logIOStatisticsAtLevel((Logger)LOG, (String)"info", (Object)JOB_IOSTATS);
        StringBuilder results = new StringBuilder();
        results.append("\"Operation\"\t\"Duration\"\n");
        Consumer<String> stage = s -> {
            DurationInfo duration = COMPLETED_STAGES.get(s);
            results.append(String.format("\"%s\"\t\"%s\"\n", s, duration == null ? "" : duration));
        };
        stage.accept("teragen");
        stage.accept("terasort");
        stage.accept("teravalidate");
        stage.accept("overall");
        String text = results.toString();
        File resultsFile = File.createTempFile("results", ".csv");
        FileUtils.write((File)resultsFile, (CharSequence)text, (Charset)StandardCharsets.UTF_8);
        LOG.info("Results are in {}\n{}", (Object)resultsFile, (Object)text);
    }

    @Test
    public void test_150_teracleanup() throws Throwable {
        terasortDuration = Optional.empty();
    }

    @Test
    public void test_200_directory_deletion() throws Throwable {
        this.getFileSystem().delete(this.terasortPath, true);
    }

    protected void dumpOutputTree(Path path) throws Exception {
        LOG.info("Files under output directory {}", (Object)path);
        try {
            RemoteIterators.foreach((RemoteIterator)this.getFileSystem().listFiles(path, true), status -> LOG.info("{}", status));
        }
        catch (FileNotFoundException e) {
            LOG.info("Output directory {} not found", (Object)path);
        }
    }
}

