/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Random;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystemStore;
import org.apache.hadoop.fs.azurebfs.services.AbfsCounters;
import org.apache.hadoop.fs.azurebfs.services.AbfsInputStream;
import org.apache.hadoop.fs.azurebfs.utils.TracingContext;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class ITestAbfsInputStream
extends AbstractAbfsIntegrationTest {
    protected static final int HUNDRED = 100;

    @Test
    public void testWithNoOptimization() throws Exception {
        for (int i = 2; i <= 7; ++i) {
            int fileSize = i * 0x100000;
            AzureBlobFileSystem fs = this.getFileSystem(false, false, fileSize);
            String fileName = this.methodName.getMethodName() + i;
            byte[] fileContent = this.getRandomBytesArray(fileSize);
            Path testFilePath = this.createFileWithContent((FileSystem)fs, fileName, fileContent);
            this.testWithNoOptimization((FileSystem)fs, testFilePath, 100, fileContent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testWithNoOptimization(FileSystem fs, Path testFilePath, int seekPos, byte[] fileContent) throws IOException {
        try (FSDataInputStream iStream = fs.open(testFilePath);){
            AbfsInputStream abfsInputStream = (AbfsInputStream)iStream.getWrappedStream();
            iStream = new FSDataInputStream((InputStream)abfsInputStream);
            this.seek(iStream, seekPos);
            long totalBytesRead = 0L;
            int length = 10000;
            do {
                byte[] buffer;
                int bytesRead;
                if ((totalBytesRead += (long)(bytesRead = iStream.read(buffer = new byte[length], 0, length))) + (long)seekPos >= (long)fileContent.length) {
                    length = (fileContent.length - seekPos) % length;
                }
                ITestAbfsInputStream.assertEquals((long)length, (long)bytesRead);
                this.assertContentReadCorrectly(fileContent, (int)((long)seekPos + totalBytesRead - (long)length), length, buffer);
                ITestAbfsInputStream.assertTrue((abfsInputStream.getFCursor() >= (long)seekPos + totalBytesRead ? 1 : 0) != 0);
                ITestAbfsInputStream.assertTrue((abfsInputStream.getFCursorAfterLastRead() >= (long)seekPos + totalBytesRead ? 1 : 0) != 0);
                ITestAbfsInputStream.assertTrue(((long)abfsInputStream.getBCursor() >= totalBytesRead % (long)abfsInputStream.getBufferSize() ? 1 : 0) != 0);
                ITestAbfsInputStream.assertTrue((abfsInputStream.getLimit() >= totalBytesRead % (long)abfsInputStream.getBufferSize() ? 1 : 0) != 0);
            } while (totalBytesRead + (long)seekPos < (long)fileContent.length);
        }
    }

    @Test
    public void testExceptionInOptimization() throws Exception {
        for (int i = 2; i <= 7; ++i) {
            int fileSize = i * 0x100000;
            AzureBlobFileSystem fs = this.getFileSystem(true, true, fileSize);
            String fileName = this.methodName.getMethodName() + i;
            byte[] fileContent = this.getRandomBytesArray(fileSize);
            Path testFilePath = this.createFileWithContent((FileSystem)fs, fileName, fileContent);
            this.testExceptionInOptimization((FileSystem)fs, testFilePath, fileSize - 100, fileSize / 4, fileContent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testExceptionInOptimization(FileSystem fs, Path testFilePath, int seekPos, int length, byte[] fileContent) throws IOException {
        try (FSDataInputStream iStream = fs.open(testFilePath);){
            AbfsInputStream abfsInputStream = (AbfsInputStream)iStream.getWrappedStream();
            abfsInputStream = (AbfsInputStream)Mockito.spy((Object)abfsInputStream);
            ((AbfsInputStream)Mockito.doThrow((Throwable[])new Throwable[]{new IOException()}).doCallRealMethod().when((Object)abfsInputStream)).readRemote(ArgumentMatchers.anyLong(), (byte[])ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt(), (TracingContext)ArgumentMatchers.any(TracingContext.class));
            iStream = new FSDataInputStream((InputStream)abfsInputStream);
            this.verifyBeforeSeek(abfsInputStream);
            this.seek(iStream, seekPos);
            byte[] buffer = new byte[length];
            int bytesRead = iStream.read(buffer, 0, length);
            long actualLength = length;
            if (seekPos + length > fileContent.length) {
                long delta = seekPos + length - fileContent.length;
                actualLength = (long)length - delta;
            }
            ITestAbfsInputStream.assertEquals((long)bytesRead, (long)actualLength);
            this.assertContentReadCorrectly(fileContent, seekPos, (int)actualLength, buffer);
            ITestAbfsInputStream.assertEquals((long)fileContent.length, (long)abfsInputStream.getFCursor());
            ITestAbfsInputStream.assertEquals((long)fileContent.length, (long)abfsInputStream.getFCursorAfterLastRead());
            ITestAbfsInputStream.assertEquals((long)actualLength, (long)abfsInputStream.getBCursor());
            ITestAbfsInputStream.assertTrue((abfsInputStream.getLimit() >= actualLength ? 1 : 0) != 0);
        }
    }

    protected AzureBlobFileSystem getFileSystem(boolean readSmallFilesCompletely) throws IOException {
        AzureBlobFileSystem fs = this.getFileSystem();
        this.getAbfsStore(fs).getAbfsConfiguration().setReadSmallFilesCompletely(readSmallFilesCompletely);
        return fs;
    }

    private AzureBlobFileSystem getFileSystem(boolean optimizeFooterRead, boolean readSmallFileCompletely, int fileSize) throws IOException {
        AzureBlobFileSystem fs = this.getFileSystem();
        this.getAbfsStore(fs).getAbfsConfiguration().setOptimizeFooterRead(optimizeFooterRead);
        if (fileSize <= this.getAbfsStore(fs).getAbfsConfiguration().getReadBufferSize()) {
            this.getAbfsStore(fs).getAbfsConfiguration().setReadSmallFilesCompletely(readSmallFileCompletely);
        }
        return fs;
    }

    protected byte[] getRandomBytesArray(int length) {
        byte[] b = new byte[length];
        new Random().nextBytes(b);
        return b;
    }

    protected Path createFileWithContent(FileSystem fs, String fileName, byte[] fileContent) throws IOException {
        Path testFilePath = this.path(fileName);
        try (FSDataOutputStream oStream = fs.create(testFilePath);){
            oStream.write(fileContent);
            oStream.flush();
        }
        return testFilePath;
    }

    protected AzureBlobFileSystemStore getAbfsStore(FileSystem fs) throws NoSuchFieldException, IllegalAccessException {
        AzureBlobFileSystem abfs = (AzureBlobFileSystem)fs;
        Field abfsStoreField = AzureBlobFileSystem.class.getDeclaredField("abfsStore");
        abfsStoreField.setAccessible(true);
        return (AzureBlobFileSystemStore)abfsStoreField.get(abfs);
    }

    protected Map<String, Long> getInstrumentationMap(FileSystem fs) throws NoSuchFieldException, IllegalAccessException {
        AzureBlobFileSystem abfs = (AzureBlobFileSystem)fs;
        Field abfsCountersField = AzureBlobFileSystem.class.getDeclaredField("abfsCounters");
        abfsCountersField.setAccessible(true);
        AbfsCounters abfsCounters = (AbfsCounters)abfsCountersField.get(abfs);
        return abfsCounters.toMap();
    }

    protected void assertContentReadCorrectly(byte[] actualFileContent, int from, int len, byte[] contentRead) {
        for (int i = 0; i < len; ++i) {
            ITestAbfsInputStream.assertEquals((long)contentRead[i], (long)actualFileContent[i + from]);
        }
    }

    protected void assertBuffersAreNotEqual(byte[] actualContent, byte[] contentRead, AbfsConfiguration conf) {
        this.assertBufferEquality(actualContent, contentRead, conf, false);
    }

    protected void assertBuffersAreEqual(byte[] actualContent, byte[] contentRead, AbfsConfiguration conf) {
        this.assertBufferEquality(actualContent, contentRead, conf, true);
    }

    private void assertBufferEquality(byte[] actualContent, byte[] contentRead, AbfsConfiguration conf, boolean assertEqual) {
        int actualContentSize = actualContent.length;
        int bufferSize = conf.getReadBufferSize();
        int n = actualContentSize < bufferSize ? actualContentSize : bufferSize;
        int matches = 0;
        for (int i = 0; i < n; ++i) {
            if (actualContent[i] != contentRead[i]) continue;
            ++matches;
        }
        if (assertEqual) {
            ITestAbfsInputStream.assertEquals((long)n, (long)matches);
        } else {
            ITestAbfsInputStream.assertNotEquals((long)n, (long)matches);
        }
    }

    protected void seek(FSDataInputStream iStream, long seekPos) throws IOException {
        AbfsInputStream abfsInputStream = (AbfsInputStream)iStream.getWrappedStream();
        this.verifyBeforeSeek(abfsInputStream);
        iStream.seek(seekPos);
        this.verifyAfterSeek(abfsInputStream, seekPos);
    }

    private void verifyBeforeSeek(AbfsInputStream abfsInputStream) {
        ITestAbfsInputStream.assertEquals((long)0L, (long)abfsInputStream.getFCursor());
        ITestAbfsInputStream.assertEquals((long)-1L, (long)abfsInputStream.getFCursorAfterLastRead());
        ITestAbfsInputStream.assertEquals((long)0L, (long)abfsInputStream.getLimit());
        ITestAbfsInputStream.assertEquals((long)0L, (long)abfsInputStream.getBCursor());
    }

    private void verifyAfterSeek(AbfsInputStream abfsInputStream, long seekPos) throws IOException {
        ITestAbfsInputStream.assertEquals((long)seekPos, (long)abfsInputStream.getPos());
        ITestAbfsInputStream.assertEquals((long)-1L, (long)abfsInputStream.getFCursorAfterLastRead());
        ITestAbfsInputStream.assertEquals((long)0L, (long)abfsInputStream.getLimit());
        ITestAbfsInputStream.assertEquals((long)0L, (long)abfsInputStream.getBCursor());
    }
}

