/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.extensions;

import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.azurebfs.extensions.CustomDelegationTokenManager;
import org.apache.hadoop.fs.azurebfs.extensions.KerberizedAbfsCluster;
import org.apache.hadoop.fs.azurebfs.extensions.StubAbfsTokenIdentifier;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenIdentifier;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassicDelegationTokenManager
implements CustomDelegationTokenManager {
    private static final Logger LOG = LoggerFactory.getLogger(ClassicDelegationTokenManager.class);
    public static final String NAME = "org.apache.hadoop.fs.azurebfs.extensions.ClassicDelegationTokenManager";
    public static final String UNSET = "abfs://user@unset.dfs.core.windows.net/";
    public static final URI UNSET_URI = KerberizedAbfsCluster.newURI("abfs://user@unset.dfs.core.windows.net/");
    private URI fsURI;
    private boolean initialized;
    private boolean closed;
    private int renewals;
    private int cancellations;
    private int issued;
    private Text kind;
    private UserGroupInformation owner;
    private String canonicalServiceName;

    public void initialize(Configuration configuration) throws IOException {
        this.initialized = true;
        this.owner = UserGroupInformation.getCurrentUser();
        LOG.info("Creating Stub DT manager for {}", (Object)this.owner.getUserName());
    }

    public void close() {
        this.closed = true;
    }

    public Token<DelegationTokenIdentifier> getDelegationToken(String renewer) throws IOException {
        ++this.issued;
        URI uri = this.fsURI != null ? this.fsURI : UNSET_URI;
        Text renewerT = new Text(renewer != null ? renewer : "");
        Token<DelegationTokenIdentifier> t = ClassicDelegationTokenManager.createToken(this.issued, uri, new Text(this.owner.getUserName()), renewerT);
        if (this.kind != null) {
            t.setKind(this.kind);
        }
        t.setService(this.createServiceText());
        LOG.info("Created token {}", t);
        return t;
    }

    public Text createServiceText() {
        return new Text(this.fsURI != null ? this.fsURI.toString() : UNSET);
    }

    public static Token<DelegationTokenIdentifier> createToken(int sequenceNumber, URI uri, Text owner, Text renewer) {
        StubAbfsTokenIdentifier id = new StubAbfsTokenIdentifier(uri, owner, renewer);
        id.setSequenceNumber(sequenceNumber);
        Token token = new Token((TokenIdentifier)id, (SecretManager)new TokenSecretManager());
        return token;
    }

    public long renewDelegationToken(Token<?> token) throws IOException {
        ++this.renewals;
        StubAbfsTokenIdentifier.decodeIdentifier(token);
        return 0L;
    }

    public void cancelDelegationToken(Token<?> token) throws IOException {
        ++this.cancellations;
        StubAbfsTokenIdentifier.decodeIdentifier(token);
    }

    protected void innerBind(URI uri, Configuration conf) throws IOException {
        Preconditions.checkState((boolean)this.initialized, (Object)"Not initialized");
        Preconditions.checkState((this.fsURI == null ? 1 : 0) != 0, (Object)"already bound");
        this.fsURI = uri;
        this.canonicalServiceName = uri.toString();
        LOG.info("Bound to {}", (Object)this.fsURI);
    }

    public String getCanonicalServiceName() {
        return this.canonicalServiceName;
    }

    public void setCanonicalServiceName(String canonicalServiceName) {
        this.canonicalServiceName = canonicalServiceName;
    }

    public URI getFsURI() {
        return this.fsURI;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isBound() {
        return this.fsURI != null;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public int getRenewals() {
        return this.renewals;
    }

    public int getCancellations() {
        return this.cancellations;
    }

    public int getIssued() {
        return this.issued;
    }

    public Text getKind() {
        return this.kind;
    }

    public void setKind(Text kind) {
        this.kind = kind;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("StubDelegationTokenManager{");
        sb.append("fsURI=").append(this.fsURI);
        sb.append(", initialized=").append(this.initialized);
        sb.append(", closed=").append(this.closed);
        sb.append(", renewals=").append(this.renewals);
        sb.append(", cancellations=").append(this.cancellations);
        sb.append(", issued=").append(this.issued);
        sb.append('}');
        return sb.toString();
    }

    public static Configuration useClassicDTManager(Configuration conf) {
        conf.setBoolean("fs.azure.enable.delegation.token", true);
        conf.set("fs.azure.delegation.token.provider.type", NAME);
        return conf;
    }

    private static byte[] getSecretManagerPasssword() {
        return "non-password".getBytes(Charset.forName("UTF-8"));
    }

    protected static class TokenSecretManager
    extends SecretManager<StubAbfsTokenIdentifier> {
        protected byte[] createPassword(StubAbfsTokenIdentifier identifier) {
            return ClassicDelegationTokenManager.getSecretManagerPasssword();
        }

        public byte[] retrievePassword(StubAbfsTokenIdentifier identifier) throws SecretManager.InvalidToken {
            return ClassicDelegationTokenManager.getSecretManagerPasssword();
        }

        public StubAbfsTokenIdentifier createIdentifier() {
            return new StubAbfsTokenIdentifier();
        }
    }
}

