/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.util.Hashtable;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.utils.TracingContext;
import org.junit.Test;

public class ITestFileSystemProperties
extends AbstractAbfsIntegrationTest {
    private static final int TEST_DATA = 100;
    private static final Path TEST_PATH = new Path("/testfile");

    @Test
    public void testReadWriteBytesToFileAndEnsureThreadPoolCleanup() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        this.testWriteOneByteToFileAndEnsureThreadPoolCleanup();
        try (FSDataInputStream inputStream = fs.open(TEST_PATH, 0x400000);){
            int i = inputStream.read();
            ITestFileSystemProperties.assertEquals((long)100L, (long)i);
        }
    }

    @Test
    public void testWriteOneByteToFileAndEnsureThreadPoolCleanup() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        try (FSDataOutputStream stream = fs.create(TEST_PATH);){
            stream.write(100);
        }
        FileStatus fileStatus = fs.getFileStatus(TEST_PATH);
        ITestFileSystemProperties.assertEquals((long)1L, (long)fileStatus.getLen());
    }

    @Test
    public void testBase64FileSystemProperties() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("key", "{ value: value }");
        TracingContext tracingContext = this.getTestTracingContext(fs, true);
        fs.getAbfsStore().setFilesystemProperties(properties, tracingContext);
        Hashtable fetchedProperties = fs.getAbfsStore().getFilesystemProperties(tracingContext);
        ITestFileSystemProperties.assertEquals(properties, (Object)fetchedProperties);
    }

    @Test
    public void testBase64PathProperties() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("key", "{ value: valueTest }");
        this.touch(TEST_PATH);
        TracingContext tracingContext = this.getTestTracingContext(fs, true);
        fs.getAbfsStore().setPathProperties(TEST_PATH, properties, tracingContext);
        Hashtable fetchedProperties = fs.getAbfsStore().getPathStatus(TEST_PATH, tracingContext);
        ITestFileSystemProperties.assertEquals(properties, (Object)fetchedProperties);
    }

    @Test(expected=Exception.class)
    public void testBase64InvalidFileSystemProperties() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("key", "{ value: value\u6b72 }");
        TracingContext tracingContext = this.getTestTracingContext(fs, true);
        fs.getAbfsStore().setFilesystemProperties(properties, tracingContext);
        Hashtable fetchedProperties = fs.getAbfsStore().getFilesystemProperties(tracingContext);
        ITestFileSystemProperties.assertEquals(properties, (Object)fetchedProperties);
    }

    @Test(expected=Exception.class)
    public void testBase64InvalidPathProperties() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("key", "{ value: valueTest\u5169 }");
        this.touch(TEST_PATH);
        TracingContext tracingContext = this.getTestTracingContext(fs, true);
        fs.getAbfsStore().setPathProperties(TEST_PATH, properties, tracingContext);
        Hashtable fetchedProperties = fs.getAbfsStore().getPathStatus(TEST_PATH, tracingContext);
        ITestFileSystemProperties.assertEquals(properties, (Object)fetchedProperties);
    }

    @Test
    public void testSetFileSystemProperties() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("containerForDevTest", "true");
        TracingContext tracingContext = this.getTestTracingContext(fs, true);
        fs.getAbfsStore().setFilesystemProperties(properties, tracingContext);
        Hashtable fetchedProperties = fs.getAbfsStore().getFilesystemProperties(tracingContext);
        ITestFileSystemProperties.assertEquals(properties, (Object)fetchedProperties);
    }
}

