/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.net.URI;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbfsStatistic;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.Assume;
import org.junit.Test;

public class ITestAzureBlobFileSystemMkDir
extends AbstractAbfsIntegrationTest {
    @Test
    public void testCreateDirWithExistingDir() throws Exception {
        Assume.assumeTrue((boolean)true);
        AzureBlobFileSystem fs = this.getFileSystem();
        Path path = new Path("testFolder");
        ContractTestUtils.assertMkdirs((FileSystem)fs, (Path)path);
        ContractTestUtils.assertMkdirs((FileSystem)fs, (Path)path);
    }

    @Test
    public void testMkdirExistingDirOverwriteFalse() throws Exception {
        Assume.assumeFalse((String)"Ignore test until default overwrite is set to false", (boolean)true);
        Assume.assumeTrue((String)"Ignore test for Non-HNS accounts", (boolean)this.getIsNamespaceEnabled(this.getFileSystem()));
        Configuration config = new Configuration(this.getRawConfiguration());
        config.set("fs.azure.enable.mkdir.overwrite", Boolean.toString(false));
        AzureBlobFileSystem fs = this.getFileSystem(config);
        Path path = new Path("testFolder");
        ContractTestUtils.assertMkdirs((FileSystem)fs, (Path)path);
        long timeCreated = fs.getFileStatus(path).getModificationTime();
        ContractTestUtils.assertMkdirs((FileSystem)fs, (Path)path);
        ITestAzureBlobFileSystemMkDir.assertEquals((String)"LMT should not be updated for existing dir", (long)timeCreated, (long)fs.getFileStatus(path).getModificationTime());
    }

    @Test
    public void createDirWithExistingFilename() throws Exception {
        Assume.assumeFalse((String)"Ignore test until default overwrite is set to false", (boolean)this.getIsNamespaceEnabled(this.getFileSystem()));
        AzureBlobFileSystem fs = this.getFileSystem();
        Path path = new Path("testFilePath");
        fs.create(path);
        ITestAzureBlobFileSystemMkDir.assertTrue((boolean)fs.getFileStatus(path).isFile());
        LambdaTestUtils.intercept(FileAlreadyExistsException.class, () -> fs.mkdirs(path));
    }

    @Test
    public void testCreateRoot() throws Exception {
        ContractTestUtils.assertMkdirs((FileSystem)this.getFileSystem(), (Path)new Path("/"));
    }

    @Test
    public void testDefaultCreateOverwriteDirTest() throws Throwable {
        this.testCreateDirOverwrite(true);
        this.testCreateDirOverwrite(false);
    }

    public void testCreateDirOverwrite(boolean enableConditionalCreateOverwrite) throws Throwable {
        AzureBlobFileSystem currentFs = this.getFileSystem();
        Configuration config = new Configuration(this.getRawConfiguration());
        config.set("fs.azure.enable.conditional.create.overwrite", Boolean.toString(enableConditionalCreateOverwrite));
        AzureBlobFileSystem fs = (AzureBlobFileSystem)FileSystem.newInstance((URI)currentFs.getUri(), (Configuration)config);
        long totalConnectionMadeBeforeTest = (Long)fs.getInstrumentationMap().get(AbfsStatistic.CONNECTIONS_MADE.getStatName());
        int mkdirRequestCount = 0;
        Path dirPath = new Path("/DirPath_" + UUID.randomUUID().toString());
        fs.mkdirs(dirPath);
        this.assertAbfsStatistics(AbfsStatistic.CONNECTIONS_MADE, totalConnectionMadeBeforeTest + (long)(++mkdirRequestCount), fs.getInstrumentationMap());
        fs.mkdirs(dirPath);
        this.assertAbfsStatistics(AbfsStatistic.CONNECTIONS_MADE, totalConnectionMadeBeforeTest + (long)(++mkdirRequestCount), fs.getInstrumentationMap());
    }
}

