/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystemStore;
import org.apache.hadoop.fs.azurebfs.TestAbfsConfigurationFieldsValidation;
import org.apache.hadoop.fs.azurebfs.constants.FSOperationType;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AbfsRestOperationException;
import org.apache.hadoop.fs.azurebfs.services.AbfsClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsHttpOperation;
import org.apache.hadoop.fs.azurebfs.services.AbfsRestOperation;
import org.apache.hadoop.fs.azurebfs.services.AbfsRestOperationType;
import org.apache.hadoop.fs.azurebfs.services.TestAbfsClient;
import org.apache.hadoop.fs.azurebfs.services.TestAbfsPerfTracker;
import org.apache.hadoop.fs.azurebfs.utils.Listener;
import org.apache.hadoop.fs.azurebfs.utils.TestMockHelpers;
import org.apache.hadoop.fs.azurebfs.utils.TracingContext;
import org.apache.hadoop.fs.azurebfs.utils.TracingHeaderValidator;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assume;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class ITestAzureBlobFileSystemDelete
extends AbstractAbfsIntegrationTest {
    private static final int REDUCED_RETRY_COUNT = 1;
    private static final int REDUCED_MAX_BACKOFF_INTERVALS_MS = 5000;

    @Test
    public void testDeleteRoot() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        fs.mkdirs(new Path("/testFolder0"));
        fs.mkdirs(new Path("/testFolder1"));
        fs.mkdirs(new Path("/testFolder2"));
        this.touch(new Path("/testFolder1/testfile"));
        this.touch(new Path("/testFolder1/testfile2"));
        this.touch(new Path("/testFolder1/testfile3"));
        Path root = new Path("/");
        FileStatus[] ls = fs.listStatus(root);
        ITestAzureBlobFileSystemDelete.assertEquals((long)3L, (long)ls.length);
        fs.delete(root, true);
        ls = fs.listStatus(root);
        ITestAzureBlobFileSystemDelete.assertEquals((String)"listing size", (long)0L, (long)ls.length);
    }

    @Test
    public void testOpenFileAfterDelete() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path testfile = new Path("/testFile");
        this.touch(testfile);
        ContractTestUtils.assertDeleted((FileSystem)fs, (Path)testfile, (boolean)false);
        LambdaTestUtils.intercept(FileNotFoundException.class, () -> fs.open(testfile));
    }

    @Test
    public void testEnsureFileIsDeleted() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path testfile = new Path("testfile");
        this.touch(testfile);
        ContractTestUtils.assertDeleted((FileSystem)fs, (Path)testfile, (boolean)false);
        ContractTestUtils.assertPathDoesNotExist((FileSystem)fs, (String)"deleted", (Path)testfile);
    }

    @Test
    public void testDeleteDirectory() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path dir = new Path("testfile");
        fs.mkdirs(dir);
        fs.mkdirs(new Path("testfile/test1"));
        fs.mkdirs(new Path("testfile/test1/test2"));
        ContractTestUtils.assertDeleted((FileSystem)fs, (Path)dir, (boolean)true);
        ContractTestUtils.assertPathDoesNotExist((FileSystem)fs, (String)"deleted", (Path)dir);
    }

    @Test
    public void testDeleteFirstLevelDirectory() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        ArrayList<Future<Void>> tasks = new ArrayList<Future<Void>>();
        ExecutorService es = Executors.newFixedThreadPool(10);
        for (int i = 0; i < 1000; ++i) {
            final Path path = new Path("/test/" + i);
            Callable<Void> callable = new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    ITestAzureBlobFileSystemDelete.this.touch(path);
                    return null;
                }
            };
            tasks.add(es.submit(callable));
        }
        for (Future future : tasks) {
            future.get();
        }
        es.shutdownNow();
        Path dir = new Path("/test");
        fs.registerListener((Listener)new TracingHeaderValidator(fs.getAbfsStore().getAbfsConfiguration().getClientCorrelationId(), fs.getFileSystemId(), FSOperationType.DELETE, false, 0));
        LambdaTestUtils.intercept(FileAlreadyExistsException.class, () -> fs.delete(dir, false));
        fs.registerListener(null);
        ContractTestUtils.assertDeleted((FileSystem)fs, (Path)dir, (boolean)true);
        ContractTestUtils.assertPathDoesNotExist((FileSystem)fs, (String)"deleted", (Path)dir);
    }

    @Test
    public void testDeleteIdempotency() throws Exception {
        Assume.assumeTrue((boolean)true);
        AbfsConfiguration abfsConfig = TestAbfsConfigurationFieldsValidation.updateRetryConfigs(this.getConfiguration(), 1, 5000);
        AzureBlobFileSystem fs = this.getFileSystem();
        AbfsClient abfsClient = fs.getAbfsStore().getClient();
        AbfsClient testClient = TestAbfsClient.createTestClientFromCurrentContext(abfsClient, abfsConfig);
        AbfsRestOperation op = (AbfsRestOperation)Mockito.mock(AbfsRestOperation.class);
        Mockito.when((Object)op.isARetriedRequest()).thenReturn((Object)true);
        AbfsHttpOperation http404Op = (AbfsHttpOperation)Mockito.mock(AbfsHttpOperation.class);
        Mockito.when((Object)http404Op.getStatusCode()).thenReturn((Object)404);
        Mockito.when((Object)op.getResult()).thenReturn((Object)http404Op);
        Mockito.when((Object)op.hasResult()).thenReturn((Object)true);
        ((AbstractIntegerAssert)Assertions.assertThat((int)testClient.deleteIdempotencyCheckOp(op).getResult().getStatusCode()).describedAs("Delete is considered idempotent by default and should return success.", new Object[0])).isEqualTo(200);
        AbfsHttpOperation http400Op = (AbfsHttpOperation)Mockito.mock(AbfsHttpOperation.class);
        Mockito.when((Object)http400Op.getStatusCode()).thenReturn((Object)400);
        Mockito.when((Object)op.getResult()).thenReturn((Object)http400Op);
        Mockito.when((Object)op.hasResult()).thenReturn((Object)true);
        ((AbstractIntegerAssert)Assertions.assertThat((int)testClient.deleteIdempotencyCheckOp(op).getResult().getStatusCode()).describedAs("Idempotency check to happen only for HTTP 404 response.", new Object[0])).isEqualTo(400);
    }

    @Test
    public void testDeleteIdempotencyTriggerHttp404() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        AbfsClient client = TestAbfsClient.createTestClientFromCurrentContext(fs.getAbfsStore().getClient(), this.getConfiguration());
        LambdaTestUtils.intercept(AbfsRestOperationException.class, () -> fs.getAbfsStore().delete(new Path("/NonExistingPath"), false, this.getTestTracingContext(fs, false)));
        LambdaTestUtils.intercept(AbfsRestOperationException.class, () -> client.deletePath("/NonExistingPath", false, null, this.getTestTracingContext(fs, true)));
        AbfsClient mockClient = TestAbfsClient.getMockAbfsClient(fs.getAbfsStore().getClient(), this.getConfiguration());
        AzureBlobFileSystemStore mockStore = (AzureBlobFileSystemStore)Mockito.mock(AzureBlobFileSystemStore.class);
        mockStore = TestMockHelpers.setClassField(AzureBlobFileSystemStore.class, mockStore, "client", mockClient);
        mockStore = TestMockHelpers.setClassField(AzureBlobFileSystemStore.class, mockStore, "abfsPerfTracker", TestAbfsPerfTracker.getAPerfTrackerInstance(this.getConfiguration()));
        ((AzureBlobFileSystemStore)Mockito.doCallRealMethod().when((Object)mockStore)).delete(new Path("/NonExistingPath"), false, this.getTestTracingContext(fs, false));
        AbfsRestOperation idempotencyRetOp = TestAbfsClient.getRestOp(AbfsRestOperationType.DeletePath, mockClient, "DELETE", TestAbfsClient.getTestUrl(mockClient, "/NonExistingPath"), TestAbfsClient.getTestRequestHeaders(mockClient));
        idempotencyRetOp.hardSetResult(200);
        ((AbfsClient)Mockito.doReturn((Object)idempotencyRetOp).when((Object)mockClient)).deleteIdempotencyCheckOp((AbfsRestOperation)ArgumentMatchers.any());
        TracingContext tracingContext = this.getTestTracingContext(fs, false);
        Mockito.when((Object)mockClient.deletePath("/NonExistingPath", false, null, tracingContext)).thenCallRealMethod();
        ((AbstractIntegerAssert)Assertions.assertThat((int)mockClient.deletePath("/NonExistingPath", false, null, tracingContext).getResult().getStatusCode()).describedAs("Idempotency check reports successful delete. 200OK should be returned", new Object[0])).isEqualTo(idempotencyRetOp.getResult().getStatusCode());
        mockStore.delete(new Path("/NonExistingPath"), false, this.getTestTracingContext(fs, false));
    }
}

