/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.IOException;
import java.util.Arrays;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.SASTokenProviderException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.TokenAccessProviderException;
import org.apache.hadoop.fs.azurebfs.extensions.MockSASTokenProvider;
import org.apache.hadoop.fs.azurebfs.services.AuthType;
import org.apache.hadoop.fs.azurebfs.utils.AclTestHelpers;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.Assume;
import org.junit.Test;

public class ITestAzureBlobFileSystemAuthorization
extends AbstractAbfsIntegrationTest {
    private static final String TEST_AUTHZ_CLASS = "org.apache.hadoop.fs.azurebfs.extensions.MockSASTokenProvider";
    private static final String TEST_ERR_AUTHZ_CLASS = "org.apache.hadoop.fs.azurebfs.extensions.MockErrorSASTokenProvider";
    private static final String TEST_USER = UUID.randomUUID().toString();
    private static final String TEST_GROUP = UUID.randomUUID().toString();
    private static final String BAR = UUID.randomUUID().toString();

    public ITestAzureBlobFileSystemAuthorization() throws Exception {
        Assume.assumeTrue((this.getAuthType() == AuthType.SharedKey ? 1 : 0) != 0);
    }

    @Override
    public void setup() throws Exception {
        boolean isHNSEnabled = this.getConfiguration().getBoolean("fs.azure.test.namespace.enabled", false);
        Assume.assumeTrue((boolean)isHNSEnabled);
        this.loadConfiguredFileSystem();
        this.getConfiguration().set("fs.azure.sas.token.provider.type", TEST_AUTHZ_CLASS);
        this.getConfiguration().set("fs.azure.account.auth.type", "SAS");
        super.setup();
    }

    @Test
    public void testSASTokenProviderInitializeException() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        AzureBlobFileSystem testFs = new AzureBlobFileSystem();
        Configuration testConfig = this.getConfiguration().getRawConfiguration();
        testConfig.set("fs.azure.sas.token.provider.type", TEST_ERR_AUTHZ_CLASS);
        testConfig.set("mock.sastokenprovider.fail.init", "true");
        LambdaTestUtils.intercept(TokenAccessProviderException.class, () -> testFs.initialize(fs.getUri(), this.getConfiguration().getRawConfiguration()));
    }

    @Test
    public void testSASTokenProviderEmptySASToken() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        AzureBlobFileSystem testFs = new AzureBlobFileSystem();
        Configuration testConfig = this.getConfiguration().getRawConfiguration();
        testConfig.set("fs.azure.sas.token.provider.type", TEST_ERR_AUTHZ_CLASS);
        testConfig.set("mock.sastokenprovider.return.empty.sasToken", "true");
        testFs.initialize(fs.getUri(), this.getConfiguration().getRawConfiguration());
        LambdaTestUtils.intercept(SASTokenProviderException.class, () -> testFs.create(new Path("/testFile")));
    }

    @Test
    public void testSASTokenProviderNullSASToken() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        AzureBlobFileSystem testFs = new AzureBlobFileSystem();
        Configuration testConfig = this.getConfiguration().getRawConfiguration();
        testConfig.set("fs.azure.sas.token.provider.type", TEST_ERR_AUTHZ_CLASS);
        testFs.initialize(fs.getUri(), this.getConfiguration().getRawConfiguration());
        LambdaTestUtils.intercept(SASTokenProviderException.class, () -> testFs.create(new Path("/testFile")));
    }

    @Test
    public void testOpenFileWithInvalidPath() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        LambdaTestUtils.intercept(IllegalArgumentException.class, () -> fs.open(new Path("")).close());
    }

    @Test
    public void testOpenFileAuthorized() throws Exception {
        this.runTest(FileSystemOperations.Open, false);
    }

    @Test
    public void testOpenFileUnauthorized() throws Exception {
        this.runTest(FileSystemOperations.Open, true);
    }

    @Test
    public void testCreateFileAuthorized() throws Exception {
        this.runTest(FileSystemOperations.CreatePath, false);
    }

    @Test
    public void testCreateFileUnauthorized() throws Exception {
        this.runTest(FileSystemOperations.CreatePath, true);
    }

    @Test
    public void testAppendFileAuthorized() throws Exception {
        this.runTest(FileSystemOperations.Append, false);
    }

    @Test
    public void testAppendFileUnauthorized() throws Exception {
        this.runTest(FileSystemOperations.Append, true);
    }

    @Test
    public void testRenameAuthorized() throws Exception {
        this.runTest(FileSystemOperations.RenamePath, false);
    }

    @Test
    public void testRenameUnauthorized() throws Exception {
        this.runTest(FileSystemOperations.RenamePath, true);
    }

    @Test
    public void testDeleteFileAuthorized() throws Exception {
        this.runTest(FileSystemOperations.DeletePath, false);
    }

    @Test
    public void testDeleteFileUnauthorized() throws Exception {
        this.runTest(FileSystemOperations.DeletePath, true);
    }

    @Test
    public void testListStatusAuthorized() throws Exception {
        this.runTest(FileSystemOperations.ListPaths, false);
    }

    @Test
    public void testListStatusUnauthorized() throws Exception {
        this.runTest(FileSystemOperations.ListPaths, true);
    }

    @Test
    public void testMkDirsAuthorized() throws Exception {
        this.runTest(FileSystemOperations.Mkdir, false);
    }

    @Test
    public void testMkDirsUnauthorized() throws Exception {
        this.runTest(FileSystemOperations.Mkdir, true);
    }

    @Test
    public void testGetFileStatusAuthorized() throws Exception {
        this.runTest(FileSystemOperations.GetPathStatus, false);
    }

    @Test
    public void testGetFileStatusUnauthorized() throws Exception {
        this.runTest(FileSystemOperations.GetPathStatus, true);
    }

    @Test
    public void testSetOwnerUnauthorized() throws Exception {
        Assume.assumeTrue((boolean)this.getIsNamespaceEnabled(this.getFileSystem()));
        this.runTest(FileSystemOperations.SetOwner, true);
    }

    @Test
    public void testSetPermissionUnauthorized() throws Exception {
        Assume.assumeTrue((boolean)this.getIsNamespaceEnabled(this.getFileSystem()));
        this.runTest(FileSystemOperations.SetPermissions, true);
    }

    @Test
    public void testModifyAclEntriesUnauthorized() throws Exception {
        Assume.assumeTrue((boolean)this.getIsNamespaceEnabled(this.getFileSystem()));
        this.runTest(FileSystemOperations.ModifyAclEntries, true);
    }

    @Test
    public void testRemoveAclEntriesUnauthorized() throws Exception {
        Assume.assumeTrue((boolean)this.getIsNamespaceEnabled(this.getFileSystem()));
        this.runTest(FileSystemOperations.RemoveAclEntries, true);
    }

    @Test
    public void testRemoveDefaultAclUnauthorized() throws Exception {
        Assume.assumeTrue((boolean)this.getIsNamespaceEnabled(this.getFileSystem()));
        this.runTest(FileSystemOperations.RemoveDefaultAcl, true);
    }

    @Test
    public void testRemoveAclUnauthorized() throws Exception {
        Assume.assumeTrue((boolean)this.getIsNamespaceEnabled(this.getFileSystem()));
        this.runTest(FileSystemOperations.RemoveAcl, true);
    }

    @Test
    public void testSetAclUnauthorized() throws Exception {
        Assume.assumeTrue((boolean)this.getIsNamespaceEnabled(this.getFileSystem()));
        this.runTest(FileSystemOperations.SetAcl, true);
    }

    @Test
    public void testGetAclStatusAuthorized() throws Exception {
        Assume.assumeTrue((boolean)this.getIsNamespaceEnabled(this.getFileSystem()));
        this.runTest(FileSystemOperations.GetAcl, false);
    }

    @Test
    public void testGetAclStatusUnauthorized() throws Exception {
        Assume.assumeTrue((boolean)this.getIsNamespaceEnabled(this.getFileSystem()));
        this.runTest(FileSystemOperations.GetAcl, true);
    }

    private void runTest(FileSystemOperations testOp, boolean expectAbfsAuthorizationException) throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path reqPath = new Path("requestPath" + UUID.randomUUID().toString() + (expectAbfsAuthorizationException ? "unauthorized" : ""));
        this.getMockSASTokenProvider(fs).setSkipAuthorizationForTestSetup(true);
        if (testOp != FileSystemOperations.CreatePath && testOp != FileSystemOperations.Mkdir) {
            fs.create(reqPath).close();
            fs.getFileStatus(reqPath);
        }
        this.getMockSASTokenProvider(fs).setSkipAuthorizationForTestSetup(false);
        if (expectAbfsAuthorizationException) {
            LambdaTestUtils.intercept(SASTokenProviderException.class, () -> this.executeOp(reqPath, fs, testOp));
        } else {
            this.executeOp(reqPath, fs, testOp);
        }
    }

    private void executeOp(Path reqPath, AzureBlobFileSystem fs, FileSystemOperations op) throws IOException, IOException {
        switch (op) {
            case ListPaths: {
                fs.listStatus(reqPath);
                break;
            }
            case CreatePath: {
                fs.create(reqPath);
                break;
            }
            case RenamePath: {
                fs.rename(reqPath, new Path("renameDest" + UUID.randomUUID().toString()));
                break;
            }
            case GetAcl: {
                fs.getAclStatus(reqPath);
                break;
            }
            case GetPathStatus: {
                fs.getFileStatus(reqPath);
                break;
            }
            case SetAcl: {
                fs.setAcl(reqPath, Arrays.asList(AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, BAR, FsAction.ALL)));
                break;
            }
            case SetOwner: {
                fs.setOwner(reqPath, TEST_USER, TEST_GROUP);
                break;
            }
            case SetPermissions: {
                fs.setPermission(reqPath, new FsPermission(FsAction.ALL, FsAction.NONE, FsAction.NONE));
                break;
            }
            case Append: {
                fs.append(reqPath);
                break;
            }
            case ReadFile: {
                fs.open(reqPath);
                break;
            }
            case Open: {
                fs.open(reqPath);
                break;
            }
            case DeletePath: {
                fs.delete(reqPath, false);
                break;
            }
            case Mkdir: {
                fs.mkdirs(reqPath, new FsPermission(FsAction.ALL, FsAction.NONE, FsAction.NONE));
                break;
            }
            case RemoveAclEntries: {
                fs.removeAclEntries(reqPath, Arrays.asList(AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, BAR, FsAction.ALL)));
                break;
            }
            case ModifyAclEntries: {
                fs.modifyAclEntries(reqPath, Arrays.asList(AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, BAR, FsAction.ALL)));
                break;
            }
            case RemoveAcl: {
                fs.removeAcl(reqPath);
                break;
            }
            case RemoveDefaultAcl: {
                fs.removeDefaultAcl(reqPath);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + (Object)((Object)op));
            }
        }
    }

    private MockSASTokenProvider getMockSASTokenProvider(AzureBlobFileSystem fs) throws Exception {
        return (MockSASTokenProvider)fs.getAbfsStore().getClient().getSasTokenProvider();
    }

    static enum FileSystemOperations {
        None,
        ListPaths,
        CreatePath,
        RenamePath,
        GetAcl,
        GetPathStatus,
        SetAcl,
        SetOwner,
        SetPermissions,
        Append,
        ReadFile,
        DeletePath,
        Mkdir,
        RemoveAclEntries,
        RemoveDefaultAcl,
        RemoveAcl,
        ModifyAclEntries,
        Open;

    }
}

